window.onload = function () {
  const closeWebviewObj = {
    closeWebview: function () {
      console.log('closeWebview');
      closeWebviewObj.postMessage({
        functionName: 'mailui_closewebview',
        params: {},
      });
    },
    getJsCallId: function () {
      return 'id' + Math.random().toString(16).slice(2);
    },
    postMessage: function (message) {
      try {
        message.jsCallId = closeWebviewObj.getJsCallId();
        const json = JSON.stringify(message);
        if (closeWebviewObj.isAndroid()) {
          window.android.postMessage(json);
        }
        if (closeWebviewObj.isWebView2()) {
          window.chrome.webview.postMessage(json);
        } else if (window.chrome && window.webkit) {
          window.webkit.messageHandlers.jsOCHelper.postMessage(json);
        } else if (closeWebviewObj.isMacOS()) {
          window.webkit.messageHandlers.mailUIObj.postMessage(json);
        }
      } catch (e) {
        console.error('upgrade postMessage error', e);
      }
    },
    isAndroid: function () {
      return window.android;
    },
    isWebView2: function () {
      return window.chrome && window.chrome.webview;
    },
    isMacOS() {
      return !window.chrome && window.webkit;
    },
  };

  /**
   * after ionic inited, we will replace __zm_route_back_handler in useRouteBack.js.
   * @type {boolean}
   * @private
   */
  closeWebviewObj.closeWebview.__can_override = true;

  const backDom = document.getElementById('back');
  backDom.addEventListener('click', closeWebviewObj.closeWebview);
  if (!window.__zm_route_back_handler) {
    window.__zm_route_back_handler = closeWebviewObj.closeWebview;
  }
};
