/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
 */

if (!dojo._hasResource["dojox.charting.themes.ZMM"]) {
	dojo._hasResource["dojox.charting.themes.ZMM"] = true;
	dojo.provide("dojox.charting.themes.ZMM");
	dojo.require("dojox.gfx.gradutils");
	dojo.require("dojox.charting.Theme");
	(function() {
		var dc = dojox.charting, _1 = dc.themes, _2 = dc.Theme, g = _2.generateGradient, _3 = {
			type : "linear",
			space : "shape",
			x1 : 0,
			y1 : 0,
			x2 : 0,
			y2 : 100
		};
		_1.ZMM = new dc.Theme(
				{
//					chart : {
//						fill : {
//							type : "linear",
//							x1 : 0,
//							x2 : 0,
//							y1 : 0,
//							y2 : 100,
//							colors : [ {
//								offset : 0,
//								color : "#f7f7f7"
//							}, {
//								offset : 1,
//								color : "#dedede"
//							} ]
//						}
//					},
					plotarea : {
						fill : {
							type : "linear",
							x1 : 0,
							x2 : 0,
							y1 : 0,
							y2 : 100,
							colors : [ {
								offset : 0,
								color : "#B6D1FF"
							}, {
								offset : 1,
								color : "#f8f8ff"
							} ]
						}
					},
					axis : {
						color : "#f00",
						stroke : {
							color : "#000",
							width : 0.5
						},
						tick : {
							size : 5,
							color : "#888",
							position : "center",
							font : "normal normal normal 7pt Verdana, Arial, sans-serif",
							fontColor : "#888"
						},
						majorTick: { 
							width:  1,
							length: 4
						},
					},
					series : {
						stroke : {
							width : 1.0,
							color : "#fff"
						},
						outline : null,
						font : "normal normal normal 7pt Verdana, Arial, sans-serif",
						fontColor : "#131313"
					},
					marker : {
						stroke : {
							width : 1.25,
							color : "#131313"
						},
						outline : {
							width : 1.25,
							color : "#131313"
						},
						font : "normal normal normal 8pt Verdana, Arial, sans-serif",
						fontColor : "#131313"
					},
					seriesThemes : [ {
						fill : g(_3, "#84ad52", "#a4dd72")
					}, {
						fill : g(_3, "#94c4f8", "#94c4f8")
					}, {
						fill : g(_3, "#c257a9", "#f277c9")
					}, {
						fill : g(_3, "#3f96f2", "#94c4f8")
					}, {
						fill : g(_3, "#cccccc", "#eeeeee")
					} ],
					markerThemes : [ {
						fill : "#2a6ead",
						stroke : {
							color : "#fff"
						}
					}, {
						fill : "#613e04",
						stroke : {
							color : "#fff"
						}
					}, {
						fill : "#0e3961",
						stroke : {
							color : "#fff"
						}
					}, {
						fill : "#55aafa",
						stroke : {
							color : "#fff"
						}
					}, {
						fill : "#ad7b2a",
						stroke : {
							color : "#fff"
						}
					} ]
				});
		_1.ZMM.next = function(_4, _5, _6) {
			var _7 = _4 == "line";
			if (_7 || _4 == "area") {
				var s = this.seriesThemes[this._current
						% this.seriesThemes.length], m = this.markerThemes[this._current
						% this.markerThemes.length];
				s.fill.space = "plot";
				if (_7) {
					s.stroke = {
						width : 2,
						color : s.fill.colors[0].color
					};
				}
				m.outline = {
					width : 1.25,
					color : m.fill
				};
				var _8 = _2.prototype.next.apply(this, arguments);
				delete s.outline;
				delete s.stroke;
				s.fill.space = "shape";
				return _8;
			} else {
				if (_4 == "candlestick") {
					var s = this.seriesThemes[this._current
							% this.seriesThemes.length];
					s.fill.space = "plot";
					s.stroke = {
						width : 1,
						color : s.fill.colors[0].color
					};
					var _8 = _2.prototype.next.apply(this, arguments);
					return _8;
				}
			}
			return _2.prototype.next.apply(this, arguments);
		};
		_1.ZMM.post = function(_9, _a) {
			_9 = _2.prototype.post.apply(this, arguments);
			if ((_a == "slice" || _a == "circle") && _9.series.fill
					&& _9.series.fill.type == "radial") {
				_9.series.fill = dojox.gfx.gradutils.reverse(_9.series.fill);
			}
			return _9;
		};
	})();
}
