#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2  uv             : TEXCOORD0;
    [lowp] half4 color     : COLOR0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

    float2 pos = max(0.0, min(input.uv, maxUV));
    half4 resRGBAColor = half4(tex2D(tex, pos)) * input.color;
    output.color = float4(resRGBAColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}