#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2  uv             : TEXCOORD0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;
[material][a] property float2 pixelSize;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

#define STEP_COUNT 4 // Kernel size 15 x 15

    half gWeights[STEP_COUNT];
    gWeights[0] = 0.14961;
    gWeights[1] = 0.17021;
    gWeights[2] = 0.11628;
    gWeights[3] = 0.06390;

    float gOffsets[STEP_COUNT];
    gOffsets[0] = 0.66051;
    gOffsets[1] = 2.46556;
    gOffsets[2] = 4.43823;
    gOffsets[3] = 6.41127;

    half resColor = 0.0;

#ifdef VBLUR
    float2 pixelOffset = float2(pixelSize.x, 0.0);
#else
    float2 pixelOffset = float2(0.0, pixelSize.y);
#endif

    for(int i = 0; i < STEP_COUNT; i++)
    {
        float2 texCoordOffset = gOffsets[i] * pixelOffset;
        float2 pos1 = min(input.uv + texCoordOffset, maxUV);
        float2 pos2 = max(0.0, input.uv - texCoordOffset);

#ifdef USE_RED_TEXTURE_CHANNEL
        half color = half(tex2D(tex, pos1).r) + half(tex2D(tex, pos2).r);
#else
        half color = half(tex2D(tex, pos1).a) + half(tex2D(tex, pos2).a);
#endif

        resColor += gWeights[i] * color;
    }

    half4 resRGBAColor = half4(resColor, 1.0, 1.0, 1.0);
    output.color = float4(resRGBAColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}