#include "blending.slh"
#include "common.slh"
fragment_in
{
    float2  uv             : TEXCOORD0;
};
fragment_out
{
    float4  color : SV_TARGET0;
};
uniform sampler2D tex;
[material][a] property float2 maxUV;
[material][a] property float2 pixelSize;
[material][a] property float radius;
fragment_out fp_main(fragment_in input)
{
    fragment_out    output;
    float2 minUV = float2(0.0, 0.0);
    float accumulation = 0.0;
    half count = 0.0;

    for(float x = 0.0; x <= radius; x += 0.5)
    {
        for(float y = 0.0; y <= radius; y += 0.5)
        {
            if(x == 0.0 && y == 0.0)
            {
                accumulation += tex2D(tex, input.uv).w;
                count += 1.0;
            }
            else
            {
                float2 pos1 = input.uv + float2(x, y) * pixelSize;
                pos1 = clamp(pos1, minUV, maxUV);
                float2 pos2 = input.uv + float2(x, -y) * pixelSize;
                pos2 = clamp(pos2, minUV, maxUV);
                float2 pos3 = input.uv + float2(-x, y) * pixelSize;
                pos3 = clamp(pos3, minUV, maxUV);
                float2 pos4 = input.uv + float2(-x, -y) * pixelSize;
                pos4 = clamp(pos4, minUV, maxUV);

                accumulation += tex2D(tex, pos1).w + tex2D(tex, pos2).w + tex2D(tex, pos3).w + tex2D(tex, pos4).w;
                count += 4.0;
            }
        }
    }
    
    float resColor = accumulation / float(count);
    output.color = float4(resColor, 1.f, 1.f, 1.f);
    #include "debug-overdraw-2d.slh"
    return output;
}