#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2  uv             : TEXCOORD0;
    [lowp] half4 color     : COLOR0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;
[material][a] property float kernelScale;
[material][a] property float2 pixelSize;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;
		
    half3 colorSum = half3(tex2D(tex, input.uv + float2(-pixelSize.x, -pixelSize.y)).xyz);
	colorSum+=half3(tex2D(tex, input.uv + float2(pixelSize.x, -pixelSize.y)).xyz);
	colorSum+=half3(tex2D(tex, input.uv + float2(-pixelSize.x, pixelSize.y)).xyz);
	colorSum+=half3(tex2D(tex, input.uv + float2(pixelSize.x, pixelSize.y)).xyz);
	
	half3 resColor = colorSum/4.0;
		
    half4 resRGBAColor = half4(resColor, 1.0) * input.color;
    output.color = float4(resRGBAColor);
    return output;
}