#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2 uv : TEXCOORD0;
    [lowp] half4 color : COLOR0;
};
fragment_out
{
    float4 color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float saturation;

fragment_out fp_main(fragment_in input)
{
    fragment_out output;
    half4 in_color = input.color;
    half v = half(clamp(saturation/100.0, -1.0,1.0));
    half4 resColor = half4(tex2D(tex, input.uv));
    resColor = resColor * in_color;

    half gray = dot(resColor.xyz, half3(0.2126, 0.7152, 0.0722));
    resColor.xyz += (resColor.xyz - gray) * v;

    output.color = float4(resColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}