#include "blending.slh"
#include "common.slh"

#if VIEW_MODE_OVERDRAW_HEAT
    blending { src=one dst=one }
#else
    blending { src=dst_color dst=zero }
#endif

fragment_in
{
    float2  uv             : TEXCOORD0;
    [lowp] half4 color     : COLOR0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

    half alpha = half(tex2D(tex, input.uv).w);
	
	if( alpha > 0.0 )
	{
		alpha = 1.0;
	}
	
    half4 resRGBAColor = half4(1.0, 1.0, 1.0, alpha) * input.color;
    output.color = float4(resRGBAColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}