#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2 uv : TEXCOORD0;
    [lowp] half4 color : COLOR0;
};
    
fragment_out
{
    float4 color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float hue;
[material][a] property float saturation;
[material][a] property float value;
[material][a] property float progress;

half3 rgb2hsv(half3 c)
{
    half4 K = half4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    half4 p = c.g < c.b ? half4(c.bg, K.wz) : half4(c.gb, K.xy);
    half4 q = c.r < p.x ? half4(p.xyw, c.r) : half4(c.r, p.yzx);

    half d = q.x - min(q.w, q.y);
    half eps = 1.0e-4;
    return half3(abs(q.z + (q.w - q.y) / (half(6.0) * d + eps)), d / (q.x + eps), q.x);
}

half3 hsv2rgb(half3 c)
{
    half4 K = half4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    half3 p = abs(frac(c.xxx + K.xyz) * half(6.0) - K.www);
    return c.z * lerp(K.xxx, clamp(p - K.xxx, half(0.0), half(1.0)), c.y);
}

fragment_out fp_main(fragment_in input)
{
    fragment_out output;

    half3 hsv = half3(hue, saturation, value);

    half4 in_color = input.color;

    half4 resColor = half4(tex2D(tex, input.uv));
    resColor = resColor * in_color;

    half4 srcColor = resColor;

    half3 hsvColor = rgb2hsv(resColor.rgb);

    hsvColor.x = fmod(hsvColor.x * half(360.0) + hsv.x, half(360.0)) / half(360.0);

    hsvColor.yz += hsvColor.yz * half2(hsv.y/half(100.0), hsv.z/half(100.0));
    hsvColor.yz = clamp(hsvColor.yz, half(0.0), half(1.0));

    resColor.rgb = hsv2rgb(hsvColor);

    output.color = input.uv.x > progress ? float4(resColor) : float4(srcColor);

    #include "debug-overdraw-2d.slh"
    return output;
}