#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2  uv             : TEXCOORD0;
    [lowp] half4 color     : COLOR0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;
[material][a] property float2 pixelSize;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

#define STEP_COUNT 2 // Kernel size 7 x 7

    half gWeights[STEP_COUNT];
    gWeights[0] = 0.25772;
    gWeights[1] = 0.24228;

    float gOffsets[STEP_COUNT];
    gOffsets[0] = 0.65278;
    gOffsets[1] = 2.42326;

    half3 resColor = half3(0.0, 0.0, 0.0);

#ifdef VBLUR
    float2 pixelOffset = float2(pixelSize.x, 0.0);
#else
    float2 pixelOffset = float2(0.0, pixelSize.y);
#endif

    for(int i = 0; i < STEP_COUNT; i++)
    {
        float2 texCoordOffset = gOffsets[i] * pixelOffset;
        float2 pos1 = min(input.uv + texCoordOffset, maxUV);
        float2 pos2 = max(0.0, input.uv - texCoordOffset);
        half3 color = half3(tex2D(tex, pos1).xyz) + half3(tex2D(tex, pos2).xyz);
        resColor += gWeights[i] * color;
    }

    half4 resRGBAColor = half4(resColor, 1.0) * input.color;
    output.color = float4(resRGBAColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}