#include "blending.slh"
#include "common.slh"

#if VIEW_MODE_OVERDRAW_HEAT
    blending { src=one dst=one }
#else
    blending { src=dst_color dst=zero }
#endif

fragment_in
{
    float2  uv             : TEXCOORD0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float2 maxUV;

fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

    float alphaMaskValue = tex2D(tex, input.uv).w;
    output.color = float4(1.0, 1.0, 1.0, alphaMaskValue);
    
    #include "debug-overdraw-2d.slh"
    return output;
}