#include "blending.slh"
#include "common.slh"

fragment_in
{
    float2  uv             : TEXCOORD0;
    [lowp] half4 color     : COLOR0;
};
    
fragment_out
{
    float4  color : SV_TARGET0;
};

uniform sampler2D tex;
[material][a] property float maxU;
	
fragment_out fp_main(fragment_in input)
{
    fragment_out    output;

    half4 color = half4(tex2D(tex, input.uv));
	
	half dist = max(abs(maxU - input.uv.x*2.0), 0.0);
	
	half alpha = half(min(color.w, dist));
	
	half4 resRGBAColor = half4(color.xyz, alpha) * input.color;
	
    output.color = float4(resRGBAColor);
    
    #include "debug-overdraw-2d.slh"
    return output;
}