package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class XmlResponseReceivedAnalyticsEvent(val taskId: String, val modelName: String = "") : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("task_id" to taskId, "model_name" to modelName)
  companion object {
    private const val EVENT_NAME_KEY: String = "xml_response_received"
  }
}
