package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class WidgetShownAnalyticsEvent(val widgetName: String) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("widget_name" to widgetName)
  companion object {
    private const val EVENT_NAME_KEY: String = "widget_shown"
  }
}
