package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class ToggleSelectionAnalyticsEvent(
    val context: EventContext,
    val viewId: String,
    val isSelected: Boolean,
    val type: ToggleSelectionAnalyticsEvent.Type,
    val omsName: String = ""
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "view_id" to viewId, "is_selected" to isSelected.toString(), "type" to type.type, "oms_name" to omsName)

  enum class Type(val type: String) {
    TOGGLE("toggle"),

    CHECKBOX("checkbox");
  }
  companion object {
    private const val EVENT_NAME_KEY: String = "toggle_selection"
  }
}
