package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class SessionDataUsageAnalyticsEvent(val dataUsedBytes: Long, val networkConnectionType: String) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("data_used_bytes" to dataUsedBytes, "network_connection_type" to networkConnectionType)
  companion object {
    private const val EVENT_NAME_KEY: String = "session_data_usage"
  }
}
