package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class SessionBatteryUsageAnalyticsEvent(val batteryUsedMah: Long) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("battery_used_mah" to batteryUsedMah)
  companion object {
    private const val EVENT_NAME_KEY: String = "session_battery_usage"
  }
}
