package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class SearchAnalyticsEvent(
    val context: EventContext,
    val viewId: String,
    val searchQuery: String,
    val resultCount: Long
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "view_id" to viewId, "search_query" to searchQuery, "result_count" to resultCount)
  companion object {
    private const val EVENT_NAME_KEY: String = "search"
  }
}
