package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class ScrollAnalyticsEvent(
    val context: EventContext,
    val viewId: String,
    val direction: ScrollAnalyticsEvent.Direction
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "view_id" to viewId, "direction" to direction.direction)

  enum class Direction(val direction: String) {
    VERTICAL("vertical"),

    HORIZONTAL("horizontal"),

    DIAGONAL("diagonal");
  }
  companion object {
    private const val EVENT_NAME_KEY: String = "scroll"
  }
}
