package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class RefreshTimeAnalyticsEvent(
    val pageName: String,
    val viewId: String,
    val timeElapsedMillis: Long
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("page_name" to pageName, "view_id" to viewId, "time_elapsed_millis" to timeElapsedMillis)
  companion object {
    private const val EVENT_NAME_KEY: String = "refresh_time"
  }
}
