package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class PageViewAnalyticsEvent(val pageName: String) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("page_name" to pageName)
  companion object {
    private const val EVENT_NAME_KEY: String = "page_view"
  }
}
