package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class NetworkCallAnalyticsEvent(
    val context: EventContext,
    val httpMethod: String,
    val uri: String,
    val timeElapsedMillis: Long,
    val statusCode: Long,
    val statusMessage: String
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "http_method" to httpMethod, "uri" to uri, "time_elapsed_millis" to timeElapsedMillis, "status_code" to statusCode, "status_message" to statusMessage)
  companion object {
    private const val EVENT_NAME_KEY: String = "network_call"
  }
}
