package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class ModelNotRecognizedAnalyticsEvent(val modelName: String, val taskId: String) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("model_name" to modelName, "task_id" to taskId)
  companion object {
    private const val EVENT_NAME_KEY: String = "model_not_recognized"
  }
}
