package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class ModelAttributeNotRecognizedAnalyticsEvent(
    val attributeName: String,
    val attributeType: String,
    val modelName: String,
    val taskId: String
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("attribute_name" to attributeName, "attribute_type" to attributeType, "model_name" to modelName, "task_id" to taskId)
  companion object {
    private const val EVENT_NAME_KEY: String = "model_attribute_not_recognized"
  }
}
