package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class LongPressAnalyticsEvent(
    val context: EventContext,
    val viewId: String,
    val omsName: String = "",
    val taskId: String = ""
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "view_id" to viewId, "oms_name" to omsName, "task_id" to taskId)
  companion object {
    private const val EVENT_NAME_KEY: String = "long_press"
  }
}
