package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class GeneralAnalyticsEvent(
    val context: EventContext,
    val eventName: String,
    val parameter1: String,
    val parameter2: String,
    val parameter3: String,
    val parameter4: String
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "event_name" to eventName, "parameter1" to parameter1, "parameter2" to parameter2, "parameter3" to parameter3, "parameter4" to parameter4)
  companion object {
    private const val EVENT_NAME_KEY: String = "general"
  }
}
