package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class FormSubmitAnalyticsEvent(
    val context: EventContext,
    val formId: String,
    val response: String
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "form_id" to formId, "response" to response)
  companion object {
    private const val EVENT_NAME_KEY: String = "form_submit"
  }
}
