package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class DialogAnalyticsEvent(
    val context: EventContext,
    val isToast: Boolean = false,
    val messageId: String,
    val userResponse: DialogAnalyticsEvent.UserResponse,
    val isError: Boolean = false,
    val errorType: String = ""
) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("context" to context.eventContext, "is_toast" to isToast.toString(), "message_id" to messageId, "user_response" to userResponse.userResponse, "is_error" to isError.toString(), "error_type" to errorType)

  enum class UserResponse(val userResponse: String) {
    DISMISS("dismiss"),

    PRIMARY("primary"),

    SECONDARY("secondary");
  }
  companion object {
    private const val EVENT_NAME_KEY: String = "dialog"
  }
}
