package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class ContentLoadTimeAnalyticsEvent(val contentName: String, val timeElapsedMillis: Long) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("content_name" to contentName, "time_elapsed_millis" to timeElapsedMillis)
  companion object {
    private const val EVENT_NAME_KEY: String = "content_load_time"
  }
}
