package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class AppVersionAnalyticsEvent(val version: Long) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("version" to version)
  companion object {
    private const val EVENT_NAME_KEY: String = "app_version"
  }
}
