package com.workday.analytics

import com.workday.analytics.common.AnalyticsEvent
import kotlin.Any
import kotlin.Long
import kotlin.Pair
import kotlin.String
import kotlin.collections.List

data class AppStartupAnalyticsEvent(val startupType: AppStartupAnalyticsEvent.StartupType, val timeElapsedMillis: Long) : AnalyticsEvent {
  override val name: String = EVENT_NAME_KEY

  override val params: List<Pair<String, Any>>
    get() = listOf("startup_type" to startupType.startupType, "time_elapsed_millis" to timeElapsedMillis)

  enum class StartupType(val startupType: String) {
    COLD("cold"),

    WARM("warm");
  }
  companion object {
    private const val EVENT_NAME_KEY: String = "app_startup"
  }
}
