-- This query pulls locations from a table where LocationStore writes to, the data is kept for at least 180 days
SELECT
    msg.location.provider as dataSource,
    msg.location.epoch,
    msg.location.deviceEpoch as "timestamp",
    msg.location.latitude,
    msg.location.longitude,
    msg.location.altitude,
    msg.location.verticalAccuracy as verticalAccuracy,
    msg.location.course as heading,
    msg.location.courseaccuracy as headingUncertainty,
    msg.location.horizontalAccuracy as horizontalAccuracy,
    msg.location.speed,
    msg.location.speedaccuracy as speedUncertainty
from
   rawdata.kafka_hp_location_store_unfitted_driver_location_update_nodedup
WHERE
  datestr >= '{{datestr_start}}'
  AND datestr <= '{{datestr_end}}'
  AND msg.jobUUID = '{{jobUUID}}'
ORDER BY msg.location.deviceEpoch
;
