//
//  PrecipShader.fsh
//  PangeaSDK
//
//  Created by Roman Borovyk on 11/18/13.
//  Copyright (c) 2013 Radius. All rights reserved.
//

precision mediump float;

varying highp vec2 vRadarTexCoord;
varying highp vec2 vRadarMotionTexCoord;

uniform sampler2D radarTexture;
uniform highp float radarTextureSize;
uniform sampler2D radarMotionTexture;
uniform sampler2D paletteTexture;

uniform highp float timeOffset;
uniform int intervalMinutes;
uniform float opacity;

const highp vec2 kHalfVec2 = vec2(0.5, 0.5);

void main() {
    vec4 radarAndTemp = texture2D(radarTexture, vRadarTexCoord);
    float radar = radarAndTemp.r + (0.5 / 64.0);

    vec2 origTexCoord = vRadarTexCoord * radarTextureSize;
    vec2 exactTexCoord = floor(origTexCoord) + kHalfVec2;
    vec2 altTexCoord = floor(exactTexCoord + normalize(origTexCoord - exactTexCoord)) + kHalfVec2;
    float exactTemp = texture2D(radarTexture, exactTexCoord / radarTextureSize).g;
    float altTemp = texture2D(radarTexture, altTexCoord / radarTextureSize).g;
    exactTemp = abs(exactTemp - radarAndTemp.g) / abs(altTemp - exactTemp) < 0.5 ? exactTemp : altTemp;

    vec4 paletteColor = texture2D(paletteTexture, vec2(radar, 1.0 - (exactTemp + 0.5 / 4.0)));
    gl_FragColor = vec4(paletteColor.rgb, paletteColor.a * opacity);
}
