function validatePin(pin) {
	return RE_services["PIN"].test(pin);
}

function validateEtPin(pin) {
	return RE_services["ET_PIN"].test(pin);
}

function validateEkycPin(pin) {
	return RE_services["EKYCPIN"].test(pin);
}

function validateAcctNum(num, RE_acctNo) {
	return RE_acctNo.test(num);
}

//added new function for validation
function validateValue(num, RE_acctNo) {
	return RE_acctNo.test(num);
}

function validateAmt(amt) {
	if (!RE_services["AMOUNT"].test(amt)) {
		return false;
	}
	if (amt < 1) {
		return false;
	}
	return true;
}

function validateMsisdn(msisdn) {
	return RE_services["MSISDN"].test(msisdn);
}

function validateTune(tune) {
	if (!RE_services["BTUNE"].test(tune)) {
		return false;
	}
	return true;
}
/*
function validateTransferAmount(amount)
{
	if(amount<1)
	{
		return false;
	}
	if(!RE_amount_transfer.test(amount))
	{
		return false;
	}
	return true;
}
*/

/*
function validateTopupAmount(amount)
{
	if(amount<1)
	{
		return false;
	}
	if(!RE_amount_topup.test(amount))
	{
		return false;
	}
	return true;
}
*/

/*	
function validateAccount(account)
{
	return RE_account.test(account);
}
*/

function validateOTP(otp) {
	return RE_services["OTP"].test(otp);
}

function validateRMAOTP(otp) {
	return RE_services["RMAOTP"].test(otp);
}
/*	
function validateComment(comment)
{
	return RE_otp.test(otp);
}
*/

function onlyNumberHandler($elementObj) {
	numVal = $elementObj.val();
	if (!/^[0-9]+$/.test(numVal)) {
		$elementObj.val(numVal.replace(/[^0-9]/g, ""));
	}
}

function onlyDecimalNumberHandler($elementObj, caret, regExp) {
	numVal = $elementObj.val();
	console.log(regExp);
	if (regExp == null || regExp == "" || regExp == undefined) {
		regExp = /^[1-9][0-9]{0,4}(\.[0-9]{0,2})?$/;
	}
	console.log("regEx for calidate .js================== " + regExp);
	if (!(regExp.test(numVal))) {
		var newStr = numVal.substring(0, caret - 1) + numVal.substring(caret, numVal.length);
		$elementObj.val(newStr);
		//$elementObj.setSelectionRange(caret, caret);
		//setCaretPosition(document.getElementById("amount"),caret-1);
		setCaretPosition($elementObj[0], caret - 1);
	}
}

/*
function onlyAlphaNumericHandler($elementObj)
{
	numVal = $elementObj.val();
	if(!RE_onlyAlphaNumericHandler.test(numVal))
	{
		$elementObj.val(numVal.replace(RE_onlyAlphaNumericCheck,""));
	}
}
*/

function setCaretPosition(ctrl, pos) {
	if (ctrl.setSelectionRange) {
		ctrl.focus();
		ctrl.setSelectionRange(pos, pos);
	}
	else if (ctrl.createTextRange) {
		var range = ctrl.createTextRange();
		range.collapse(true);
		range.moveEnd('character', pos);
		range.moveStart('character', pos);
		range.select();
	}
}

/*
function accountNumberHandler($elementObj,caret)
{
	numVal = $elementObj.val();
	if(!/^[A-Za-z0-9_\-@]{0,20}$/.test(numVal))
	{
		var newStr = numVal.substring(0,caret - 1) + numVal.substring(caret, numVal.length);
		$elementObj.val(newStr);
		//$elementObj.setSelectionRange(caret, caret);
		//setCaretPosition(document.getElementById("amount"),caret-1);
		setCaretPosition($elementObj[0],caret-1);
	}
}
*/

function validateMsisdnPaste(value) {
	var RE_pastedMsisdn = /^[0-9]{1,8}$/;
	return RE_pastedMsisdn.test(value);
}

function validatePinPaste(value) {
	var RE_pastedPin = /^[0-9]{1,4}$/;
	return RE_pastedPin.test(value);
}

function validateEtPinPaste(value) {
	var RE_pastedPin = /^[0-9]{1,6}$/;
	return RE_pastedPin.test(value);
}

function validateOtpPaste(value) {
	var RE_pastedOtp = /^[0-9]{1,6}$/;
	return RE_pastedOtp.test(value);
}

function validateDecimalAmountPaste(value) {
	var RE_pastedDecimalAmount = /^[0-9]{1,5}\.{0,1}[0-9]{0,2}$/;
	return RE_pastedDecimalAmount.test(value);
}

function validateBankAccountPaste(value, maxLength) {
	var RE_pastedBankAcct = /^[0-9]{1,15}$/;
	if (!RE_pastedDecimalAmount.test(value)) {
		return false;
	}
	if (value.length > maxLength) {
		return false;
	}
	return true;
}

function validateBpcPaste(value) {
	var RE_pastedBpc = /^[0-9]{1,10}$/;
	return RE_pastedBpc.test(value);
}

function validateBBPaste(value) {
	var RE_pastedBpc = /^[A-Za-z0-9]{1,20}$/;
	return RE_pastedBpc.test(value);
}
function validateEmail(email) {

	return RE_email.test(email);
}
function validateComplaintDesc(desc) {

	return RE_compaintDesc.test(desc);
}
