/* Intent actions
	1 : Recharge
	2 : Postpaid
	3 : Land line bill
	
*/
var myBWALLET = {
	sessionId: "",
	userName: "",
	sourceParty: "",
	nameTitle: "",
	firstName: "",
	midName: "",
	lastName: "",
	isLoggedIn: false,
	queryRefId: "",
	$homeDiv: "",
	$serviceDiv: "",
	afterLoginAction: "",
	afterLoginExtra: "",
	walletType: "2",
	QUERY_PROFILE: {},
	stakeType: "",
	GLOBAL_TRANS_DATA: {},
	clearLoginData: function () {
		myBWALLET.sessionId = "";
		myBWALLET.userName = "";
		myBWALLET.sourceParty = "";
		myBWALLET.nameTitle = "";
		myBWALLET.firstName = "";
		myBWALLET.midName = "";
		myBWALLET.lastName = "";
		myBWALLET.isLoggedIn = false;
		myBWALLET.queryRefId = "";
		myBWALLET.QUERY_PROFILE = {},
			myBWALLET.GLOBAL_TRANS_DATA = {};
	},

	loadLogin: function (isImmediateShow) {
		$bw_homeDiv.load("bw_login.html", function () {
			if (isImmediateShow) {
				myBWALLET.showLogin();
			}
			var $input1 = $("#bw_input1");
			var $input2 = $('#bw_input2');
			$input1.keyup(function (e) {
				onlyNumberHandler($input1);
				if ($input1.val().length == bw_destNumMaxLenHash.MSISDN) {
					if (!validateMsisdn($input1.val())) {
						$("#bw_input1Help").attr("data-error", MSG_INVALID_MOB_NUM);
						$("#bw_input1").addClass("invalid");
						$("#bw_input1").focus();
						return false;
					}
					else {
						$("#bw_input1").removeClass("invalid");
						$input2.focus();
					}
				}
			});
			$input2.keyup(function (e) {
				onlyNumberHandler($input2);
				if ($input2.val().length == bw_destNumMaxLenHash.PIN) {
					Keyboard.hide();
					myBWALLET.login();
				}
			});

			$input1.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validateMsisdnPaste(data)) {
					e.preventDefault();
				}
			});

			$input2.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});

			$("#bw_action1").click(function () {
				myBWALLET.login();
			});
		});
	},
	showLogin: function () {
		var lastLoggedMsisdn = localStorage.getItem("BW_LOGGEDMSISDN");
		var $input1 = $("#bw_input1");
		var $input2 = $('#bw_input2');

		NAVIGATION.showFooter();
		$bw_homeDiv.fadeIn(150);
		setTimeout(function () {
			if (myBWALLET.sourceParty != "") {
				$input1.val(myBWALLET.sourceParty);
				//$input2.focus();
			}
			else if (lastLoggedMsisdn != null) {
				$input1.val(lastLoggedMsisdn);
				//$input2.focus();
			}
			else {
				//$input1.focus();
			}
			M.updateTextFields();
			//Keyboard.show();
		}, 150);
		NAVIGATION.setPage(1);
	},
	goToTransHist: function () {
		$bw_serviceDiv.load("bw_transHist.html", function () {
			$bw_homeDiv.hide();
			var $input1 = $("#bw_input1");
			var $input2 = $("#bw_input2");
			var today = new Date();
			var bodyElement = document.getElementsByTagName("body")[0];

			$input1.datepicker({
				format: 'dd/mm/yyyy',
				defaultDate: today,
				setDefaultDate: true,
				minDate: CONFIG_transHistMinDate,
				maxDate: today,
				yearRange: 1,
				container: "body",
				showClearBtn: false,
				onClose: function (date) {
					//alert(date);
					/*$input1.datepicker("setDate",date);
					$input1.datepicker("close");*/
				}
			});

			$input2.datepicker({
				format: 'dd/mm/yyyy',
				defaultDate: today,
				setDefaultDate: true,
				minDate: CONFIG_transHistMinDate,
				maxDate: today,
				yearRange: 1,
				container: "body",
				showClearBtn: false
			});

			//$input1.datepicker("setDate",today);
			//$input2.datepicker("setDate",today);

			var dateString = ("0" + today.getDate()).slice(-2) + "/" + ("0" + (today.getMonth() + 1)).slice(-2) + "/" + today.getFullYear();

			//alert(dateString);
			$input1.val(dateString);
			$input2.val(dateString);
			$bw_serviceDiv.fadeIn(150);
		});
		NAVIGATION.setService("502");
		NAVIGATION.fromHome("502");
		NAVIGATION.setPage(4);
	},
	getTransHist: function () {
		var fromDate = $("#bw_input1").val();
		var dateParts = fromDate.split("/");
		if (dateParts.length < 3) {
			DIALOG_alert(MSG_FROM_DATE_MISSING, dummy, CONFIG_notifyHead["alert"], 'Ok');
			return false;
		}
		var fd = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);
		fromDate = fromDate.replace(/\//g, "-");

		var toDate = $("#bw_input2").val();
		dateParts = toDate.split("/");
		if (dateParts.length < 3) {
			DIALOG_alert(MSG_TO_DATE_MISSING, dummy, CONFIG_notifyHead["alert"], 'Ok');
			return false;
		}
		var td = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);
		toDate = toDate.replace(/\//g, "-");

		//alert((td-fd)/(1000*60*60*24));
		if (td < fd) {
			DIALOG_alert(MSG_INVALID_TO_DATE, dummy, CONFIG_notifyHead["alert"], 'Ok');
			return false;
		}
		else if ((td - fd) / (1000 * 60 * 60 * 24) > CONFIG_transHistMaxRange[NAVIGATION.platform]) {
			DIALOG_alert(MSG_MAX_DATE_RANGE.replace("<_RANGE_>", CONFIG_transHistMaxRange[NAVIGATION.platform]), dummy, CONFIG_notifyHead["alert"], 'Ok');
			return false;
		}

		$("#transList").html('');
		postData("330", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Transaction history", "FROMDATE": fromDate, "TODATE": toDate, "TXNDETAILS": "1", "NONTXNDETAILS": "1" });
	},
	showTransHist: function (isSuccess, transDetails) {
		var finalHtml = "";
		if (!isSuccess) {
			finalHtml = "<li class='collection-item'><p style='text-align:center;font-weight:700;font-size:18px;opacity:0.84;color:#F44336'>No records found</p></li>";
		}
		else {
			var transHtml = "<li class='collection-item'> <span class='title tss-transHistTitle'>__SERV_NAME__</span> <span class='title right tss-transHistTitle' style='color:#__AMOUNT_COLOR__'> __SIGN__ " + CONFIG_currency + "  __AMOUNT__</span><br> <p class='tss-nomargin'> <span class='tss--text-body1'>From : __FROM__</span><br> <span class='tss--text-body1'>To : __TO__</span><span class='new badge tss-transBadge' style='color: #000;background: none;border:  1px solid rgba(0,0,0,0.5);' data-badge-caption='via __MODE__'></span><br> <span class='tss--text-body1'>TXID : __TX_ID__</span><br> <span class='tss--text-body1'>__DATE_TIME__</span><span class='new badge tss-transBadge' style='background:#__BADGE_COLOR__;' data-badge-caption='__BADGE_TEXT__'></span> </p> </li>";

			var additionalNameHash = { "1": "(Prepaid)", "2": "(Postpaid)", "": "" };

			var transDetailsLen = transDetails.length;

			for (var i = 0; i < transDetailsLen; i++) {
				tempHtml = transHtml;
				//alert(transDetails[i].SERVNAME + "     |" +transDetails[i].ADD_PARAM + "|");
				//var additionalName = additionalNameHash[transDetails[i].ADD_PARAM];
				var additionalName = ""

				tempHtml = tempHtml.replace(/__SERV_NAME__/, SERVICENAME_HASH[NAVIGATION.platform][transDetails[i].SERVICEID] + "" + additionalName);
				tempHtml = tempHtml.replace(/__AMOUNT__/, transDetails[i].AMOUNT);
				tempHtml = tempHtml.replace(/__TX_ID__/, transDetails[i].TRANSID);
				tempHtml = tempHtml.replace(/__DATE_TIME__/, transDetails[i].DATETIME);
				//tempHtml = tempHtml.replace(/__FROM__/,"HBN" + "-" + transDetails[i].SERVICEDETAILS.ACCOUNTNO);
				tempHtml = tempHtml.replace(/__FROM__/, transDetails[i].BANKACCOUNT.SRCBANK + "-" + transDetails[i].BANKACCOUNT.SRCBANKACCOUNT);
				if (transDetails[i].WALLETDETAILS.OTHERMSISDN != "") {
					tempHtml = tempHtml.replace(/__TO__/, transDetails[i].WALLETDETAILS.OTHERMSISDN);
				}
				if (transDetails[i].SERVICEDETAILS.SERVICENO != "") {
					tempHtml = tempHtml.replace(/__TO__/, transDetails[i].SERVICEDETAILS.SERVICENO);
				}
				if (transDetails[i].BANKACCOUNT.DESTBANKACCOUNT != "") {
					tempHtml = tempHtml.replace(/__TO__/, transDetails[i].BANKACCOUNT.DESTBANK + "-" + transDetails[i].BANKACCOUNT.DESTBANKACCOUNT);
				}
				tempHtml = tempHtml.replace(/__MODE__/, CONFIG_requestMode[transDetails[i].REQMODETYPE]);

				if (transDetails[i].STATUS == 1) //success
				{

					tempHtml = tempHtml.replace(/__BADGE_COLOR__/, '4CAF50');
					tempHtml = tempHtml.replace(/__BADGE_TEXT__/, 'Success');

				}
				else if ((transDetails[i].STATUS == 2))	// failed
				{

					tempHtml = tempHtml.replace(/__BADGE_COLOR__/, 'F44336');
					tempHtml = tempHtml.replace(/__BADGE_TEXT__/, 'Failed');
					tempHtml = tempHtml.replace(/__SIGN__/, '');
				}
				else	// Pending
				{

					tempHtml = tempHtml.replace(/__BADGE_COLOR__/, 'FF9800');
					tempHtml = tempHtml.replace(/__BADGE_TEXT__/, 'Pending');
				}
				if (transDetails[i].DRCRFLAG == "1") {
					tempHtml = tempHtml.replace(/__FROM__/, myBWALLET.sourceParty);
					if (transDetails[i].WALLETDETAILS.OTHERMSISDN != "") {
						tempHtml = tempHtml.replace(/__TO__/, transDetails[i].WALLETDETAILS.OTHERMSISDN);
					}
					if (transDetails[i].SERVICEDETAILS.SERVICENO != "") {
						tempHtml = tempHtml.replace(/__TO__/, transDetails[i].SERVICEDETAILS.SERVICENO);
					}
					if (transDetails[i].BANKACCOUNT.DESTBANKACCOUNT != "") {
						tempHtml = tempHtml.replace(/__TO__/, transDetails[i].BANKACCOUNT.DESTBANK + "-" + transDetails[i].BANKACCOUNT.DESTBANKACCOUNT);
					}
					tempHtml = tempHtml.replace(/__SIGN__/, '-');
					tempHtml = tempHtml.replace(/__AMOUNT_COLOR__/, 'F44336');
				}
				if (transDetails[i].DRCRFLAG == "0") {
					tempHtml = tempHtml.replace(/__TO__/, myBWALLET.sourceParty);
					if (transDetails[i].WALLETDETAILS.OTHERMSISDN != "") {
						tempHtml = tempHtml.replace(/__FROM__/, transDetails[i].WALLETDETAILS.OTHERMSISDN);
					}
					if (transDetails[i].SERVICEDETAILS.SERVICENO != "") {
						tempHtml = tempHtml.replace(/__FROM__/, transDetails[i].SERVICEDETAILS.SERVICENO);
					}
					if (transDetails[i].BANKACCOUNT.DESTBANKACCOUNT != "") {
						tempHtml = tempHtml.replace(/__FROM__/, transDetails[i].BANKACCOUNT.DESTBANK + "-" + transDetails[i].BANKACCOUNT.DESTBANKACCOUNT);
					}
					tempHtml = tempHtml.replace(/__SIGN__/, '+');
					tempHtml = tempHtml.replace(/__AMOUNT_COLOR__/, '4CAF50');
				}
				finalHtml += tempHtml;
			}
			finalHtml += "<li class='collection-item'><p class='tss-transHistEnd'>" + MSG_TRANS_HIST_END + "</p></li>";
		}
		$("#transList").html(finalHtml);
	},
	getBanks: function () {
		postData("970", { "SRCMSISDN": myBWALLET.sourceParty, "SERVICENO": myBWALLET.sourceParty, "DESCRIPTION": "Get Bank Details", "SERVICEID": "114" });
	},
	showHomePage: function () {
		$bw_serviceDiv.hide();
		NAVIGATION.toHome();
		$bw_homeDiv.fadeIn(150);
		$bw_serviceDiv.html('');
		NAVIGATION.setPage(3);
		NAVIGATION.setService("0");
	},
	refreshHomePage: function () {
		$bw_serviceDiv.hide();
		NAVIGATION.toHome();
		$bw_homeDiv.fadeIn(150);
		$bw_serviceDiv.html('');
		NAVIGATION.setPage(3);
		NAVIGATION.setService("0");
		myBWALLET.GLOBAL_TRANS_DATA["REFRESHDATA"] = true
		postData("80", { 'SRCMSISDN': myBWALLET.sourceParty, 'MPIN': "", "INCLUDEACCOUNTDETAILS": "1", "INCLUDECONTACTINFORMATION": "1", "INCLUDESERVICEDETAILS": "1" });
	},
	upDateData: function (queryProfileStr) {
		BANKNAME_HASH = {};
		var bankJson = {}
		for (var i = 0; i < queryProfileStr.SERVICEDETAILS.BANK.length; i++) {
			var bJson = queryProfileStr.SERVICEDETAILS.BANK[i];
			//alert("BANK JSON = \n" + JSON.stringify(bJson));
			var bankAccountNum = "";
			if (bJson.BANKACCOUNTDETAILS[0].BANKACCOUNTNO == "") {
				bankAccountNum = "PG";
			}
			else {
				bankAccountNum = bJson.BANKACCOUNTDETAILS[0].BANKACCOUNTNO;
			}
			bankJson[bJson.BANKID] = { "BANKNAME": bJson.BANKNAME, "BANKACCOUNTNO": bankAccountNum };

			BANKNAME_HASH[bJson.BANKID] = bJson.BANKNAME;
			//alert(BANKNAME_HASH[json.BANKLIST[i].BANKID]);

		}
		//alert("BANK JSON = \n" + JSON.stringify(bankJson));
		var serviceStringLength = queryProfileStr.SERVICEDETAILS.SERVICES.length;
		QUERY_PROFILE = {};
		for (var i = 0; i < serviceStringLength; i++) {
			var json = queryProfileStr.SERVICEDETAILS.SERVICES[i];
			var serviceId = json.SERVICEID;
			var test = {};
			var bankJsonLen = json.BANKREFERENCE.length;

			for (var j = 0; j < bankJsonLen; j++) {
				//alert(JSON.stringify(json.BANKREFERENCE[j]));
				var bankID = json.BANKREFERENCE[j].BANKID;
				var bankRefId = json.BANKREFERENCE[j].BANKREFERENCEID;
				test['BANKLIST'] = test['BANKLIST'] || {};
				var servnum = "", acctName = "";
				if (json.SUBSCRIPTIONDETAILS.length > 0) {
					servnum = json.SUBSCRIPTIONDETAILS[0].SERVICENO;
					acctName = json.SUBSCRIPTIONDETAILS[0].ACCOUNTNAME;
				}

				if (serviceId == "31" || serviceId == 31) {
					var interBnktest = {};
					var intetBankTransFlag = "0";

					if (json.BANKREFERENCE[j].INTERBANKTRANSFER && json.BANKREFERENCE[j].INTERBANKTRANSFER == "1") {
						intetBankTransFlag = json.BANKREFERENCE[j].INTERBANKTRANSFER;
						var interBanks = json.BANKREFERENCE[j].DESTINATIONBANKS;
						for (var k = 0; k < interBanks.length; k++) {
							interBnktest[interBanks[k].BANKID] = interBanks[k].BANKNAME;
						}
					}
					test['BANKLIST'][bankID] = { "BANKACCTNO": bankJson[bankID].BANKACCOUNTNO, "BANKACCTNOMASK": bankJson[bankID].BANKACCOUNTNO, "BNKACCTID": "", "SERVNUM": servnum, "SERVNUM2": servnum, "BANKREFERENCEID": bankRefId, "ACCOUNTNAME": acctName, "INTERBANKTRANSFER": intetBankTransFlag, "INTERBANKS": interBnktest };
					interBnktest = {};
				}
				else {
					test['BANKLIST'][bankID] = { "BANKACCTNO": bankJson[bankID].BANKACCOUNTNO, "BANKACCTNOMASK": bankJson[bankID].BANKACCOUNTNO, "BNKACCTID": "", "SERVNUM": servnum, "SERVNUM2": servnum, "BANKREFERENCEID": bankRefId, "ACCOUNTNAME": acctName };

				}
				test["SERVICESTATUS"] = json.SERVICESTATUS;
				test["SERVICENO"] = servnum;
				test["ACCOUNTNAME"] = acctName;
			}
			QUERY_PROFILE[serviceId] = test;

		}
	


	},
	loadServicePage: function (extraNum, extraAmount) {
		var selfOthersTab = myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"];
		myBWALLET.GLOBAL_TRANS_DATA = {};
		M.Toast.dismissAll();
		var serviceId = NAVIGATION.getService();
		var hasSelf = (serviceId in QUERY_PROFILE);
		/*if(!hasSelf && serviceId < 500)
		{
			DIALOG_alert(MSG_SERVICE_NOT_SUBSCRIBED,dummy,CONFIG_notifyHead["alert"],'Ok');
			return false;
		}*/
		//alert(serviceId);
		if (serviceId != 501 && serviceId != 502 && serviceId != 503 && serviceId != 520 && serviceId != 530 && serviceId != 540 && serviceId != 31) {
			if (QUERY_PROFILE[serviceId]["SERVICESTATUS"] != 1) {
				DIALOG_alert(MSG_SERVICE_NOT_SUBSCRIBED, dummy, CONFIG_notifyHead["alert"], 'Ok');
				return false;

			}
		}
		switch (serviceId) {
			case "31":	// Fund transfer
				$bw_serviceDiv.load("bw_fundtransferbanksel.html", function () {
					$bw_homeDiv.hide();
					var $tabs = $('#bw_serviceTab');
					var $input2 = $("#bw_input2");
					var $input3 = $("#bw_input3");
					var bankId = "";
					var activeflag = false;
					$tabs.tabs({
						onShow: function (e) {
							//alert("");
							bankId = $(e).attr('data-bank');
							if (QUERY_PROFILE[serviceId]['BANKLIST'][bankId] == undefined) {
								$("#bankExist").hide();
								$("#bankNotFoundText").text(MSG_BANK_NOT_SUBSCRIBED);
								$("#banknotexist").show();
							}
							else {
								if (QUERY_PROFILE[serviceId].BANKLIST[bankId].INTERBANKTRANSFER == "1") {
									var interBankJson = "";
									var optionHtml = "";
									var interBankJson = QUERY_PROFILE[serviceId].BANKLIST[bankId].INTERBANKS;
									optionHtml = '<option value="-1"  disabled selected>Select Destination Bank</option>';
									for (var interBankId in interBankJson) {

										optionHtml += "<option value='" + interBankId + "'>" + interBankJson[interBankId] + "</option>";
									}
									$("#bw_input2label").text("To account number");
									$("#bw_input4").html(optionHtml).formSelect();
									$("#bw_interBankSel").show();
									$('#bw_input4').change(function () {
										if (this.value != "-1") {
											$("#bw_input4 option[value*='-1']").attr('disabled', 'disabled');
										}
										$("#bw_input4Help").text('');
										$("#bw_input4label").css('color', '');
										$input2.val('');
										$input2.attr("maxlength", bw_destNumMaxLenHash["BANK_" + $("#bw_input4").val()]);
										setTimeout(function () {
											$input2.focus();
										}, 200);
									});


								}
								else {
									$("#bw_interBankSel").hide();
									$("#bw_input2label").text("To " + BANKNAME_HASH[bankId] + " account number");
									$input2.attr("maxlength", bw_destNumMaxLenHash["BANK_" + bankId]);
								}
								$input2.val("");
								$("#bw_input1").val(BANKNAME_HASH[bankId] + "-" + QUERY_PROFILE[serviceId]['BANKLIST'][bankId]["BANKACCTNOMASK"]);

								//$("#bw_input2label").text("To " + BANKNAME_HASH[bankId] + " account number");
								M.updateTextFields();
								$("#banknotexist").hide();
								$("#bankExist").show();
								$input2.focus();
								NAVIGATION.setService(serviceId, bankId);
								//alert($(e).attr('id'));
							}
						}


					});

					$bw_serviceDiv.fadeIn(150);
					//$tabs.tabs('select', 'bw_'+Math.min.apply(Math,Object.keys(QUERY_PROFILE[serviceId]['BANKLIST'])))////chnaged for wallet
					if(QUERY_PROFILE[serviceId]['BANKLIST']!=undefined){// if banks are added
						$tabs.tabs('select', 'bw_' + Math.max.apply(Math, Object.keys(QUERY_PROFILE[serviceId]['BANKLIST'])))
						
						}
						else{//if no banks are added
							$tabs.tabs('select', 'bw_200')
						}
					$tabs.tabs('updateTabIndicator');
					/*$("#bw_input1").val(BANKNAME_HASH[bankId] + "-" + QUERY_PROFILE[serviceId]['BANKLIST'][bankId]["BANKACCTNOMASK"]);
					$input2.attr("maxlength",bw_destNumMaxLenHash["BANK_" + bankId]);
					$("#bw_input2label").text("To " + BANKNAME_HASH[bankId] + " account number");
					
					$bw_serviceDiv.fadeIn(150);
					M.updateTextFields();
					$input2.focus();*/

					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						var REbankid = "";
						if (QUERY_PROFILE[serviceId].BANKLIST[bankId].INTERBANKTRANSFER == "1") {
							REbankid = $("#bw_input4 option:selected").val();
							if (REbankid == "-1") {
								//$("#bw_input2Help").attr("data-error","Please select Destination Bank");
								///$input2.addClass("invalid").focus();
								return false;
							}

						}
						else {
							REbankid = bankId;
						}

						if ($input2.val().length >= bw_destNumMaxLenHash["BANK_" + REbankid]) {
							if (!validateAcctNum($input2.val(), RE_services["BANK_" + REbankid])) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_ACCOUNT_NUMBER);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								$input3.focus();
							}
						}
					});

					// attaching keyup function on amount field to handle input events and to allow only amount format
					$input3.keyup(function (e) {
						var caret = this.selectionStart;
						onlyDecimalNumberHandler($input3, caret);
					});

					// attaching paste function on mobile number field to handle paste
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateBankAccountPaste(data, bw_destNumMaxLenHash["BANK_" + bankId])) {
							e.preventDefault();
						}
					});

					// attaching paste function on amount field to handle paste
					$input3.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateDecimalAmountPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "44":	//postpaid
				$bw_serviceDiv.load("bw_postpaid.html", function () {
					$bw_homeDiv.hide();
					var $input2 = $("#bw_input2");
					var $tabs = $('#bw_serviceTab');

					// initializing the tabs with function that triggers when tabs are changed
					$tabs.tabs({
						onShow: function (e) {
							var isSelf = $(e).attr('data-self');
							if (isSelf == "true")	// self
							{
								if (QUERY_PROFILE[serviceId]["SERVICENO"] == "" || QUERY_PROFILE[serviceId]["SERVICENO"] == undefined) {
									$("#bw_selfNotexist").show();
									$("#bw_selfExist").hide();
									$("#bw_selfNotExistText").text(MSG_SERVICE_SELF_UNREG);
									return false;
								}

								$("#bw_contactInput").hide();
								$("#bw_contactIcon").hide();
								$("#bw_selfSelect").show();
								NAVIGATION.bw_selfOther = 0;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;

							}
							else					// others
							{
								$("#bw_selfNotexist").hide();
								$("#bw_selfExist").show();
								$("#bw_selfSelect").hide();
								$("#bw_contactInput").show();
								$("#bw_contactIcon").show();
								$input2.focus();
								NAVIGATION.bw_selfOther = 1;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							M.updateTextFields();
						}
					});

					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";

					for (var bankId in json) {

						optionHtml = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["SERVNUM"] + "</option>";
					}

					$("#bw_input1").html(optionHtml).formSelect();

					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						$tabs.tabs("select", "bw_others");
						$input2.val(extraNum);
						$("#bw_serviceInit").click();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						Keyboard.hide();
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else if (QUERY_PROFILE[serviceId]["SERVICENO"] != "" && QUERY_PROFILE[serviceId]["SERVICENO"] != undefined) {
						$tabs.tabs('select', 'bw_self');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
					}
					else {
						$tabs.tabs('select', 'bw_others');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}

					if (selfOthersTab != undefined) {
						if (selfOthersTab == 0 || selfOthersTab == "0") {
							$tabs.tabs('select', 'bw_self');
						}
						else {
							$tabs.tabs('select', 'bw_others');
						}
					}

					$tabs.tabs('updateTabIndicator');

					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateMsisdn($input2.val())) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								Keyboard.hide();
								myBWALLET.validateBill();
							}
						}
					});

					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateMsisdnPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "12":	//Pre-paid
				$bw_serviceDiv.load("bw_topup.html", function () {
					$bw_homeDiv.hide();
					var $input1 = $("#bw_input1");
					var $input2 = $("#bw_input2");
					var $input3 = $("#bw_input3");
					var $tabs = $('#bw_serviceTab');
					var serviceType = NAVIGATION.getBank(); // Self or others

					// initializing the tabs with function that triggers when tabs are changed
					$tabs.tabs({
						onShow: function (e) {
							var isSelf = $(e).attr('data-self');
							if (isSelf == "true")	// self
							{
								if (QUERY_PROFILE[serviceId]["SERVICENO"] == "" || QUERY_PROFILE[serviceId]["SERVICENO"] == undefined) {

								}
								$("#bw_contactInput").hide();
								$("#bw_contactIcon").hide();
								$("#bw_selfSelect").show();
								$input3.focus();
								NAVIGATION.bw_selfOther = 0;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							else					// others
							{
								$("#bw_selfNotexist").hide();
								$("#bw_selfExist").show();
								$("#bw_selfSelect").hide();
								$("#bw_contactInput").show();
								$("#bw_contactIcon").show();
								$input2.focus();
								NAVIGATION.bw_selfOther = 1;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
						}
					});

					// Building the html for select dropdown content
					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";
					var optionHtml2 = "";

					for (var bankId in json) {
						//alert(json[bankId]["BANKACCTNOMASK"])
						optionHtml += "<option value='" + bankId + "'>" + BANKNAME_HASH[bankId] + " - " + json[bankId]["BANKACCTNOMASK"] + "</option>";
						//optionHtml2 = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["SERVNUM"]  + "</option>";
					}
				//	optionHtml += "<option value='hdshd'>Add Bank accounts</option>";

					if (QUERY_PROFILE[serviceId]["SERVNUM"] == "" || QUERY_PROFILE[serviceId]["SERVNUM"] == undefined) {
						optionHtml2 = "<option value='" + myBWALLET.sourceParty + "'>" + myBWALLET.sourceParty + "</option>";
					}
					else {
						optionHtml2 = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["SERVNUM"] + "</option>";
					}

					$("#bw_input1").html(optionHtml).formSelect();
					$("#bw_input4").html(optionHtml2).formSelect();

					// initializing the select dropdon and attaching event handler for change event
					/*$input1.html(optionHtml).formSelect().on("change",function(){
						if(0 == NAVIGATION.bw_selfOther)
						{
							var selectedBank = $input1.val();
							//alert(selectedBank + " , " + QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM"] + " , " + QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM2"])
							$input2.val(QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM"])
						}
					});*/

					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						$tabs.tabs("select", "bw_others");
						$input2.val(extraNum);
						$input3.val(extraAmount).focus();
						//$("#bw_serviceInit").click();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else {
						$tabs.tabs('select', 'bw_self');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
					}

					if (selfOthersTab != undefined) {
						if (selfOthersTab == 0 || selfOthersTab == "0") {
							$tabs.tabs('select', 'bw_self');
						}
						else {
							$tabs.tabs('select', 'bw_others');
						}
					}

					$tabs.tabs('updateTabIndicator');

					// attaching keyup function on mobile number field to handle input events  and to allow only numbers
					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateMsisdn($input2.val())) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								$input3.focus();
							}
						}
					});

					// attaching keyup function on amount field to handle input events and to allow only amount format
					$input3.keyup(function (e) {
						var caret = this.selectionStart;
						onlyDecimalNumberHandler($input3, caret);
					});

					// attaching paste function on mobile number field to handle paste
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						//alert(data);
						if (!validateMsisdnPaste(data)) {
							e.preventDefault();
							//alert("prevented")
						}
					});

					// attaching paste function on amount field to handle paste
					$input3.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateDecimalAmountPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "11":	// Landline
				$bw_serviceDiv.load("bw_landline.html", function () {
					$bw_homeDiv.hide();
					var $input2 = $("#bw_input2");
					var $tabs = $('#bw_serviceTab');

					// initializing the tabs with function that triggers when tabs are changed
					$tabs.tabs({
						onShow: function (e) {
							var isSelf = $(e).attr('data-self');
							if (isSelf == "true")	// self
							{
								if (QUERY_PROFILE[serviceId]["SERVICENO"] == "" || QUERY_PROFILE[serviceId]["SERVICENO"] == undefined) {
									$("#bw_selfNotexist").show();
									$("#bw_selfExist").hide();
									$("#bw_selfNotExistText").text(MSG_SERVICE_SELF_UNREG);
									return false;
								}

								$("#bw_contactInput").hide();
								$("#bw_contactIcon").hide();
								$("#bw_selfSelect").show();
								NAVIGATION.bw_selfOther = 0;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							else					// others
							{
								$("#bw_selfNotexist").hide();
								$("#bw_selfExist").show();
								$("#bw_selfSelect").hide();
								$("#bw_contactInput").show();
								$("#bw_contactIcon").show();
								$input2.focus();
								NAVIGATION.bw_selfOther = 1;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							M.updateTextFields();
						}
					});

					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";
					for (var bankId in json) {
						optionHtml = "<option value='" + json[bankId]["SERVNUM2"] + "'>" + json[bankId]["ACCOUNTNAME"] + "</option>";
					}
					$("#bw_input1").html(optionHtml).formSelect();

					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						$tabs.tabs("select", "bw_others");
						$input2.val(extraNum);
						$("#bw_serviceInit").click();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						Keyboard.hide();
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else if (QUERY_PROFILE[serviceId]["SERVICENO"] != "" && QUERY_PROFILE[serviceId]["SERVICENO"] != undefined) {
						$tabs.tabs('select', 'bw_self');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
					}
					else {
						$tabs.tabs('select', 'bw_others');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					if (selfOthersTab != undefined) {
						if (selfOthersTab == 0 || selfOthersTab == "0") {
							$tabs.tabs('select', 'bw_self');
						}
						else {
							$tabs.tabs('select', 'bw_others');
						}
					}

					$tabs.tabs('updateTabIndicator');

					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateAcctNum($input2.val(), RE_services[serviceId])) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_LANDLINE_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								Keyboard.hide();
								myBWALLET.validateBill();
							}
						}
					});

					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateMsisdnPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "75":	// BPC
				$bw_serviceDiv.load("bw_bpc.html", function () {
					$bw_homeDiv.hide();
					var $input2 = $("#bw_input2");

					$bw_serviceDiv.fadeIn(150);
					$input2.focus();

					NAVIGATION.bw_selfOther = 1;

					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateAcctNum($input2.val(), RE_services[serviceId])) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_CONSUMER_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								Keyboard.hide();
								myBWALLET.validateBill();
							}
						}
					});
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateBpcPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "36":	//Broadband
				$bw_serviceDiv.load("bw_broadband.html", function () {
					$bw_homeDiv.hide();
					var $input2 = $("#bw_input2");
					var $tabs = $('#bw_serviceTab');

					// initializing the tabs with function that triggers when tabs are changed
					$tabs.tabs({
						onShow: function (e) {
							var isSelf = $(e).attr('data-self');
							if (isSelf == "true")	// self
							{
								if (QUERY_PROFILE[serviceId]["SERVICENO"] == "" || QUERY_PROFILE[serviceId]["SERVICENO"] == undefined) {
									$("#bw_selfNotexist").show();
									$("#bw_selfExist").hide();
									$("#bw_selfNotExistText").text(MSG_SERVICE_SELF_UNREG);
									return false;
								}
								$("#bw_contactInput").hide();
								$("#bw_selfSelect").show();
								NAVIGATION.bw_selfOther = 0;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							else	// others
							{
								$("#bw_selfNotexist").hide();
								$("#bw_selfExist").show();
								$("#bw_selfSelect").hide();
								$("#bw_contactInput").show();
								$input2.focus();
								NAVIGATION.bw_selfOther = 1;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							M.updateTextFields();
						}
					});

					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";
					for (var bankId in json) {
						optionHtml = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["ACCOUNTNAME"] + "</option>";
					}
					$("#bw_input1").html(optionHtml).formSelect();

					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						$tabs.tabs("select", "bw_others");
						$input2.val(extraNum);
						$("#bw_serviceInit").click();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						Keyboard.hide();
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else if (QUERY_PROFILE[serviceId]["SERVICENO"] != "" && QUERY_PROFILE[serviceId]["SERVICENO"] != undefined) {
						$tabs.tabs('select', 'bw_self');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
					}
					else {
						$tabs.tabs('select', 'bw_others');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}

					if (selfOthersTab != undefined) {
						if (selfOthersTab == 0 || selfOthersTab == "0") {
							$tabs.tabs('select', 'bw_self');
						}
						else {
							$tabs.tabs('select', 'bw_others');
						}
					}

					$tabs.tabs('updateTabIndicator');

					$input2.keyup(function (e) {
						//onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateAcctNum($input2.val(), RE_services[serviceId])) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_BB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								Keyboard.hide();
								myBWALLET.validateBill();
							}
							e.preventDefault();
						}
					});
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateBBPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "37":	//Broadband
				$bw_serviceDiv.load("bw_broadband.html", function () {
					$bw_homeDiv.hide();
					var $input2 = $("#bw_input2");
					var $tabs = $('#bw_serviceTab');

					// initializing the tabs with function that triggers when tabs are changed
					$tabs.tabs({
						onShow: function (e) {
							var isSelf = $(e).attr('data-self');
							if (isSelf == "true")	// self
							{
								if (QUERY_PROFILE[serviceId]["SERVICENO"] == "" || QUERY_PROFILE[serviceId]["SERVICENO"] == undefined) {
									$("#bw_selfNotexist").show();
									$("#bw_selfExist").hide();
									$("#bw_selfNotExistText").text(MSG_SERVICE_SELF_UNREG);
									return false;
								}
								$("#bw_contactInput").hide();
								$("#bw_selfSelect").show();
								NAVIGATION.bw_selfOther = 0;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							else	// others
							{
								$("#bw_selfNotexist").hide();
								$("#bw_selfExist").show();
								$("#bw_selfSelect").hide();
								$("#bw_contactInput").show();
								$input2.focus();
								NAVIGATION.bw_selfOther = 1;
								myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = NAVIGATION.bw_selfOther;
							}
							M.updateTextFields();
						}
					});

					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";
					for (var bankId in json) {
						optionHtml = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["ACCOUNTNAME"] + "</option>";
					}
					$("#bw_input1").html(optionHtml).formSelect();

					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						$tabs.tabs("select", "bw_others");
						$input2.val(extraNum);
						$("#bw_serviceInit").click();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						Keyboard.hide();
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else if (QUERY_PROFILE[serviceId]["SERVICENO"] != "" && QUERY_PROFILE[serviceId]["SERVICENO"] != undefined) {
						$tabs.tabs('select', 'bw_self');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
					}
					else {
						$tabs.tabs('select', 'bw_others');
						myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}

					if (selfOthersTab != undefined) {
						if (selfOthersTab == 0 || selfOthersTab == "0") {
							$tabs.tabs('select', 'bw_self');
						}
						else {
							$tabs.tabs('select', 'bw_others');
						}
					}

					$tabs.tabs('updateTabIndicator');

					$input2.keyup(function (e) {
						//onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateAcctNum($input2.val(), RE_services[serviceId])) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_BB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								Keyboard.hide();
								myBWALLET.validateBill();
							}
							e.preventDefault();
						}
					});
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateBBPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "108":
				$bw_serviceDiv.load("bw_airtimePurchase.html", function () {
					$bw_homeDiv.hide();
					var $input1 = $("#bw_input1");
					var $input2 = $("#bw_input2");
					var $input3 = $("#bw_input3");
					var $tabs = $('#bw_serviceTab');
					//var serviceType = NAVIGATION.getBank(); // Self or others




					// Building the html for select dropdown content
					var json = QUERY_PROFILE[serviceId].BANKLIST;
					var optionHtml = "";
					var optionHtml2 = "";

					for (var bankId in json) {
						//alert(json[bankId]["BANKACCTNOMASK"])
						optionHtml += "<option value='" + bankId + "'>" + BANKNAME_HASH[bankId] + " - " + json[bankId]["BANKACCTNOMASK"] + "</option>";
						//optionHtml2 = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["SERVNUM"]  + "</option>";
					}
					if (QUERY_PROFILE[serviceId]["SERVNUM"] == "" || QUERY_PROFILE[serviceId]["SERVNUM"] == undefined) {
						optionHtml2 = "<option value='" + myBWALLET.sourceParty + "'>" + myBWALLET.sourceParty + "</option>";
					}
					else {
						optionHtml2 = "<option value='" + json[bankId]["SERVNUM"] + "'>" + json[bankId]["SERVNUM"] + "</option>";
					}

					$("#bw_input1").html(optionHtml).formSelect();
					//$("#bw_input4").html(optionHtml2).formSelect();

					// initializing the select dropdon and attaching event handler for change event
					/*$input1.html(optionHtml).formSelect().on("change",function(){
						if(0 == NAVIGATION.bw_selfOther)
						{
							var selectedBank = $input1.val();
							//alert(selectedBank + " , " + QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM"] + " , " + QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM2"])
							$input2.val(QUERY_PROFILE[serviceId]['BANKLIST'][selectedBank]["SERVNUM"])
						}
					});*/

					$bw_serviceDiv.fadeIn(150);
					$input2.focus();

					// attaching keyup function on mobile number field to handle input events  and to allow only numbers
					$input2.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input2.val().length >= bw_destNumMaxLenHash[serviceId]) {
							if (!validateMsisdn($input2.val())) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								$input3.focus();
							}
						}
					});

					// attaching keyup function on amount field to handle input events and to allow only amount format
					$input3.keyup(function (e) {
						var caret = this.selectionStart;
						onlyDecimalNumberHandler($input3, caret, RE_services["AIRTIMEAMT"]);
					});

					// attaching paste function on mobile number field to handle paste
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						//alert(data);
						if (!validateMsisdnPaste(data)) {
							e.preventDefault();
							//alert("prevented")
						}
					});

					// attaching paste function on amount field to handle paste
					$input3.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateDecimalAmountPaste(data)) {
							e.preventDefault();
						}
					});
				});
				break;
			case "501": myBWALLET.goToChangePin();
				break
			case "502": myBWALLET.goToTransHist();
				break;
			case "503": shareApp();
				return;
				break;
			case "510": // show registration confirmation : EKYC changes
				$bw_serviceDiv.load("srm_registration.html", function () {
					var $input1 = $("#srm_input1");
					$bw_homeDiv.hide();
					$bw_serviceDiv.fadeIn(150);

					$("#name").html(extraNum.KYCINFO.subscriberName);
					$("#dob").html(extraNum.KYCINFO.dob);
					$("#address").html(extraNum.KYCINFO.permanentAddress.addressLine1);
					$("#id").html(extraNum.KYCINFO.documents[0].identityNumber.replace(/\d(?!\d{0,3}$)/g, 'x'));
					$("#expiry").html(new Intl.DateTimeFormat('en-GB').format(new Date(extraNum.KYCINFO.documents[0].validityDate)));

					// Registeration call
					$("#register").on("click", function () {
						var userEnteredNid = $input1.val();
						if (!validateAcctNum(userEnteredNid, RE_services["IDNUM"])) {
							$("#srm_input1Help").attr("data-error", MSG_INVALID_NID_NUMBER);
							$input1.addClass("invalid").focus();
							return false;
						}
						postData("900", { "SRCMSISDN": mySELFCARE.sourceParty, "PLATFORM": NAVIGATION.platform, "DESCRIPTION": "STAKEREG", "SERVICEID": "", "WALLETTYPE": NAVIGATION.regPlatform.WALLET_TYPE, "CHECKREFID": extraNum.REFID, "SRMNID": extraNum.KYCINFO.documents[0].identityNumber, "USERENTEREDNID": userEnteredNid });
					})

					// goback home
					$("#srm_gotoHome").on("click", function () {
						PLATFORM_POINTER.showHomePage();
						})
				});
				break;
			case "520": // Manage self numbers
				$bw_serviceDiv.load("srm_manageServiceNumbers.html", function () {
					$input1 = $("#srm_input1");
					$input2 = $("#srm_input6");
					$input3 = $("#srm_input3");
					$input4 = $("#srm_input4");
					$addedNumList = $("#addedNumList");
					$bw_homeDiv.hide();
					$bw_serviceDiv.fadeIn(150);
					var serviceList = ADD_SERVICE_NUM_LIST[NAVIGATION.platform];
					var optionHtml = "";
					serviceList.forEach(function (service) {
						optionHtml += "<option value='" + service.serviceId + "_" + service.lable + "'>" + service.serviceName + "</option>";
					});
					$input1.html(optionHtml).formSelect();

					$input1.on('change', function () {
						var serviceId = $input1.val().split("_")[0];
						$("#serviceNoLable").html($input1.val().split("_")[1]);
						if (QUERY_PROFILE[serviceId].SERVICENO != "" && QUERY_PROFILE[serviceId].SERVICENO != undefined) {
							var html = '<li class="collection-item avatar" style="border-top: 1px solid #e0e0e0;"><span class="mdi mdi-cellphone mdi-36px circle" style="color: var(--tss-color-prime)"></span><span class="title" id="accountName">' + QUERY_PROFILE[serviceId].ACCOUNTNAME + '</span><p id="serviceNo">' + QUERY_PROFILE[serviceId].SERVICENO + '</p><a href="#!" class="secondary-content serviceNumUnMap" serv-id="' + serviceId + '" serv-num="' + QUERY_PROFILE[serviceId].SERVICENO + '" serv-kw="' + $("#srm_input1 option:selected").text() + '"><i class="mdi mdi-delete mdi-36px prefix" style="color:#000;opacity:0.4"></i></a></li>';
							$addedNumList.html(html);
						}
						else {
							$addedNumList.html("<li class='collection-item'><p style='text-align:center;font-weight:700;font-size:18px;opacity:0.84;color:#F44336'>No records found</p></li>");
						}
					});

					if (QUERY_PROFILE[$input1.val().split("_")[0]].SERVICENO != "" && QUERY_PROFILE[$input1.val().split("_")[0]].SERVICENO != undefined)
					//if(false)
					{
						var html = '<li class="collection-item avatar" style="border-top: 1px solid #e0e0e0;"><span class="mdi mdi-cellphone mdi-36px circle" style="color: var(--tss-color-prime)"></span><span class="title" id="accountName">' + QUERY_PROFILE[$input1.val().split("_")[0]].ACCOUNTNAME + '</span><p id="serviceNo">' + QUERY_PROFILE[$input1.val().split("_")[0]].SERVICENO + '</p><a href="#!" class="secondary-content serviceNumUnMap" serv-id="' + $input1.val().split("_")[0] + '" serv-num="' + QUERY_PROFILE[$input1.val().split("_")[0]].SERVICENO + '" serv-kw="' + $("#srm_input1 option:selected").text() + '"><i class="mdi mdi-delete mdi-36px prefix" style="color:#000;opacity:0.4"></i></a></li>';
						$addedNumList.html(html);
					}
					else {
						$addedNumList.html("<li class='collection-item'><p style='text-align:center;font-weight:700;font-size:18px;opacity:0.84;color:#F44336'>No records found</p></li>");
					}
					// Add service number
					$bw_serviceDiv.on('click', '#srm_addNumber', function () {
						var service = $input1.val().split("_")[0];
						var serviceName = $("#srm_input1 option:selected").text();
						var serviceNum = $input2.val();
						var displayName = $input3.val();
						var address = $input4.val();

						if (!validateValue(serviceNum, RE_services[service])) {

							$("#srm_input6Help").attr("data-error", MSG_INVALID_MOB_NUM);
							$input2.addClass("invalid").focus();
							return false;
						}

						if (!validateValue(displayName, RE_name)) {
							$("#srm_input3Help").attr("data-error", MSG_INVALID_ACCOUNT_HOLDER_NAME);
							$input3.addClass("invalid").focus();
							return false;
						}

						if (!validateValue(address, RE_address)) {
							$("#srm_input3Help").attr("data-error", MSG_INVALID_ADDRESS);
							$input4.addClass("invalid").focus();
							return false;
						}

						postData("955", { 'SRCMSISDN': myBWALLET.sourceParty, "SERVICEID": "42", "SERVKEYWORD": serviceName, "SERVICENUM1": serviceNum, "STAKE_TYPE": myBWALLET.stakeType, "ACCOUNTNAME": displayName, "ACCOUNTADDRESS": address, "SERVID": service });

					});

					// Remove service number
					$bw_serviceDiv.on('click', '.serviceNumUnMap', function () {
						var service = $(this).attr('serv-id');
						var serviceName = $(this).attr('serv-kw');
						var serviceNum = $(this).attr('serv-num');

						postData("955", { 'SRCMSISDN': myBWALLET.sourceParty, "SERVICEID": "43", "SERVKEYWORD": serviceName, "SERVICENUM1": serviceNum, "STAKE_TYPE": myBWALLET.stakeType, "ACCOUNTNAME": '', "ACCOUNTADDRESS": '', "SERVID": service });
					});
					$bw_homeDiv.hide();
					$bw_serviceDiv.fadeIn(150);
				});
				break;
			case "530": // Bank account mapping
				window.localStorage.setItem("BW_FIRST_HOME", "1");
				var bankList = extraNum;
				var optionHtml = "";
				var optionHtml2 = {};
				for (bank = 0; bank < bankList.length; bank++) {
					optionHtml += "<option value='" + bankList[bank].BANKID + "'>" + bankList[bank].BANKNAME + "</option>";
					if (bankList[bank].BRANCHES.length > 0) {
						optionHtml2[bankList[bank].BANKID] = "";
						for (branch = 0; branch < bankList[bank].BRANCHES.length; branch++) {
							optionHtml2[bankList[bank].BANKID] += "<option value='" + bankList[bank].BRANCHES[branch].BRANCHID + "'>" + bankList[bank].BRANCHES[branch].BRANCHNAME + "</option>";
						}
					}
					else {
						optionHtml2[bankList[bank].BANKID] = "";
					}
				}
				var attachementHeader = '<span id="mm_bill_choose_note">Attachments</span><div class="row col s12" style="color:black;padding-left:0px"><ul class="collection" style="border:none" id="attachments">__ATTACHMENTLIST__</ul></div>';
				var uploadListHtml = '<li class="collection-item avatar" style="border-top: 1px solid #e0e0e0;border-bottom:none;" file-type="__FILETYPE__" file-face="__FILEFACE__" file-index="__FILEINDEX__" image-data=""><img src="./images/common/default_placeholder.png" class="circle" id="image" alt="Front"><span class="title">__TITLE__</span><p>Click here to upload</p><p id="imageID__FILEINDEX__help" style="color: red;"></p></li>';

				var finalDocHtml = '';
				if (BANK_UPLOAD_FILE_CONFIG.docList.length > 0) {
					finalDocHtml += attachementHeader;

					var tempListHtml = '';
					BANK_UPLOAD_FILE_CONFIG.docList.forEach(function (value, index) {
						tempListHtml += uploadListHtml.replace(/__FILETYPE__/, value.docType).replace(/__FILEFACE__/, value.face).replace(/__TITLE__/, value.lable).replace(/__FILEINDEX__/g, index);
					});
					finalDocHtml = finalDocHtml.replace(/__ATTACHMENTLIST__/, tempListHtml);
				}
				$bw_serviceDiv.load("srm_bankMapping.html", function () {
					$input1 = $("#srm_input1");
					$input2 = $("#srm_input2");
					$input3 = $("#srm_input3");
					$input4 = $("#srm_input4");
					$input5 = $("#srm_input5");

					$input1.html(optionHtml).formSelect();
					$input1.on('change', function () {
						$input2.html(optionHtml2[$input1.val()]).formSelect();
						if (optionHtml2[$input1.val()] == undefined || optionHtml2[$input1.val()] == "") {
							$("#branches").hide()
						}
						else {
							$("#branches").show()
						}
					});
					$input2.html(optionHtml2[$input1.val()]).formSelect();
					if (optionHtml2[$input1.val()] == undefined || optionHtml2[$input1.val()] == "") {
						$("#branches").hide()
					}
					else {
						$("#branches").show()
					}

					// Document list initialising
					$("#bankAttachments").html(finalDocHtml);

					// Image element click
					$("#attachments").on("click", "li.collection-item", function () {
						myBWALLET.GLOBAL_TRANS_DATA["BANKUPDOCS"] = $(this);
						myBWALLET.bankKYCupload();
					});

					// submit button click
					$("#srm_bankKycSubmit").on('click', function () {
						var bankId = $input1.val();
						var bankName = $("#srm_input1 option:selected").text();
						var branchId = $input2.val();
						var branchName = $("#srm_input2 option:selected").text();
						var accNum = $input3.val();
						var accHolName = $input4.val();
						var address = $input5.val();

						if (!validateValue(accNum, RE_services['BANK_' + bankId])) {

							$("#srm_input3Help").attr("data-error", MSG_INVALID_ACCOUNT_NUMBER);
							$input3.addClass("invalid").focus();
							return false;
						}

						if (!validateValue(accHolName, RE_name)) {
							$("#srm_input4Help").attr("data-error", MSG_INVALID_ACCOUNT_HOLDER_NAME);
							$input4.addClass("invalid").focus();
							return false;
						}

						if (!validateValue(address, RE_address)) {
							$("#srm_input5Help").attr("data-error", MSG_INVALID_ADDRESS);
							$input5.addClass("invalid").focus();
							return false;
						}

						var state = false;


						var kycDocs = [];
						$('#attachments li').each(function () {
							var imageData = $(this).attr('image-data');
							if (imageData != undefined && imageData != "") {
								var imageDataObj = {};
								imageDataObj['FILE_TYPE'] = $(this).attr('file-type');
								imageDataObj['FACE'] = $(this).attr('file-face');
								imageDataObj['FILE_NAME'] = accHolName.replace(/ /, "");
								imageDataObj['MIME_TYPE'] = "png";
								imageDataObj['DATA'] = imageData;
								kycDocs.push(imageDataObj);
							}
							else {
								state = true;
								$("#imageID" + $(this).attr("file-index") + "help").html(MSG_EKYC_DOCUMENT_ERROR);
							}
						});
						if (state) {
							return false;
						}
						postData("965", { "SRCMSISDN": myBWALLET.sourceParty, "SERVICEID": "111", "BANK_NAME": bankName, "BANK_ID": bankId, "BRANCH_NAME": branchName, "BRANCH_ID": branchId, "BANK_ACCOUNT_NAME": accHolName, "BANK_ACCOUNT_NUMBER": accNum, "BANK_ACCOUNT_ADDRESS": address, "DOC_DETAILS": kycDocs });
					});

					$bw_homeDiv.hide();
					$bw_serviceDiv.fadeIn(150);
				});
				break;
			case "540": // Bank kyc status
				console.log("inside load service of 540");
				$bw_serviceDiv.load("srm_bankStatus.html", function () {
					var finalHtml = "";
					if (extraNum.length < 1) {
						finalHtml = "<li class='collection-item'><p style='text-align:center;font-weight:700;font-size:18px;opacity:0.84;color:#F44336'>No records found</p></li>";
					}
					else {
						var listHtml = "<li class='collection-item'> <span class='title tss-transHistTitle'>__ACCNUM__</span> <span class='title right tss-transHistTitle' style='color:#__STATUSCOLOR__'> __STATUS__</span><br> <p class='tss-nomargin'> <span class='tss--text-body1'>Bank : __BANKNAME__</span><br> <span class='tss--text-body1'>Branch : __BRANCH__</span><br> <span class='tss--text-body1'>Account Holder : __ACCHOLDER__</span><br> <span class='tss--text-body1'>Address : __ADDRESS__</span><br> <span class='tss--text-body1'>Registration Date : __Date__</span></p> </li>";
						extraNum.forEach(function (value) {
							var tempHtml = listHtml;
							if (value.STATUS == 1) { // success
								tempHtml = tempHtml.replace(/__STATUSCOLOR__/, '4CAF50');
							}
							else if (value.STATUS == 2) { // failure
								tempHtml = tempHtml.replace(/__STATUSCOLOR__/, 'F44336');
							}
							else if (value.STATUS == 11) { // pending
								tempHtml = tempHtml.replace(/__STATUSCOLOR__/, 'FF9800');
							}
							tempHtml = tempHtml.replace(/__ACCNUM__/, value.BANKACCNUM.replace(/\d(?!\d{0,3}$)/g, 'x'));
							tempHtml = tempHtml.replace(/__STATUS__/, value.STATUSDESC);
							tempHtml = tempHtml.replace(/__BANKNAME__/, value.BANKNAME);
							tempHtml = tempHtml.replace(/__BRANCH__/, value.BRANCHNAME);
							tempHtml = tempHtml.replace(/__ACCHOLDER__/, value.BANKACCNAME);
							tempHtml = tempHtml.replace(/__ADDRESS__/, value.BANKACCADDRESS);
							tempHtml = tempHtml.replace(/__Date__/, value.BANKREGDATE);
							finalHtml += tempHtml;
						});
					}
					$("#bankStatusList").html(finalHtml);

					$bw_homeDiv.hide();
					$bw_serviceDiv.fadeIn(150);
				});
				break;
			case "116":
				$bw_serviceDiv.load("bw_Trowa.html", function () {
					$bw_homeDiv.hide();
					var $input1 = $("#bw_input1");//wwallet
					var $input2 = $("#bw_input2");//to msisdn
					//var $input3 = $("#bw_input3");//amount
					NAVIGATION.mm_selfOther = 0;
					$bw_serviceDiv.fadeIn(150);

					if (extraNum !== undefined) {
						//$tabs.tabs("select","mm_others");
						$input1.val(extraNum);
						$input2.val(extraAmount).focus();
						M.updateTextFields();
						myBWALLET.GLOBAL_TRANS_DATA['FROMSELFCARE'] = "1";
						//myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 1;
					}
					else {
						//$tabs.tabs('select','mm_self');
						//myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = 0;
						$input1.focus();
					}

					// attaching keyup function on mobile number field to handle input events  and to allow only numbers
					$input1.keyup(function (e) {
						onlyNumberHandler($input2);
						if ($input1.val().length >= mm_destNumMaxLenHash[serviceId]) {
							if (!validateMsisdn($input2.val())) {
								$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
								$input2.addClass("invalid").focus();
								return false;
							}
							else {
								$input2.focus();
							}
						}
					});

					// attaching keyup function on amount field to handle input events and to allow only amount format
					$input2.keyup(function (e) {
						var caret = this.selectionStart;
						onlyDecimalNumberHandler($input2, caret);
					});

					// attaching paste function on mobile number field to handle paste
					$input1.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateMsisdnPaste(data)) {
							e.preventDefault();
						}
					});

					// attaching paste function on amount field to handle paste
					$input2.on("paste", function (e) {
						var data = e.originalEvent.clipboardData.getData('Text');
						if (!validateDecimalAmountPaste(data)) {
							e.preventDefault();
						}
					});


				});
				break;
			default:	//alert("service Id not handled");
				return false;
		}
		NAVIGATION.fromHome(serviceId)
		NAVIGATION.setPage(4);
	},
	getBankStatus: function () {
		postData("960", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": "113", "MSISDN": myBWALLET.sourceParty });
	},
	bankKYCupload: function () {
		var html = "<ul id='srm_redirectList' class='collection with-header tss-nomargin'> <li class='collection-header tss-padding16side' style='padding:0px 16px'> <p style='font-weight:500'>Upload Docs  via..</p> </li> <li class='tss-padding16side collection-item contact' style='padding:16px 16px' data-platform='0'> <div style='font-size:16px;font-weight:500;'><span class='mdi mdi-camera mdi-36px' style='opacity:0.54;vertical-align: middle;'></span>&nbsp;&nbsp;Camera</div> </li> <li class='tss-padding16side collection-item contact' style='padding:16px 16px' data-platform='1'> <div style='font-size:16px;font-weight:500;'><span class='mdi mdi-camera mdi-36px' style='opacity:0.54;vertical-align: middle;'></span>&nbsp;&nbsp;Gallery</div> </li> <li class='tss-padding16side collection-item contact' style='padding:16px 16px;text-align:center' data-platform='-1'> <div style='font-weight:500;'>Cancel</div> </li> </ul";
		$('#bottomModalContent').html(html);
		$('#bottomModal').modal({
			onCloseEnd: function () {
				console.log("onCloseEnd");
				NAVIGATION.setPage(4);
				$('#bottomModal').modal('destroy');
			},
			onCloseStart: function () {
				NAVIGATION.setPage(4);
				console.log("onCloseStart");
			},
		});
		$("#srm_redirectList").on("click", "li.collection-item", function () {
			$('#bottomModal').modal('close');
			var selectedRedirect = $(this).attr("data-platform");

			switch (selectedRedirect) {
				case "0":
					showCamera()
					break;
				case "1":
					showGallery()
					break;
			}

		});
		$('#bottomModal').modal('open');
		NAVIGATION.setPage(10);
	},
	payPObill: function () {
		//alert("calling payObils");
		var selectedBankId = $("#bw_input1").val();
		var serviceId = NAVIGATION.getService();

		var json = QUERY_PROFILE[serviceId].BANKLIST;
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] = BANKNAME_HASH[selectedBankId];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUM"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBankId]["BANKACCTNO"];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBankId]["BANKACCTNOMASK"];
		myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBankId]["BANKREFERENCEID"];
		//alert("Global Hash Initialised");
		var reqTest = "";

		if (selectedBankId != "501") {
			switch (serviceId) {
				case "44":

					reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Postpaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "", "SERVICETYPE": myBWALLET.GLOBAL_TRANS_DATA["POSTPAIDBILLTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("340", reqTest);
					break;
				case "75":
					reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": " BPC service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("340", reqTest);

					break;
				case "11":
					reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Landline service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("340", reqTest);
					break;
				case "37":
					reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Leased line service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("340", reqTest);
					break;
				case "116":
					reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Landline service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("340", reqTest);

					break;
				case "36":
					switch (myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"]) {
						case "2":       //Postpaid
							var selectedBankId = $("#bw_input1 option:selected").val();
							reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND Postpaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "PPTYPE": myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
							postData("340", reqTest);
							break;
						case "1":       //Prepaid
							var selPlan = $("#bw_input2 option:selected").text();
							var planAmount = $("#bw_input2 option:selected").val();
							myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = planAmount;
							myBWALLET.GLOBAL_TRANS_DATA["PLANNAME"] = selPlan;
							myBWALLET.GLOBAL_TRANS_DATA["INVOICE"] = selPlan;
							//reqTest = {"SRCMSISDN":myBWALLET.sourceParty,"DESCRIPTION": "BROADBAND Prepaid service ","SELFOROTHERS":"1","SERVICEID": serviceId,"AMOUNT":myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"],"SRCMPIN": "","SERVICEDETAILS":{"SERVICENO": "","BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"],"USID":myBWALLET.GLOBAL_TRANS_DATA["USID"],"ACCOUNTNO":myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"],"SERVICEREFID":"","PPTYPE":myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"]},"WALLETDETAILS":{"WALLETTYPE":"","DESTMSISDN":"","DESTMPIN":"","TRANSTYPE":""},"BANKACCOUNT":{"BANKREFID":myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"],"SRCBANK":"","DESTBANK":"","SRCBANKACCOUNT":"","DESTBANKACCOUNT":"","SRCBRANCH":"","DESTBRANCH":""},"COMMENT":"Sample test request","DESTNOTIFYNO":"","DESTNOTIFYLAN":""};
							reqTest = { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND Prepaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": selPlan, "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "PPTYPE": myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
							postData("340", reqTest);
							break;
					}
			}
		}
		else {
			if (myBWALLET.GLOBAL_TRANS_DATA["PIN"] === undefined) { myBWALLET.promptPIN(); return false }
			switch (serviceId) {
				case "44":
					reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Postpaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "", "SERVICETYPE": myBWALLET.GLOBAL_TRANS_DATA["POSTPAIDBILLTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					//reqTest = {"SRCMSISDN":myBWALLET.sourceParty,"DESCRIPTION": "Postpaid service ","SELFOROTHERS":"1","SERVICEID": serviceId,"AMOUNT":myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"],"SRCMPIN": "","SERVICEDETAILS":{"SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"],"BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"],"USID":myBWALLET.GLOBAL_TRANS_DATA["USID"],"ACCOUNTNO":"","SERVICEREFID":"","SERVREQTYPE":"","SERVICETYPE":myBWALLET.GLOBAL_TRANS_DATA["POSTPAIDBILLTYPE"]},"WALLETDETAILS":{"WALLETTYPE":"","DESTMSISDN":"","DESTMPIN":"","TRANSTYPE":""},"BANKACCOUNT":{"BANKREFID":myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"],"SRCBANK":"","DESTBANK":"","SRCBANKACCOUNT":"","DESTBANKACCOUNT":"","SRCBRANCH":"","DESTBRANCH":""},"COMMENT":"Sample test request","DESTNOTIFYNO":"","DESTNOTIFYLAN":""};
					postData("365", reqTest);
					break;
				case "75":

					reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": " BPC service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("365", reqTest);

					break;
				case "11":
					reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Landline service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("365", reqTest);
					break;
				case "37":
					reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Leased line service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("365", reqTest);
					break;
				case "116":
					reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Landline service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
					postData("365", reqTest);
					break;
				case "36":
					switch (myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"]) {
						case "2":       //Postpaid
							var selectedBankId = $("#bw_input1 option:selected").val();
							reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND Postpaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"], "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "PPTYPE": myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
							postData("365", reqTest);
							break;
						case "1":       //Prepaid
							var selPlan = $("#bw_input2 option:selected").text();
							var planAmount = $("#bw_input2 option:selected").val();
							myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = planAmount;
							myBWALLET.GLOBAL_TRANS_DATA["PLANNAME"] = selPlan;
							myBWALLET.GLOBAL_TRANS_DATA["INVOICE"] = selPlan;
							//reqTest = {"SRCMSISDN":myBWALLET.sourceParty,"DESCRIPTION": "BROADBAND Prepaid service ","SELFOROTHERS":"1","SERVICEID": serviceId,"AMOUNT":myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"],"SRCMPIN": "","SERVICEDETAILS":{"SERVICENO": "","BILLNO": myBWALLET.GLOBAL_TRANS_DATA["INVOICE"],"USID":myBWALLET.GLOBAL_TRANS_DATA["USID"],"ACCOUNTNO":myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"],"SERVICEREFID":"","PPTYPE":myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"]},"WALLETDETAILS":{"WALLETTYPE":"","DESTMSISDN":"","DESTMPIN":"","TRANSTYPE":""},"BANKACCOUNT":{"BANKREFID":myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"],"SRCBANK":"","DESTBANK":"","SRCBANKACCOUNT":"","DESTBANKACCOUNT":"","SRCBRANCH":"","DESTBRANCH":""},"COMMENT":"Sample test request","DESTNOTIFYNO":"","DESTNOTIFYLAN":""};
							reqTest = { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND Prepaid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": selPlan, "USID": myBWALLET.GLOBAL_TRANS_DATA["USID"], "ACCOUNTNO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "SERVICEREFID": "", "PPTYPE": myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": "", "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" };
							postData("365", reqTest);
							break;
					}
			}

		}

	},
	payAirtime: function () {
		var serviceId = NAVIGATION.getService();
		if (myBWALLET.GLOBAL_TRANS_DATA["FROMBANKID"] == "501") {
			if (myBWALLET.GLOBAL_TRANS_DATA["PIN"] === undefined) { myBWALLET.promptPIN(); return false; }
			postData("365", { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"] }], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"], "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "USID": "", "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": myBWALLET.GLOBAL_TRANS_DATA["FROMBANKID"], "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" });
		}
		else {
			postData("340", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "USID": "", "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": myBWALLET.GLOBAL_TRANS_DATA["FROMBANKID"], "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" });
		}

	},
	validateAirTime: function () {
		var selectedBank = $("#bw_input1").val();
		var msisdn = $("#bw_input2").val();
		var amount = $("#bw_input3").val() * 1;
		var serviceId = NAVIGATION.getService();
		if (!validateMsisdn(msisdn)) {
			$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}

		if (!validateAmt(amount)) {
			$("#bw_input3Help").attr("data-error", MSG_INVALID_AMOUNT);
			$("#bw_input3").addClass("invalid").focus();
			return false;
		}

		if (amount < parseFloat(bw_amountMinHash[serviceId]) || amount > parseFloat(bw_amountMaxHash[serviceId])) {
			var minMaxMsg = MSG_AIRTIME_MIN_MAX_ERROR;
			minMaxMsg = minMaxMsg.replace(/__MIN_AMOUNT__/g, CONFIG_currency + " " + bw_amountMinHash[serviceId]);
			minMaxMsg = minMaxMsg.replace(/__MAX_AMOUNT__/g, CONFIG_currency + " " + bw_amountMaxHash[serviceId]);
			$("#bw_input3Help").attr("data-error", minMaxMsg);
			$("#bw_input3").addClass("invalid").focus();
			return false;
		}

		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] = BANKNAME_HASH[selectedBank];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUM"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKACCTNO"];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKACCTNOMASK"];
		myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"] = msisdn;
		myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = amount;
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKID"] = selectedBank;
		myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKREFERENCEID"];
		//myBWALLET.GLOBAL_TRANS_DATA["WALLETTYPE"] = selectedBank;
		//postData("790",{"SRCMSISDN":myBWALLET.sourceParty,"DESCRIPTION": "Pre-paid service ","SERVICEID":serviceId,"AMOUNT":amount,"SERVICEDETAILS":{"SERVICENO":msisdn},"WALLETDETAILS":{"WALLETTYPE":selectedBank}});

		postData("790", { "SOURCEPARTY": myBWALLET.sourceParty, "DESCRIPTION": "Bulk purchase service", "AMOUNT": amount, "SERVICEID": serviceId, "SERVNUM": msisdn });

	},
	validateTopup: function () {
		var selectedBank = $("#bw_input1").val();
		var msisdn = "";
		if (NAVIGATION.bw_selfOther == 0) {
			msisdn = $("#bw_input4").val();
		}
		else {
			msisdn = $("#bw_input2").val();
		}
		var amount = $("#bw_input3").val() * 1;
		var serviceId = NAVIGATION.getService();

		//alert(msisdn);
		if (!validateMsisdn(msisdn)) {
			$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}

		if (!validateAmt(amount)) {
			$("#bw_input3Help").attr("data-error", MSG_INVALID_AMOUNT);
			$("#bw_input3").addClass("invalid").focus();
			return false;
		}


		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] = BANKNAME_HASH[selectedBank];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUM"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKACCTNO"];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKACCTNOMASK"];
		myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"] = msisdn;
		myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = amount;
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKID"] = selectedBank;
		myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"] = QUERY_PROFILE[serviceId]["BANKLIST"][selectedBank]["BANKREFERENCEID"];

		if (selectedBank == "501") {
			if (myBWALLET.GLOBAL_TRANS_DATA["PIN"] === undefined) { myBWALLET.promptPIN(); return false; }
			postData("365", { "SRCMPIN": myBWALLET.GLOBAL_TRANS_DATA["PIN"], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": serviceId, "AMOUNT": amount, "SERVICEDETAILS": { "SERVICENO": msisdn }, "PAYMENTDETAILS": [{ "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "AMOUNT": "0" }, { "PAYMENTMODE": "7", "WALLETTYPE": "", "AMOUNT": amount }] });
			delete myBWALLET.GLOBAL_TRANS_DATA["PIN"];
		}
		else {
			postData("340", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"], "BILLNO": "", "USID": "", "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": selectedBank, "DESTBANK": "", "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": "", "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" });
		}
	},
	validateFundTransfer: function () {
		var acctNum = $("#bw_input2").val();
		var amount = $("#bw_input3").val() * 1;
		var serviceId = NAVIGATION.getService();
		var bankId = NAVIGATION.getBank();
		var destBankId = $("#bw_input4 option:selected").val();
		//var selectedBank = $("#bw_input1").val();
		if (QUERY_PROFILE[serviceId].BANKLIST[bankId].INTERBANKTRANSFER == "1") {

			if (destBankId == -1 || destBankId == "-1") {
				$("#bw_input4Help").text(MSG_INVALID_DEST_BANK);
				$("#bw_input4label").css('color', '#F44336');
				return false;
			}
			//bankId = 	destBankId;	
			myBWALLET.GLOBAL_TRANS_DATA["TOBANKNAME"] = $("#bw_input4 option:selected").text();


		}
		else {
			bankId = NAVIGATION.getBank();
			myBWALLET.GLOBAL_TRANS_DATA["TOBANKNAME"] = BANKNAME_HASH[bankId];
			destBankId = bankId;
		}
		//console.log(bankId + "=="+destBankId+RE_services["BANK_" + parseInt(destBankId]));
		$("#bw_input4Help").text('');
		if (!validateAcctNum(acctNum, RE_services["BANK_" + destBankId])) {
			$("#bw_input2Help").attr("data-error", MSG_INVALID_ACCOUNT_NUMBER);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}

		if (acctNum == QUERY_PROFILE[serviceId]["BANKLIST"][bankId]["BANKACCTNO"]) {
			$("#bw_input2Help").attr("data-error", MSG_TRANSFER_SELF);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}
		if (!validateAmt(amount)) {
			$("#bw_input3Help").attr("data-error", MSG_INVALID_AMOUNT);
			$("#bw_input3").addClass("invalid").focus();
			return false;
		}

		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] = BANKNAME_HASH[bankId];
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUM"] = QUERY_PROFILE[serviceId]["BANKLIST"][bankId]["BANKACCTNO"];
		myBWALLET.GLOBAL_TRANS_DATA["TOBANKID"] = $("#bw_input4").val();
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] = QUERY_PROFILE[serviceId]["BANKLIST"][bankId]["BANKACCTNOMASK"];
		myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"] = acctNum;
		myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = amount;
		myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"] = QUERY_PROFILE[serviceId]["BANKLIST"][bankId]["BANKREFERENCEID"];

		postData("340", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Fund Transfer service ", "SELFOROTHERS": "1", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SRCMPIN": "", "SERVICEDETAILS": { "SERVICENO": "", "BILLNO": "", "USID": "", "ACCOUNTNO": "", "SERVICEREFID": "", "SERVREQTYPE": "" }, "WALLETDETAILS": { "WALLETTYPE": "", "DESTMSISDN": "", "DESTMPIN": "", "TRANSTYPE": "" }, "BANKACCOUNT": { "BANKREFID": myBWALLET.GLOBAL_TRANS_DATA["BANKREFERENCEID"], "SRCBANK": bankId, "DESTBANK": destBankId, "SRCBANKACCOUNT": "", "DESTBANKACCOUNT": acctNum, "SRCBRANCH": "", "DESTBRANCH": "" }, "COMMENT": "Sample test request", "DESTNOTIFYNO": "", "DESTNOTIFYLAN": "" });
	},
	validateBill: function () {
		var acctNum;
		if (NAVIGATION.bw_selfOther == 0) {
			acctNum = $("#bw_input1").val();
		}
		else {
			acctNum = $("#bw_input2").val();
		}
		var serviceId = NAVIGATION.getService();

		myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"] = acctNum;
		switch (serviceId) {
			case "44": if (!validateMsisdn(acctNum)) {
				$("#bw_input2Help").attr("data-error", MSG_INVALID_MOB_NUM);
				$("#bw_input2").addClass("invalid").focus();
				return false;
			}
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "POSTPAID", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "1", "INCLUDEACCOUNTDETAILS": "1" });
				break;
			case "75": if (!validateAcctNum(acctNum, RE_services[serviceId])) {
				$("#bw_input2Help").attr("data-error", MSG_INVALID_CONSUMER_NUM);
				$("#bw_input2").addClass("invalid").focus();
				return false;
			}
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BPC", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "1", "INCLUDEACCOUNTDETAILS": "1" });
				return false;
				break;
			case "11": if (!validateAcctNum(acctNum, RE_services[serviceId])) {
				$("#bw_input2Help").attr("data-error", MSG_INVALID_LANDLINE_NUM);
				$("#bw_input2").addClass("invalid").focus();
				return false;
			}
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "LANDLINE", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "1", "INCLUDEACCOUNTDETAILS": "1" });

				break;
			case "36": if (!validateAcctNum(acctNum, RE_services[serviceId])) {
				$("#bw_input2Help").attr("data-error", MSG_INVALID_BB_NUM);
				$("#bw_input2").addClass("invalid").focus();
				return false;
			}
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "1", "INCLUDEACCOUNTDETAILS": "1" });
				break;
			case "37": if (!validateAcctNum(acctNum, RE_services[serviceId])) {
				$("#bw_input2Help").attr("data-error", MSG_INVALID_CONSUMER_NUM);
				$("#bw_input2").addClass("invalid").focus();
				return false;
			}
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "1", "INCLUDEACCOUNTDETAILS": "1" });
				break;
			case "116":
				var acctNum = $("#bw_input1").val();
				if (acctNum.length <= 8) {
					if (!validateMsisdn(acctNum)) {
						$("#bw_input1Help").attr("data-error", MSG_INVALID_MOB_NUM);
						$("#bw_input1").addClass("invalid");
						$("#bw_input1").focus();
						return false;
					}
				}
				else {
					if (!validateAcctNum(acctNum, RE_services[serviceId])) {
						$("#bw_input1Help").attr("data-error", MSG_INVALID_CONSUMER_NUM);
						$("#bw_input1").addClass("invalid").focus();
						return false;
					}
				}
				var amount = $("#bw_input2").val();
				if (!validateAmt(amount)) {
					$("#bw_input2Help").attr("data-error", MSG_INVALID_AMOUNT);
					$("#bw_input2").addClass("invalid").focus();
					return false;
				}
				myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = amount;
				postData("350", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "BROADBAND", "SELFOROTHERS": "1", "SERVICENO": acctNum, "SERVICEID": serviceId, "SERVICENAME": QUERY_PROFILE[serviceId]['SERVNAME'], "INCLUDEBILLDETAILS": "0", "INCLUDEACCOUNTDETAILS": "1" });
				break;
		}
	},
	afterConfirm: function () {
		var serviceId = NAVIGATION.getService();
		var bankId = NAVIGATION.getBank();
		var pin = $("#bw_input1").val();

		if (pin == "" || !validatePin(pin)) {
			$("#bw_input1Help").attr("data-error", MSG_INVALID_MPASS);
			$("#bw_input1").addClass("invalid").focus();
			return false;
		}
		switch (serviceId) {
			case "11":
			case "75":
			case "36":
			case "44":
			case "37":
			case "12"://TOP-UP
			case "108":
			case "116"://BTTV
				{
					postData("360", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "TXNID": myBWALLET.GLOBAL_TRANS_DATA["TXID"], "SERVICEID": serviceId, "CONFVALUE": pin, "TRANSSESSIONID": myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"] });
					break;
				}
			case "31"://FUND TRANSFER
				{
					postData("360", { "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SELFOROTHERS": "1", "TXNID": myBWALLET.GLOBAL_TRANS_DATA["TXID"], "AMOUNT": amount, "SERVICEID": serviceId, "CONFVALUE": pin, "SERVICENAME": QUERY_PROFILE[serviceId]["SERVNAME"], "TRANSSESSIONID": myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"] });
					break;
				}
		}
	},
	afterCheckStatus: function (response) {
		$bw_serviceDiv.load("bw_reciept.html", function () {
			var serviceId = NAVIGATION.getService();
			//alert(JSON.stringify(myBWALLET.GLOBAL_TRANS_DATA));
			if (myBWALLET.GLOBAL_TRANS_DATA["TXID"] === undefined) {
				myBWALLET.GLOBAL_TRANS_DATA["TXID"] = myBWALLET.GLOBAL_TRANS_DATA["RMATXID"];
			}
			//myBWALLET.GLOBAL_TRANS_DATA["TXID"]
			switch (serviceId) {
				case "31":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TOBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER TRANSFER");
					break;
				case "44": $("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER PAYMENT");
					break;
				case "12":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					break;
				case "116":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					break;
				case "75":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER PAYMENT");
					break;
				case "11":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER PAYMENT");
					break;
				case "36":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER PURCHASE");
					if (myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] == 1) {
						$("#planName").html(myBWALLET.GLOBAL_TRANS_DATA["PLANNAME"]);
						$(".planNameDiv").show();
					}
					break;
				case "37":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#destName").html(myBWALLET.GLOBAL_TRANS_DATA["TONAME"]);
					$("#bw_anotherPay").text("ANOTHER PAYMENT");
					break;
				case "108":
					$("#respDesc").html(response.RESPONSE.RESPDESC);
					$("#transId").html(myBWALLET.GLOBAL_TRANS_DATA["TXID"]);
					$("#srcNum").html(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").html(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#amount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_anotherPay").text("ANOTHER Purchase");
					$("#bw_airtime").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_discount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["DISCOUNTAMT"]);
					$("#bw_tds").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["TDSAMT"]);
					$("#bw_payAmount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"]);
					$("#bw_airtimePurchase").show();
					break;
			}
			myBWALLET.GLOBAL_TRANS_DATA = {};
		});
		NAVIGATION.setPage(5);
	},
	logout: function () {
		mySELFCARE.logout();
	},
	login: function () {
		var msisdn = myBWALLET.sourceParty = mySELFCARE.sourceParty;

		postData("80", { 'SRCMSISDN': msisdn, 'MPIN': "", "INCLUDEACCOUNTDETAILS": "1", "INCLUDECONTACTINFORMATION": "1", "INCLUDESERVICEDETAILS": "1" });
	},
	callQueryProfile: function () {
		postData("510", { 'SERVICENO': myBWALLET.sourceParty });
	},
	afterQueryProfile: function (queryProfileStr) {
		//alert(JSON.stringify(queryProfileStr.SERVICE_STRING));
		var imageIP = STORE.apiCallUrl.replace("fcgi-bin/", "") + "" + STORE.adImage["1"];
		//alert(imageIP);
		myBWALLET.stakeType = queryProfileStr.ACCOUNTDETAILS.STAKETYPE != undefined ? queryProfileStr.ACCOUNTDETAILS.STAKETYPE : "11";
		NAVIGATION.updateActiveFooter();
		$et_homeDiv.css("background", "url(" + imageIP + ") no-repeat -9999px -9999px;");
		$bw_homeDiv.load("bw_home.html", function () {
			$bw_homeDiv.hide();
			$("#sidenavDrawer").show();
			$("#bw_username").text("Welcome " + myBWALLET.nameTitle + " " + myBWALLET.firstName);
			//var json = queryProfileStr;
			BANKNAME_HASH = {};
			var bankJson = {}
			for (var i = 0; i < queryProfileStr.SERVICEDETAILS.BANK.length; i++) {
				var bJson = queryProfileStr.SERVICEDETAILS.BANK[i];
				//alert("BANK JSON = \n" + JSON.stringify(bJson));
				var bankAccountNum = "";
				if (bJson.BANKACCOUNTDETAILS[0].BANKACCOUNTNO == "") {
					bankAccountNum = "PG";
				}
				else {
					bankAccountNum = bJson.BANKACCOUNTDETAILS[0].BANKACCOUNTNO;
				}
				bankJson[bJson.BANKID] = { "BANKNAME": bJson.BANKNAME, "BANKACCOUNTNO": bankAccountNum };

				BANKNAME_HASH[bJson.BANKID] = bJson.BANKNAME;
				//alert(BANKNAME_HASH[json.BANKLIST[i].BANKID]);

			}
			//alert("BANK JSON = \n" + JSON.stringify(bankJson));
			var serviceStringLength = queryProfileStr.SERVICEDETAILS.SERVICES.length;
			QUERY_PROFILE = {};
			for (var i = 0; i < serviceStringLength; i++) {
				var json = queryProfileStr.SERVICEDETAILS.SERVICES[i];
				var serviceId = json.SERVICEID;
				var test = {};
				var bankJsonLen = json.BANKREFERENCE.length;

				for (var j = 0; j < bankJsonLen; j++) {
					//alert(JSON.stringify(json.BANKREFERENCE[j]));
					var bankID = json.BANKREFERENCE[j].BANKID;
					var bankRefId = json.BANKREFERENCE[j].BANKREFERENCEID;
					test['BANKLIST'] = test['BANKLIST'] || {};
					var servnum = "", acctName = "";
					if (json.SUBSCRIPTIONDETAILS.length > 0) {
						servnum = json.SUBSCRIPTIONDETAILS[0].SERVICENO;
						acctName = json.SUBSCRIPTIONDETAILS[0].ACCOUNTNAME;
					}

					if (serviceId == "31" || serviceId == 31) {
						var interBnktest = {};
						var intetBankTransFlag = "0";

						if (json.BANKREFERENCE[j].INTERBANKTRANSFER && json.BANKREFERENCE[j].INTERBANKTRANSFER == "1") {
							intetBankTransFlag = json.BANKREFERENCE[j].INTERBANKTRANSFER;
							var interBanks = json.BANKREFERENCE[j].DESTINATIONBANKS;
							for (var k = 0; k < interBanks.length; k++) {
								interBnktest[interBanks[k].BANKID] = interBanks[k].BANKNAME;
							}
						}
						test['BANKLIST'][bankID] = { "BANKACCTNO": bankJson[bankID].BANKACCOUNTNO, "BANKACCTNOMASK": bankJson[bankID].BANKACCOUNTNO, "BNKACCTID": "", "SERVNUM": servnum, "SERVNUM2": servnum, "BANKREFERENCEID": bankRefId, "ACCOUNTNAME": acctName, "INTERBANKTRANSFER": intetBankTransFlag, "INTERBANKS": interBnktest };
						interBnktest = {};
					}
					else {
						test['BANKLIST'][bankID] = { "BANKACCTNO": bankJson[bankID].BANKACCOUNTNO, "BANKACCTNOMASK": bankJson[bankID].BANKACCOUNTNO, "BNKACCTID": "", "SERVNUM": servnum, "SERVNUM2": servnum, "BANKREFERENCEID": bankRefId, "ACCOUNTNAME": acctName };

					}
					test["SERVICESTATUS"] = json.SERVICESTATUS;
					test["SERVICENO"] = servnum;
					test["ACCOUNTNAME"] = acctName;
				}
				QUERY_PROFILE[serviceId] = test;

			}
			//alert(JSON.stringify(QUERY_PROFILE))


			$("#bw_mainAd").attr("src", imageIP);
			$bw_homeDiv.fadeIn(150);
			if (CONFIG_btrow) {
				$("#bwbttvDiv").show();
				$("#bwbttv").show();
				$("#changePinDiv").hide();
				$("#changePin").hide();
				$(".tss-side-changepin").show();

			}
			else {
				$("#bwbttvDiv").hide();
				$("#bwbttv").hide();
				$("#changePinDiv").show();
				$("#changePin").show();
				$(".tss-side-changepin").hide();

			}
			//$('.carousel.carousel-slider').carousel({fullWidth: true,indicators: true,noWrap:true});
			$(".tss-side-bw").show();
			
			if (window.localStorage.getItem("BW_FIRST_HOME") != "1") {
				$("#headerMenu").html('<a id="side_menu" class="btn-floating btn-large tss-bckgrnd-prime" ><img   src="./images/common/menuIcon.png"  class="headerImage"></a>');
				
				$("#sample").append("<div id='homeTapTarget' class='tap-target' data-target='side_menu'> <div class='tap-target-content' style='color:white'> <h5>Link accounts and check status</h5> <p>Click the button to link accounts to b-wallet and check status of added banks</p> </div> </div>");
				var deleted_element=false;

			
				$('.tap-target').tapTarget();
				$('.tap-target').tapTarget('open');
				$(".tap-target-content,.tap-target-wave,.tap-target-origin").click(function () {
					$("#headerMenu").html(' <img id="side_menu"  src="./images/common/menuIcon.png" / class="headerImage">					')
					
					$('.tap-target').tapTarget('close');
					$(".tap-target-content,.tap-target-wave,tap-target-origin").off();
					let menu = document.getElementById('sample');
					if(!deleted_element){
					menu.removeChild(menu.lastElementChild);
					}
					deleted_element=true;
					$("#headerMenu").click();
				});

				setTimeout(function () {

					$('.tap-target').tapTarget('close');
					$(".tap-target-content,.tap-target-wave,tap-target-origin").off();
					$("#headerMenu").html(' <img id="side_menu"  src="./images/common/menuIcon.png" / class="headerImage">					')
					let menu = document.getElementById('sample');
					if(!deleted_element){
					menu.removeChild(menu.lastElementChild);
					}
					deleted_element=true;
					//$("#homeTapTarget").remove();
					
					$("#headerMenu").click();
					

				}, 5000);
			}


			//$(".tss-NoLogin").hide();
			if (myBWALLET.afterLoginAction != "") {
				myBWALLET.afterLoginIntent();
			}
		});
		$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
		$(".tss-side-bw").show();

		NAVIGATION.setPage(3);
		NAVIGATION.toHome();
	}
	,
	afterLoginIntent: function () {
		switch (myBWALLET.afterLoginAction) {
			case "1": // Recharge
				NAVIGATION.setService("12");
				myBWALLET.loadServicePage(myBWALLET.afterLoginExtra.NUMBER, myBWALLET.afterLoginExtra.AMOUNT);
				break;
			case "2": // BB Prepaid
				NAVIGATION.setService("36");
				myBWALLET.loadServicePage(myBWALLET.afterLoginExtra.NUMBER);
				break;
			case "3": // Postpaid
				NAVIGATION.setService("44");
				myBWALLET.loadServicePage(myBWALLET.afterLoginExtra.NUMBER);
				break;
			case "4": // Landline
				NAVIGATION.setService("11");
				myBWALLET.loadServicePage(myBWALLET.afterLoginExtra.NUMBER);
			case "5":
				NAVIGATION.setService("116");
				myBWALLET.loadServicePage();
				break;
		}
		myBWALLET.afterLoginAction = "";
		myBWALLET.afterLoginExtra = "";
	},
	goToLogin: function () {
		myBWALLET.loadLogin(true);
		NAVIGATION.toHome();
	},
	showBill: function (response) {
		if (NAVIGATION.getService() == "36") {
			//alert(response.ACCOUNTDETAILS.SERVICEDETAILS.PPIDENTIFIER)
			myBWALLET.GLOBAL_TRANS_DATA["BBACCOUNTTYPE"] = response.ACCOUNTDETAILS.SERVICEDETAILS.PPIDENTIFIER;

			if (response.ACCOUNTDETAILS.SERVICEDETAILS.PPIDENTIFIER == "1") {
				myBWALLET.showBBprepaidPackage(response)
			}
			else {
				myBWALLET.showBBpostpaidBill(response);
			}
			return;
		}

		if (NAVIGATION.getService() == "108") {
			myBWALLET.showAirtimedetails(response);
			return;
		}

		$bw_serviceDiv.load("bw_billConfirm.html", function () {
			var serviceId = NAVIGATION.getService();
			if (NAVIGATION.getService() != "116") {
				$("#destNumLabel").text(bw_destLabelhash[serviceId]);
				$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
				$("#amount").text(CONFIG_currency + " " + response.BILLDETAILS.BILLSUMMARY.OUTSTANDING);
				$("#dueDate").text(response.BILLDETAILS.BILLSUMMARY.DUEDATE);
				$("#billInfo").show();
				myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = response.BILLDETAILS.BILLSUMMARY.OUTSTANDING;
				myBWALLET.GLOBAL_TRANS_DATA["INVOICE"] = response.BILLDETAILS.BILLSUMMARY.PROVISIONDET;
				myBWALLET.GLOBAL_TRANS_DATA["USID"] = response.BILLDETAILS.BILLSUMMARY.SESSIONSERVICEID;
			}
			else {
				$("#destNumLabelBtrowa").text(bw_destLabelhash[serviceId]);
				$("#destNumBtrowa").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
				$("#amountBtrowa").text(myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
				var infoHtml = '<div class="col s6"> <p class="tss-dataLabel">__LABEL__</p> </div> <div class="col s6"> <p  class="tss-dataContent">__USERDET__</p> </div>';
				var userDet = Object.keys(response.CUSTOMERDETAILS);
				var tempHtml = "";
				if (response.VALIDATION == "1") {
					for (var i = 0; i < userDet.length; i++) {
						var temp = infoHtml;
						temp = temp.replace("__LABEL__", userDet[i]);
						temp = temp.replace("__USERDET__", response.CUSTOMERDETAILS[userDet[i]]);
						tempHtml += temp;
					}

					$("#btrowinfo").append(tempHtml);
					$("#btrowinfo").show();
				}
			}
			if (CONFIG_splitBillServices.includes(serviceId) && response.BILLDETAILS.BILLSUMMARY.BILLDETAILS.length > 0) {
				$("#amountLabel").text("Total Due");
				$("#bw_bill_choose_note").html(CONFIG_BILL_CHOOSE_NOTE);
				var billHtml = '<li class="collection-item avatar " style="padding-left: 0px;border-top: 1px solid #e0e0e0;"><span class="title">Bill number : __BILLID__</span><p>Due Date :__DATE__</p><span class="" style="margin-top: 10px;" >Due Amount : __BILLAMOUNT__ </span><button class="btn btn-small tss-bckgrnd-prime  secondary-content tss-bill-pay" data-billid ="__BILLID__" data-billinvoice = "__BILLINVOICEAMT__" data-billamt = "__AMOUNT__" data-payflag="__BILLPAYFLAG__"> <i class="mdi mdi-note-plus-outline mdi-24px" st"color:#fff;vertical-align:middle;"></i>PAY </button></li>';
				var outstandingBillHtml = '<li class="collection-item avatar " style="padding-left: 0px;border-bottom: 1px solid #e0e0e0;"><p>Outstanding</p><span class="" style="margin-top: 10px;" >__BILLAMOUNT__ </span><button class="btn btn-small tss-bckgrnd-prime  secondary-content" id="bw_billConfirm"> <i class="mdi mdi-note-plus-outline mdi-24px" st"color:#fff;vertical-align:middle;"></i>PAY </button></li>';
				var finalHtml = "";
				var bills = response.BILLDETAILS.BILLSUMMARY.BILLDETAILS;
				for (var i = 0; i < bills.length; i++) {
					tempHtml = billHtml;
					tempHtml = tempHtml.replace(/__BILLID__/g, bills[i].BILLNO);
					tempHtml = tempHtml.replace(/__DATE__/, bills[i].DUEDATE);
					tempHtml = tempHtml.replace(/__BILLAMOUNT__/g, CONFIG_currency + " " + bills[i].BILLAMOUNT);
					tempHtml = tempHtml.replace(/__BILLINVOICEAMT__/, bills[i].BILLINVOICEAMT);
					tempHtml = tempHtml.replace(/__AMOUNT__/, bills[i].BILLAMOUNT);
					tempHtml = tempHtml.replace(/__BILLPAYFLAG__/, bills[i].BILLPAYFLAG);
					finalHtml += tempHtml;
				}
				outstandingBillHtml = outstandingBillHtml.replace(/__BILLAMOUNT__/, CONFIG_currency + " " + response.BILLDETAILS.BILLSUMMARY.OUTSTANDING);
				finalHtml = finalHtml + outstandingBillHtml;

				$("#bw_billList").html(finalHtml).show();
				$(".tss-bill-pay").click(function () {
					if ($(this).attr('data-payflag') == '1') {
						myBWALLET.GLOBAL_TRANS_DATA["POSTPAIDBILLTYPE"] = "2";
						myBWALLET.GLOBAL_TRANS_DATA["BILLID"] = $(this).attr('data-billid');
						myBWALLET.GLOBAL_TRANS_DATA["INVOICE"] = $(this).attr('data-billinvoice');
						myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = $(this).attr('data-billamt');
						myBWALLET.payPObill();
					}
					else {
						DIALOG_alert(MSG_OLD_BILL_PAY, dummy, CONFIG_notifyHead["alert"], 'Ok');
					}
				});
				$("#bw_paybill_btn").hide();
			}
			var json = QUERY_PROFILE[serviceId].BANKLIST;
			var optionHtml = "";
			for (var bankId in json) {
				optionHtml += "<option value='" + bankId + "'>" + BANKNAME_HASH[bankId] + " - " + json[bankId]["BANKACCTNO"] + "</option>";
			}
			$("#bw_input1").html(optionHtml).formSelect();
			NAVIGATION.setPage(6);
		});
	},
	showAirtimedetails: function (response) {
		$bw_serviceDiv.load("bw_airtimeDet.html", function () {
			var serviceId = NAVIGATION.getService();

			$("#destNumLabel").text(bw_destLabelhash[serviceId]);
			$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
			$("#bw_destName").text(response.DEALERNAME);
			$("#bw_airtime").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
			$("#bw_discount").text(CONFIG_currency + " " + response.DISCOUNTAMT);
			$("#bw_tds").text(CONFIG_currency + " " + response.TDSAMT);
			$("#bw_payAmount").text(CONFIG_currency + " " + response.PAYABLEAMT);
			myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"] = response.PAYABLEAMT;
			myBWALLET.GLOBAL_TRANS_DATA["DISCOUNTAMT"] = response.DISCOUNTAMT;
			myBWALLET.GLOBAL_TRANS_DATA["TDSAMT"] = response.TDSAMT;
			myBWALLET.GLOBAL_TRANS_DATA["DESTNAME"] = response.DEALERNAME;
		});
		NAVIGATION.setPage(6);
	}
	,
	showConfirm: function (response) {
		var serviceId = NAVIGATION.getService();
		//myBWALLET.GLOBAL_TRANS_DATA["TXREFID"] = response.REFID;
		myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"] = response.SESSIONID;
		myBWALLET.GLOBAL_TRANS_DATA["TXID"] = response.TXID;
		$bw_serviceDiv.load("bw_topUpConfirm.html", function () {
			switch (serviceId) {
				case "12":	//Top-Up confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.SUBNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").attr("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.SUBNAME;
					break;
				case "116":	//BTTV confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.SUBNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").attr("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					//myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.SUBNAME;
					break;
				case "31":	//Fund transfer confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TOBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "44"://Postpaid confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "36"://Postpaid confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "11"://Postpaid confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "75"://Postpaid confirm
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "37"://Leased line
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
					$("#destName").text(response.DESTNAME);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_serviceConfirm").text("CONFIRM");
					$("#note").css("display", BANK_CHARGE_HASH[serviceId]);
					$("#noteText").text(MSG_BANK_CHARGE_NOTE);
					NAVIGATION.setPage(6);
					myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = response.DESTNAME;
					myBWALLET.GLOBAL_TRANS_DATA["TONUMBERMASK"] = myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"];
					break;
				case "108": //Airtime purchase
					$("#destNumLabel").text(bw_destLabelhash[serviceId]);
					$("#bankAcctNum").text(myBWALLET.sourceParty);
					$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] + "-" + myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"]);
					$("#destName").text(myBWALLET.GLOBAL_TRANS_DATA["DESTNAME"]);
					$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_airtime").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
					$("#bw_discount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["DISCOUNTAMT"]);
					$("#bw_tds").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["TDSAMT"]);
					$("#bw_payAmount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"]);
					$("#bw_airtimePurchase").show();
					$("#bw_serviceConfirm").text("CONFIRM");
					NAVIGATION.setPage(6);
					break;
			}
			var $input1 = $("#bw_input1");
			$input1.keyup(function (e) {
				onlyNumberHandler($input1);
			});

			$input1.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});
		});
	},
	showBBpostpaidBill: function (response) {
		$bw_serviceDiv.load("bw_broadbandPostconfirm.html", function () {
			var serviceId = NAVIGATION.getService();
			var det = response.DETAILS;

			$("#destNumLabel").text(bw_destLabelhash[serviceId]);
			$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
			//$("#destName").text("HARDCODED NAME");
			$("#amount").text(CONFIG_currency + " " + response.BILLDETAILS.BILLSUMMARY.OUTSTANDING);
			//$("#dueDate").text(response.BILLDETAILS.BILLSUMMARY.DUEDATE);

			//myBWALLET.GLOBAL_TRANS_DATA["TONAME"]   = response.SERVICEDETAILS.SUBNAME;
			myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = "HARCODED NAME";
			myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = response.BILLDETAILS.BILLSUMMARY.OUTSTANDING;
			myBWALLET.GLOBAL_TRANS_DATA["INVOICE"] = response.BILLDETAILS.BILLSUMMARY.PROVISIONDET;
			myBWALLET.GLOBAL_TRANS_DATA["USID"] = response.BILLDETAILS.BILLSUMMARY.SESSIONSERVICEID;

			var json = QUERY_PROFILE[serviceId].BANKLIST;
			var optionHtml = "";
			for (var bankId in json) {
				optionHtml += "<option value='" + bankId + "'>" + BANKNAME_HASH[bankId] + " - " + json[bankId]["BANKACCTNO"] + "</option>";
			}
			$("#bw_input1").html(optionHtml).formSelect();
			NAVIGATION.setPage(6);
		});
	},
	showBBprepaidPackage: function (response) {
		$bw_serviceDiv.load("bw_broadbandPreConfirm.html", function () {
			var serviceId = NAVIGATION.getService();
			var plans = response.BILLDETAILS.PACKAGEDETAILS;
			var planHtml = "";
			for (var i = 0; i < plans.length; i++) {
				planHtml += '<option value="' + plans[i].PACKAGEAMOUNT + '">' + plans[i].PACKAGENAME + '</option>';
			}
			$("#bw_input2").html(planHtml).formSelect();;
			var json = QUERY_PROFILE[serviceId].BANKLIST;
			var optionHtml = "";
			for (var bankId in json) {
				optionHtml += "<option value='" + bankId + "'>" + BANKNAME_HASH[bankId] + " - " + json[bankId]["BANKACCTNO"] + "</option>";
			}
			$("#bw_input1").html(optionHtml).formSelect();
			$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
			//$("#destName").text("HARDCODED NAME");
			$("#bw_input2").on("change", myBWALLET.getPlan)
			$("#planName").html(plans[0].PACKAGENAME);
			$("#planAmt").html(plans[0].PACKAGEAMOUNT);
			//myBWALLET.GLOBAL_TRANS_DATA["TONAME"] = "HARDCODED NAME";
			NAVIGATION.setPage(6);
		});
	},
	getPlan: function () {
		$("#planName").html($("#bw_input2 option:selected").text());
		$("#planAmt").html($("#bw_input2 option:selected").val());
	},
	goToFirstPin: function () {
		$sc_homeDiv.hide();
		$bw_homeDiv.load("bw_changePin.html", function () {
			var $input1 = $("#bw_input1");
			var $input2 = $("#bw_input2");
			var $input3 = $("#bw_input3");
			$bw_homeDiv.fadeIn(150);
			$input1.focus();

			$input1.keyup(function (e) {
				onlyNumberHandler($input1);
				if ($input1.val().length == bw_destNumMaxLenHash.PIN) {
					$input2.focus();
				}
			});

			$input2.keyup(function (e) {
				onlyNumberHandler($input2);
				if ($input2.val().length == bw_destNumMaxLenHash.PIN) {
					$input3.focus();
				}
			});

			$input3.keyup(function (e) {
				onlyNumberHandler($input3);
				if ($input3.val().length == bw_destNumMaxLenHash.PIN) {
					Keyboard.hide();
					myBWALLET.changePin();
				}
			});

			$input1.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});

			$input2.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});

			$input3.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});
			$("#bw_action1").click(function () {
				myBWALLET.showPolicy();
			});
		});
		NAVIGATION.setService("501");
		NAVIGATION.fromHome("501");

		NAVIGATION.setPage(2);
	},
	goToChangePin: function () {
		$bw_serviceDiv.load("bw_changePin.html", function () {
			$bw_homeDiv.hide();
			var $input1 = $("#bw_input1");
			var $input2 = $("#bw_input2");
			var $input3 = $("#bw_input3");

			$input1.keyup(function (e) {
				onlyNumberHandler($input1);
				if ($input1.val().length == bw_destNumMaxLenHash.PIN) {
					$input2.focus();
				}
			});

			$input2.keyup(function (e) {
				onlyNumberHandler($input2);
				if ($input2.val().length == bw_destNumMaxLenHash.PIN) {
					$input3.focus();
				}
			});

			$input3.keyup(function (e) {
				onlyNumberHandler($input3);
				if ($input3.val().length == bw_destNumMaxLenHash.PIN) {
					Keyboard.hide();
					myBWALLET.changePin();
				}
			});

			$input1.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});

			$input2.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});

			$input3.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validatePinPaste(data)) {
					e.preventDefault();
				}
			});
			$("#bw_action1").click(function () {
				myBWALLET.showPolicy();
			});

			$("#bw_action2").click(function () {
				mySELFCARE.showPolicy();
			});

			$bw_serviceDiv.fadeIn(150);
			$input1.focus();
		});
		NAVIGATION.setService("501");
		NAVIGATION.fromHome("501");
		NAVIGATION.setPage(4);
	},
	showPolicy: function () {
		//var passPolicyHtml = '<p style="font-weight:600;font-size:16px" class="tss-padding16side">PIN Policy :-</p> <ul class="browser-default"> <p> <li  class=""> PIN should contain only digits </li> <li  class=""> PIN should not contain repetitive Numbers(2222,3333). </li> <li  class=""> PIN should not contain any consecutive Numbers(1234,4321). </li>  </ul> </p> <div class="modal-footer" class="tss-nopadding"> <a href="#!" class="modal-close waves-effect waves-green btn-flat">OK</a> </div>';
		var passPolicyHtml = PIN_POLICY_HASH[NAVIGATION.platform]["HTML"];
		$("#centerModalContent").html(passPolicyHtml);
		$('#centerModal').modal({
			onCloseEnd: function () {
				if (NAVIGATION.getPage() == 10) {
					NAVIGATION.setPage(parseInt(mySELFCARE.GLOBAL_TRANS_DATA["PREV_PAGE"]));
				}
				$('#centerModal').modal('destroy');
			}
		});
		$('#centerModal').modal('open');
		mySELFCARE.GLOBAL_TRANS_DATA["PREV_PAGE"] = NAVIGATION.getPage();
		NAVIGATION.setPage(10);
	},
	changePin: function () {
		var oldPin = $("#bw_input1").val();
		var newPin = $("#bw_input2").val();
		var confirmPin = $("#bw_input3").val();
		//$(".tss-input-error").text('');
		if (oldPin == "" || !validatePin(oldPin)) {
			$("#bw_input1Help").attr("data-error", MSG_INVALID_MPASS);
			$("#bw_input1").addClass("invalid").focus();
			return false;
		}
		if (newPin == "" || !validatePin(newPin)) {
			$("#bw_input2Help").attr("data-error", MSG_INVALID_MPASS);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}
		if (confirmPin == "" || !validatePin(confirmPin)) {
			$("#bw_input3Help").attr("data-error", MSG_INVALID_MPASS);
			$("#bw_input3").addClass("invalid").focus();
			return false;
		}

		/*Checking if old pin and new pin are same*/
		if (oldPin == newPin) {
			$("#bw_input2Help").attr("data-error", MSG_OLDNEW_MPASS_MISMATCH);
			$("#bw_input3").val("");
			$("#bw_input2").addClass("invalid").val("").focus();
			return false;
		}

		/*Checking if new pin and confirm pin are matching*/
		if (newPin != confirmPin) {
			$("#bw_input3Help").attr("data-error", MSG_NEWCONF_MPASS_MISMATCH);
			$("#bw_input3").addClass("invalid").val("").focus();
			return false;
		}
		postData("70", { "MSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Change Pin", "PASSWORD": { "OLDMPIN": oldPin, "NEWMPIN": newPin }, "SERVICEID": "60" });
	},
	callCheckStatus: function (reqType, refId, response) {
		//alert(NAVIGATION.checkStatusCount)
		if (NAVIGATION.checkStatusCount >= CONFIG_chckStatusMaxRetry[NAVIGATION.platform]) {
			NAVIGATION.checkStatusCount = 0;
			if (reqType == "70") {
				DIALOG_alert(MSG_CHECK_STATUS_LIMIT, dummy, CONFIG_notifyHead["alert"], 'Ok');
			}
			else {
				if (response == undefined) {
					DIALOG_alert(MSG_CHECK_STATUS_LIMIT, dummy, CONFIG_notifyHead["alert"], 'Ok');
				}
				else {
					myBWALLET.afterCheckStatus(response);
				}
			}
			return false;
		}
		var data = { "QUERYREFID": refId, "QUERYREQTYPE": reqType, "SRCMSISDN": myBWALLET.sourceParty, "TXREFID": refId };

		NAVIGATION.checkStatusCount++;
		postData("320", data);
		return true;
	},
	promptPIN: function () {
		var template = '<div class="tss-padding16side"> <p style="text-align:center;font-size:16px;font-weight:bold"></p> <div class="row"><div class="input-field col s10 tss-nopadding"> <img src="./images/common/Prefix_oldPin.png" class="prefix tss-prefixIcon-24"/> <input id="bw_pin" type="tel" class="tss-pin-mask tss-focus-trigger validate" maxlength="4"> <label for="bw_pin">Enter M-Pin to confirm</label> <span class="helper-text" id="bw_pinHelp"></span> </div> <div class="input-field col s2 right-align tss-nopadding tss-input-extra"> <i class="mdi mdi-eye-off mdi-24px tss-input-extra-icon" data-action="pin" data-for="bw_pin"></i> </div> <div> 	  <div class="col s12" style="text-align:center"> <button class="btn waves-effect waves-light waves-ripple tss-btn" id="bw_action1">Proceed</button> </div> </div><br><br><div class="divider" style="margin-top: 20px;">&nbsp;</div>';
		$("#centerModalContent").html(template);
		$('#centerModal').modal({
			onCloseEnd: function () {
				NAVIGATION.setPage(4, 0);
				$('#centerModal').modal('destroy');
			}
		});
		//$('#bottomModal').modal('close');
		$('#centerModal').modal("open");

		$("#bw_action1").click(function () {
			var pin = $("#bw_pin").val();
			if (pin == "" || !validatePin(pin)) {
				$("#bw_pinHelp").attr("data-error", MSG_INVALID_MPASS);
				$("#bw_pin").addClass("invalid").focus();
				return false;
			}
			$('#centerModal').modal("close");
			myBWALLET.GLOBAL_TRANS_DATA["PIN"] = pin;
			switch (NAVIGATION.getService()) {
				case "12": PLATFORM_POINTER.validateTopup();
					break;
				case "35": PLATFORM_POINTER.validateFundTransfer();
					break;
				case "44":
				case "75":
				case "11":
				case "37":
				case "116":
				case "36": PLATFORM_POINTER.payPObill();
					break;
				case "47": PLATFORM_POINTER.validateB2W();
					break;
				case "46": PLATFORM_POINTER.validateW2B();
					break;
				case "501": PLATFORM_POINTER.changePin();
					break;
				case "502": PLATFORM_POINTER.getTransHist();
					break;
				case "40": PLATFORM_POINTER.validateMercPay();
					break;
				case "18": NAVIGATION.setService("90");
					PLATFORM_POINTER.loadServicePage();
					break;
				case "108": PLATFORM_POINTER.payAirtime();
					break;
			}
		});
	},
	showRMAbanks: function (response) {
		myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"] = response.SESSIONID;
		myBWALLET.GLOBAL_TRANS_DATA["BANKID"] = response.BANKID;
		var RMAbankListObj = response.TRANSINFO;
		myBWALLET.GLOBAL_TRANS_DATA["RMATXID"] = response.TXID;

		var optionHtml = "";
		$bw_serviceDiv.load("bw_rmaBankList.html", function () {
			//$("#bw_input2").attr('maxlength',bw_destNumMaxLenHash["BANK_"+RMAbankListObj[0]["WALLETID"]]);
			for (var i = 0; i < RMAbankListObj.length; i++) {
				if (RMAbankListObj[i]["WALLETID"] == "1") {
					continue;
				}
				myBWALLET.GLOBAL_TRANS_DATA["BANKID"] = RMAbankListObj[i]["BANKID"];
				optionHtml += "<option value='" + RMAbankListObj[i]["WALLETID"] + "'>" + RMAbankListObj[i]["WALLETNAME"] + "</option>";
				$("#bw_input1").html(optionHtml).formSelect();
			}

			$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
			$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);
			//$("#rewEarned").text(CONFIG_currency+" "+rewardsEarned);
			$("#bw_serviceConfirm").text("CONFIRM");
			NAVIGATION.setPage(6);
			$("#bw_input2").attr('maxlength', bw_destNumMaxLenHash["BANK_" + $("#bw_input1 option:selected").val()]);
			$("#bw_input1").on("change", myBWALLET.updatemaxLenRMA);
		})
	}
	,
	updatemaxLenRMA: function () {
		$("#bw_input2").attr('maxlength', sc_destNumMaxLenHash["BANK_" + $("#bw_input1 option:selected").val()]);
	},
	validateRmaBankEnq: function () {
		var serviceId = NAVIGATION.getService();
		var srcBankName = $("#bw_input1 option:selected").text();
		var srcBankId = $("#bw_input1 option:selected").val();
		var acctNum = $("#bw_input2").val();
		myBWALLET.GLOBAL_TRANS_DATA["SRCBANK"] = srcBankId;
		var tempAmt;
		tempAmt = myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"];
		myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] = myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"] === undefined ? myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] : myBWALLET.GLOBAL_TRANS_DATA["PAYABLE_AMOUNT"];
		if (!validateAcctNum(acctNum, RE_services["BANK_" + srcBankId])) {
			$("#bw_input2Help").attr("data-error", MSG_INVALID_ACCOUNT_NUMBER);
			$("#bw_input2").addClass("invalid").focus();
			return false;
		}
		//myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] =  $("#bw_input1 option:selected").text();
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKNAME"] = srcBankId;
		myBWALLET.GLOBAL_TRANS_DATA["FROMBANKACCTNUMMMASK"] = acctNum.replace(/\d(?!\d{0,3}$)/g, 'x');
		postData("370", { "TXNID": myBWALLET.GLOBAL_TRANS_DATA["RMATXID"], "TRANSSESSIONID": myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"], "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": serviceId, "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"], "SERVICEDETAILS": { "SERVICENO": myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"] }, "TRANSINFO": [{ "BANKID": "1", "PAYMENTMODE": "1", "WALLETTYPE": "Operational", "TXID": myBWALLET.GLOBAL_TRANS_DATA["RMATXID"], "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["SPLITUPFLAG"] == "1" ? myBWALLET.GLOBAL_TRANS_DATA["WALLETAMOUNT"] : "0" }, { "WALLETID": myBWALLET.GLOBAL_TRANS_DATA["SRCBANK"], "BANKID": myBWALLET.GLOBAL_TRANS_DATA["BANKID"], "ACCOUNTNO": acctNum, "WALLETNAME": srcBankName, "PAYMENTMODE": "7", "BANKID": myBWALLET.GLOBAL_TRANS_DATA["BANKID"], "WALLETTYPE": "", "AMOUNT": myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"] }] });
	},
	showRmaOTPscreen: function (response) {
		$bw_serviceDiv.load("bw_rmaOtpVerfn.html", function () {
			var $input = $("#bw_input1");



			if (myBWALLET.GLOBAL_TRANS_DATA["SPLITUPFLAG"] == "1") {
				if (myBWALLET.GLOBAL_TRANS_DATA["WALLETAMOUNT"] != "0") {
					$("#BngulAmtDiv").show();
					$("#bngulAmount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["WALLETAMOUNT"]);
				}
				if (myBWALLET.GLOBAL_TRANS_DATA["RMAAMOUNT"] != "0") {
					$("#RmaAmtDiv").show();
					$("#rmaAmount").html(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["RMAAMOUNT"]);
				}
			}
			$("#destNum").text(myBWALLET.GLOBAL_TRANS_DATA["TONUMBER"]);
			$("#amount").text(CONFIG_currency + " " + myBWALLET.GLOBAL_TRANS_DATA["AMOUNT"]);

			onlyNumberHandler($input);
			if ($input.val().length == bw_destNumMaxLenHash.RMAOTP) {
				//Keyboard.hide();
				verifyRmaOtp();
			}



			$input.on("paste", function (e) {
				var data = e.originalEvent.clipboardData.getData('Text');
				if (!validateOtpPaste(data)) {
					e.preventDefault();
				}
			});


			$("#action1").click(function () {
				verifyRmaOtp();
			});

			NAVIGATION.setPage(6);

		});

	},
	verifyRmaOtp: function () {
		var otp = $('#bw_input1').val();
		var serviceId = NAVIGATION.getService();
		if (otp == "" || !validateRMAOTP(otp)) {
			$("#bw_input1Help").attr("data-error", MSG_INVALID_OTP);
			$("#bw_input1").addClass("invalid").focus();
			return false;
		}
		postData("375", { "TXNID": myBWALLET.GLOBAL_TRANS_DATA["RMATXID"], "TRANSSESSIONID": myBWALLET.GLOBAL_TRANS_DATA["TRANSSESSIONID"], "CONFVALUE": otp, "SRCMSISDN": myBWALLET.sourceParty, "DESCRIPTION": "Pre-paid service ", "SERVICEID": serviceId });
	}
}
