/*
/*
*************************** page VALUE INDEX *************************************
1	:	LOGIN	
2	:	OTP
3	:	HOME
4	:	SERVICE
5	:	RECIEPT
6	:	Bill
10	: 	POPUP
11	: 	Feature discovery
12	:	Add account OTP
13	:	QR PAGE
***********************************************************************************

*************************** BWallet service id's *************************************
13	:	POSTPAID		
31	:	TRANSFER
12	:	TOPUP
11	:	LANDLINE
75	:	BPC
36	:	BROADBAND
40	:	Merchant payment

501	:	Change MPass
502 :	Transaction History
503 :	Share APP
***********************************************************************************

*************************** E-Load service id's *************************************
27	:	TOPUP
23	:	TRANSFER
303	: 	BULK TRANSFER
90	:	Check balance
	
501	:	Change MPIN
502 :	Transaction History
503 :	Share APP
504 :	Promotion
505 :	LOGOUT
*************************** Self-Care Service Types *************************************
0 	: Mobile Prepaid
1 	: Mobile Postpaid
2 	: Broadband Prepaid
3 	: Broadband Postpaid
4 	: Landline
***********************************************************************************

*************************** Self-Care Service Types *************************************
1 	: B - Tunes
2 	: MCA
3 	: 3G
4	: BB Prepaid plan purchase
5	: Voucher redeem(GSM prepaid)
6	: Data plan purchase
7	: S-S
8	: Available plan (GSM PO)
9	: Available plan (BB PO)
10	: Available plan (LL PO)
11	: Voucher redeem(BB prepaid)
12	: Data History
13	: Data share
14  : Stop package
15  : Packewise Threshold set 
16  : Global threshold
17	: Manage Accounts
18	: BB Prepaid data packs
19	: Go to BB screen
20	: Rate Plan
21	: set pin
22	: Topup
23	: Postpaid
24	: BB Prepaid
25	: BB Postpaid
26	: Landline
***********************************************************************************

************************** Global platform values **********************************
0 	: Self care
1 	: BWallet
2 	: E-load
3 	: M-Money
**********************************************************************************

*************************** Side Nav action *************************************
1  : Manage accounts
2  : Change PIN/Change MPASS

4  : Log out
10 : Manage services
11 : FAQ
12 : Contact us
13 : About us
14 : Feedback
15 : Transaction History
16 : Share
17 : Help and info
18 : Check balance
19 : E-load status check

************************************************************************************/

/*************************** CONFIGS ***************************/
var CONFIG_timeZone = 3600000 * 6;		// The time zone of server
var CONFIG_notifyHead = { "alert": "", "info": "", "error": "", "warning": "", "update": "" };
var CONFIG_minWebviewVersion = 58;       // Minimum required webview version
var isOnline = true;
var db = null;
/*************************** CONFIGS END ***************************/

/* ****** Variables to store cached jQuery objects ****** */
var $headerDiv;
var $headerText;
var $footerDiv;
var $bw_homeDiv;
var $bw_serviceDiv;
var $sidenav;
/* ****** Variables to store cached jQuery objects END ****** */

/* ****************** STORED values (Received from API's)  ****************************** */
var STORE = {
	btDistrictNRegions: [],
	termConditionLink: "",
	faqLink: "",
	apiCallUrl: "",
	updateLink: "",
	appUsername: "",
	appPassword: "",
	passKey: "",
	senderId: "",
	shareLink: "",
	adImage: "",
	infoLink: "",
	contactDetails: "",
	pushToken: ""
}
var NAVIGATION = {
	platform: 1,
	page: [0, 0, 0],
	serviceIndex: [0, 0, 0],
	bankIndex: 0,
	otpCount: 0,
	isSidenavOpen: false,
	isDoubleBack: false,
	bw_selfOther: 0,
	isFooterVisible: false,
	defaultPlatfrom: 0,
	currentReqType: 0,
	checkStatusCount: 0,
	backupPlatform: "",
	regPlatform: "", // This is used if used not registered for platform : EKYC changes


	setPage: function (pageNum, setPlatform) {
		if (setPlatform != undefined) {
			NAVIGATION.page[setPlatform] = pageNum;
		}
		else {
			NAVIGATION.page[NAVIGATION.platform] = pageNum;
		}
	},

	getPage: function () {
		return NAVIGATION.page[NAVIGATION.platform];
	},

	setService: function (service, bank) {
		NAVIGATION.serviceIndex[NAVIGATION.platform] = service;
		NAVIGATION.bankIndex = bank;
	},

	getService: function () {
		return NAVIGATION.serviceIndex[NAVIGATION.platform];
	},

	getBank: function () {
		return NAVIGATION.bankIndex;
	},

	showFooter: function () {
		if (!mySELFCARE.isLoggedIn)
			return false;
		$footerDiv.show();
		NAVIGATION.isFooterVisible = true;
	},

	hideFooter: function () {
		$footerDiv.hide();
		NAVIGATION.isFooterVisible = false;
	},

	back: function () {
		if (LOADING.isLoading) {
			return false;
		}
		if (NAVIGATION.isSidenavOpen) {
			$sidenav.sidenav('close');
			return false;
		}
		switch (NAVIGATION.platform) {
			case 0: NAVIGATION.bw_back();
				break;
			case 1: NAVIGATION.bw_back();
				break;
			case 2: NAVIGATION.bw_back();
				break;
			case 3: NAVIGATION.bw_back();
				break;
			case 4: NAVIGATION.bw_back();
				break;
		}
	},
	sc_back: function () {

	},
	bw_back: function () {
		switch (NAVIGATION.page[NAVIGATION.platform]) {
			case 1:	//Login page
				if (NAVIGATION.isDoubleBack) {
					closeApp();
				}
				else {
					M.toast({ html: MSG_BACK_TO_EXIT, completeCallback: function () { NAVIGATION.isDoubleBack = false; } });
					NAVIGATION.isDoubleBack = true;
				}
				break;
			case 2:	//OTP page
				if (NAVIGATION.platform == 0) {
					PLATFORM_POINTER.goToLogin();
				}//First PIN change screen
				else {
					PLATFORM_POINTER.logout();
				}

				NAVIGATION.otpCount = 0;
				PLATFORM_POINTER.$serviceDiv.hide().html('');
				break;
			case 3:	//Home page
				if (NAVIGATION.isDoubleBack) {
					PLATFORM_POINTER.logout();
				}
				else {
					M.toast({ html: MSG_BACK_TO_LOGOUT, completeCallback: function () { NAVIGATION.isDoubleBack = false; } });
					NAVIGATION.isDoubleBack = true;
				}

				break;
			case 4:	// Service page
				//$sc_serviceDiv.css("top","48px");
				PLATFORM_POINTER.showHomePage();
				PLATFORM_POINTER.$serviceDiv.html('');
				myBWALLET.GLOBAL_TRANS_DATA["TAB_SEL"] = undefined;
				myMMONEY.GLOBAL_TRANS_DATA["TAB_SEL"] = undefined;
				break;
			case 5:	// Reciept page
				PLATFORM_POINTER.showHomePage();
				PLATFORM_POINTER.$serviceDiv.html('');
				break;
			case 6:	// Confirmation page
				PLATFORM_POINTER.loadServicePage();
				break;
			case 10:	// Popup page
				$('.modal.open').modal('close');
				break;
			case 11: 	// feature discovery
				//$('.tap-target').featureDiscovery('close');
				break;
			case 12:	// Add account
				mySELFCARE.gotoManageAccount();
				break;
			case 13:	// Add account
				qrBack();
				break;
				case 200:	//
				PLATFORM_POINTER.showHomePage();
				break;
				case 100:	//
                				PLATFORM_POINTER.showHomePage();
                				break;
				case 101:
					case 102:
                				postData("995", { "SOURCEPARTY": mySELFCARE.sourceParty })
                				break;
			default:	//alert("Back function not handled");
		}
	},
	et_back: function () {

	},
	goToSC: function () {
		NAVIGATION.platform = 0;
		PLATFORM_POINTER = mySELFCARE;
		$(".tss-centerpage").hide();

		if (!PLATFORM_POINTER.isLoggedIn) {
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["APPNAME"]);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			PLATFORM_POINTER.showLogin();
		}
		else {
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
			$sc_homeDiv.fadeIn(150);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			mySELFCARE.updateHomeScreen();
			$(".tss-side-sc").show();
			if (mySELFCARE.LINKDET["2"].REG_STATUS == 0) {
				$(".tss-side-eloadLink").show();
			}
			else {
				$(".tss-side-eloadLink").hide();
			}

		}
		NAVIGATION.updateActiveFooter();
	},
	goToBW: function () {
		NAVIGATION.platform = 1;
		PLATFORM_POINTER = myBWALLET;
		NAVIGATION.regPlatform = { "platform": NAVIGATION.platform, "PLATFORM_POINTER": PLATFORM_POINTER, "WALLET_TYPE": "2" }; // EKYC changes
		if (!PLATFORM_POINTER.isLoggedIn) {
			myBWALLET.login();
		}
		else {
			$(".tss-centerpage").hide();
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
			$bw_homeDiv.fadeIn(150);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			$(".tss-side-bw").show();
			if (myBWALLET.afterLoginAction != "") {
				myBWALLET.afterLoginIntent();
			} else {
				myBWALLET.refreshHomePage()
			}
			NAVIGATION.updateActiveFooter();
		}
	},
	goToET: function () {
		NAVIGATION.platform = 2;
		PLATFORM_POINTER = myELOAD;
		if (!PLATFORM_POINTER.isLoggedIn) {
			myELOAD.login();
		}
		else {
			$(".tss-centerpage").hide();
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
			$et_homeDiv.fadeIn(150);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			$(".tss-side-et").show();
			NAVIGATION.updateActiveFooter();
		}
	},
	goToMM: function () {
		NAVIGATION.platform = 3;
		PLATFORM_POINTER = myMMONEY;
		NAVIGATION.regPlatform = { "platform": NAVIGATION.platform, "PLATFORM_POINTER": PLATFORM_POINTER, "WALLET_TYPE": "1" }; // EKYC changes
		if (!PLATFORM_POINTER.isLoggedIn) {
			myMMONEY.login();
		}
		else {
			$(".tss-centerpage").hide();
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
			$mm_homeDiv.fadeIn(150);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			$(".tss-side-mm").show();
			if (myMMONEY.afterLoginAction != "") {
				myMMONEY.afterLoginIntent();
			} else {
				myMMONEY.refreshHomePage()
			}
			NAVIGATION.updateActiveFooter();
		}
	},
	goToSRM: function () {
		NAVIGATION.platform = 4;
		PLATFORM_POINTER = mySRM;
		if (!PLATFORM_POINTER.isLoggedIn) {
			mySRM.afterQueryProfile();
		}
		else {
			$(".tss-centerpage").hide();
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
			$srm_homeDiv.fadeIn(150);
			$(".tss-sidenavitem:not(.tss-sideNavCommon)").hide();
			$(".tss-side-srm").show();
			NAVIGATION.updateActiveFooter();
			NAVIGATION.backupPlatform = "";
		}

	},
	fromHome: function (serviceId, flag) {
		var platform = flag == 0 ? flag : NAVIGATION.platform;
		$headerText.text(SERVICENAME_HASH[platform][serviceId]);
		$("#headerMenu").hide();
		$("#headerLogo").hide();
		$("#headerBack").show();
		NAVIGATION.hideFooter();
		try {
			$sidenav.sidenav("destroy");
		}
		catch (err) {

		}
	},
	toHome: function () {
		if (PLATFORM_POINTER.isLoggedIn) {
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["HOME"]);
		}
		else {
			$headerText.text(SERVICENAME_HASH[NAVIGATION.platform]["APPNAME"]);
		}
		$("#headerMenu").show();
		$("#headerLogo").show();
		$("#headerBack").hide();
		NAVIGATION.showFooter();
		$sidenav.sidenav({ edge: 'left', onOpenEnd: function () { NAVIGATION.isSidenavOpen = true }, onCloseEnd: function () { NAVIGATION.isSidenavOpen = false; }, onOpenStart: function () { M.Toast.dismissAll(); Keyboard.hide(); } });
	},
	clearLoginIntent: function (currentPlatform) {
		// Clear all intents here
	},
	updateActiveFooter: function () {
		$(".footerItem.active").removeClass("active")
		$(".footerItem[data-platform='" + NAVIGATION.platform + "']").addClass('active');
	},
	revertPlatform: function () {
		if (NAVIGATION.backupPlatform == "") {
			return false;
		}
		PLATFORM_POINTER = NAVIGATION.backupPlatform["PLATFORM_POINTER"];
		NAVIGATION.platform = NAVIGATION.backupPlatform["platform"];
		NAVIGATION.backupPlatform = "";
	}
}
/* ******************  ****************************** */

/******************service string declaratoin***********************/
var BANKNAME_HASH = {};
var QUERY_PROFILE = {};
/******************************************************/

/* ****************** Navigator.notification shortcuts  ****************************** */
var DIALOG_alert;
var DIALOG_confirm;
/* ****************** Navigator.notification shortcuts   END ****************************** */

/* Object to handle loading screen */
var LOADING = {
	$loadingDiv: "",
	$loadingText: "",
	isLoading: false,

	init: function () {
		this.$loadingDiv = $("#loadingDiv");
		this.$loadingText = $("#loadingText");
	},
	show: function (displayText) {
		this.$loadingText.text(displayText);
		this.$loadingDiv.show();
		this.isLoading = true;
	},
	hide: function () {
		this.$loadingDiv.hide();
		this.isLoading = false;
		if (NAVIGATION.getPage() == 2 || NAVIGATION.getPage() == 12) {
			$("#loadingDivClose").off().hide();
			LOADING.$loadingDiv.off();
		}
	},
	updateText: function (displayText) {
		this.$loadingText.text(displayText);
	}
}
/* ********************************* */


/* ******************* Setting up ajax default ****************/
$.ajaxSetup({
	cache: false,
});
/* ******************* Setting up ajax default END ****************/

/****************  Registering click and other events  ***************************/

function onDeviceReady() {
	MobileAccessibility.usePreferredTextZoom(false);
	DIALOG_alert = navigator.notification.alert;
	DIALOG_confirm = navigator.notification.confirm;
	document.removeEventListener("deviceready", onDeviceReady, false);
	checkInternetAvailability(); // internet listner
	openDbConnecion(); // open db connection
	ekycRequestProcessor();
	modusecho.checkWebView(function (versionString) {
		var versionArr = versionString.split("||");
		if (versionArr[1] >= CONFIG_minWebviewVersion) {
			//Webview version is ok
			navigator.splashscreen.show();
			AUTHENTICATE.initiate();	//calling authenticate
			//console.log("initiated");
			//$("#splashVideo").on("loadeddata",splashStart).on("ended",splashEnd).on("waiting",function(){
			//this.currentTime = this.currentTime}).on("canplay",function(){}).on("error",function(e){console.log(e)});
			//$("#splashVideo").html("<source src='images/BT-logo-splash.mp4' type='video/mp4'>");
			//console.log("Event added");

			document.addEventListener("backbutton", NAVIGATION.back, false);
			window.addEventListener('keyboardWillShow', keyboardShowHandler);		// to capture keyboard show
			window.addEventListener('keyboardWillHide', keyboardHideHandler);		// to capture keyboard show
		}
		else {
			// Web view update required
			if (versionArr[0] == 0) //Android system webview
			{
				DIALOG_alert(AUTHENTICATE.MSG_WEBVIEW_UPDATE, function () {
					cordova.InAppBrowser.open("https://play.google.com/store/apps/details?id=com.google.android.webview", '_system', 'location=yes');
					blockApp();
				}, CONFIG_notifyHead["alert"], 'Update now');
			}
			else if (versionArr[0] == 1) // Chrome
			{
				DIALOG_alert(AUTHENTICATE.MSG_CHROME_UPDATE, function () {
					cordova.InAppBrowser.open("https://play.google.com/store/apps/details?id=com.android.chrome", '_system', 'location=yes');
					blockApp();
				}, CONFIG_notifyHead["alert"], 'Update now');
			}
		}




		window.FirebasePlugin.setAnalyticsCollectionEnabled(false); // Disables analytics collection
		window.FirebasePlugin.subscribe("ROOT");
		window.FirebasePlugin.getToken(function (token) {
			// save this server-side and use it to push notifications to this device
			STORE.pushToken = token;

		}, function (error) {
			STORE.pushToken = "";
			console.error(error);
		});

		window.FirebasePlugin.onMessageReceived(function (notification) {
			console.log(JSON.stringify(notification));
			if ("ACTION_TYPE" in notification) {
				pushHandler(notification);
			}
			//DIALOG_alert(notification.DISP_MSG,dummy,notification.DISP_HEADER,notification.DISP_BTN);
		}, function (error) {
			console.error(error);
		});

		//processEkycData();

		//window.FirebasePlugin.clearAllNotifications();	// To clear all pending notifications 
		//window.FirebasePlugin.unregister();		//To stop reciving notification
	},
		function (error) {
			DIALOG_alert(MSG_FATAL_ERROR, blockApp, CONFIG_notifyHead["alert"], 'Ok');
		});
}

function checkInternetAvailability() {
	setInterval(() => {
		isOnline = (navigator.connection.type == Connection.NONE) ? false : true;
	}, 2000);
}

function openDbConnecion() {
	console.log("before db connection");
	db = window.sqlitePlugin.openDatabase({ name: 'btapp.db', location: 'default' }, () => {
		console.log("Connection successfull with DB")
	}, (err) => console.error("DB connection error: ", err));
	console.log("after db connection");
}

async function ekycRequestProcessor() {
	console.log("Request processor started");
	let tableCreatePromise = await new Promise(
		(resolve, reject) => db.executeSql("CREATE TABLE IF NOT EXISTS EkycReqDetails (id integer primary key, userId, reqType, reqData)", [],
			(result) => resolve(result), (error) => reject(flase)));
	while (true) {
		try {
			if (isOnline && tableCreatePromise && mySELFCARE.sourceParty != "") {
				// fetching records
				let fetchPromise = await new Promise(
					(resolve, reject) => db.executeSql(
						"select * from EkycReqDetails where userId = ?", [mySELFCARE.sourceParty],
						(result) => resolve(result),
						(error) => reject(false))
				);
				let data = await fetchPromise;
				if (data) {
					for (i = 0; i < data.rows.length; i++) {
						var id = data.rows.item(i).id;
						console.log("value : ", data.rows.item(i));
						postData(data.rows.item(i).reqType, JSON.parse(data.rows.item(i).reqData), true);
						db.executeSql(
							"delete from EkycReqDetails where id = ?",
							[id],
							(result) => console.log("record deleted successfully:", result),
							(error) => console.error("while deleting :", error)
						);
						await new Promise((r) => setTimeout(r, 1000));
					}
				}
			}
		} catch (error) {
			console.error("While processing :", error);
		}
		await new Promise((r) => setTimeout(r, 3000));
	}
}

$(document).ready(function () 		// document ready event
{
	document.addEventListener("deviceready", onDeviceReady, false);			// device ready event

	google.charts.load('current', { 'packages': ['corechart'] });	// LOADING GOOGLE CHARTS

	$('body').on('selectstart', function () { return false; });

	$sidenav = $("#slide-out");
	$headerDiv = $("#headerDiv");
	$headerText = $("#headerText");
	$footerDiv = $("#footerDiv");

	$bw_homeDiv = $("#bw_homeDiv")
	myBWALLET.$homeDiv = $bw_homeDiv;

	$bw_serviceDiv = $("#bw_service");
	myBWALLET.$serviceDiv = $bw_serviceDiv;

	$et_homeDiv = $("#et_homeDiv");
	myELOAD.$homeDiv = $et_homeDiv;

	$et_serviceDiv = $("#et_service");
	myELOAD.$serviceDiv = $et_serviceDiv;

	$sc_homeDiv = $("#sc_homeDiv");
	mySELFCARE.$homeDiv = $sc_homeDiv;

	$sc_serviceDiv = $("#sc_service");
	mySELFCARE.$serviceDiv = $sc_serviceDiv;

	$mm_homeDiv = $("#mm_homeDiv");
	myMMONEY.$homeDiv = $mm_homeDiv;

	$mm_serviceDiv = $("#mm_service");
	myMMONEY.$serviceDiv = $mm_serviceDiv;

	$srm_homeDiv = $("#srm_homeDiv");
	mySRM.$homeDiv = $srm_homeDiv;

	$srm_serviceDiv = $("#srm_service");
	mySRM.$serviceDiv = $srm_serviceDiv;

	LOADING.init();		// initializing the loading object

	//document.addEventListener("resume", appResumeHandler, false);
	//document.addEventListener("pause", appPauseHandler, false);

	$(document).on("click", ".tss-input-extra-icon", function () {			// to handle extra actions on input fields
		$imageDiv = $(this);
		var action = $imageDiv.attr("data-action");
		if (action == "") {
			return;
		}
		switch (action) {
			case "pin":	// to handle the eye icon in pin/password inputs
				eyeIconHandler($imageDiv);
				break;
			case "contact": // to handle contact icon in mobile number inputs
				contactIconHandler($imageDiv.attr("data-for"), "1");
				break;
			case "contact_landline":	// // to handle contact icon in landline number inputs
				contactIconHandler($imageDiv.attr("data-for"), "2");
				break;
			case "qr":  // qr code here
				qrHandler($imageDiv.attr("data-for"), $imageDiv.attr("data-qrtype"));
				break;
			case "ocr":
				$("#srm_input3").val("");
				ocrHandler($imageDiv.attr("data-for"), "frontIdData");
				break;
			case "ocrback":
				$("#srm_input4").val("");
				ocrHandler($imageDiv.attr("data-for"), "backIdData");
				break;


		}
	});


	$(document).on("focus", ".tss-focus-trigger", function () {
		if ($(this).parent().next().find("INPUT").prop("tagName") == "INPUT") {
			$(this).parent().next().find("INPUT").css("border-bottom", "1px solid #5DBB4C");
		}
		else {
			$(this).parent().next().addClass("tss-focus-class");
		}
	});

	$(document).on("blur", ".tss-focus-trigger", function () {
		var dataVal = $(this).val();
		if (dataVal == "") {
			$(this).parent().next().removeClass("tss-focus-class");
		}
	});

	/* handling clicks on home page*/
	$bw_homeDiv.on("click", "td", function () {
		var serviceId = $(this).attr("data-service");
		if (serviceId == "") {
			return;
		}
		var bankId = $(this).attr("data-bank");
		NAVIGATION.setService(serviceId, bankId);
		PLATFORM_POINTER.loadServicePage();
	});

	$mm_homeDiv.on("click", "td", function () {
		var serviceId = $(this).attr("data-service");
		if (serviceId == "") {
			return;
		}
		var bankId = $(this).attr("data-bank");
		NAVIGATION.setService(serviceId, bankId);
		PLATFORM_POINTER.loadServicePage();
	});

	$et_homeDiv.on("click", "td", function () {
		var serviceId = $(this).attr("data-service");
		if (serviceId == "") {
			return;
		}
		var bankId = $(this).attr("data-bank");
		NAVIGATION.setService(serviceId, bankId);
		PLATFORM_POINTER.loadServicePage();
	});

	$srm_homeDiv.on("click", "td", function () {
		var serviceId = $(this).attr("data-service");
		if (serviceId == "") {
			return;
		}
		NAVIGATION.setService(serviceId, "");
		PLATFORM_POINTER.loadServicePage();
	});

	$sc_homeDiv.on("click", "#sc_profile td", function () {
		var serviceId = $(this).attr("data-service");
		if(serviceId=="102"){
			
			postData("995", { "SOURCEPARTY": mySELFCARE.sourceParty })
			return false;
		}
		if(serviceId=="101"){
			PLATFORM_POINTER.simReserveAndUnreserve();
			return false;
		}

		var bankId = $(this).attr("data-bank");
		if (serviceId != "") {
			NAVIGATION.setService(serviceId, bankId);
			//PLATFORM_POINTER.loadServicePage();
		}
	});

	$bw_serviceDiv.on("click", "#bw_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "12": PLATFORM_POINTER.validateTopup();
				break;
			case "31": PLATFORM_POINTER.validateFundTransfer();
				break;
			case "44":
			case "75":
			case "11":
			case "37":
			case "116":
			case "36": PLATFORM_POINTER.validateBill();
				break;
			case "501": PLATFORM_POINTER.changePin();
				break;
			case "502": PLATFORM_POINTER.getTransHist();
				break;
			case "108": PLATFORM_POINTER.validateAirTime();
				break;
		}
	});

	$mm_serviceDiv.on("click", "#mm_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "12": PLATFORM_POINTER.validateTopup();
				break;
			case "35": PLATFORM_POINTER.validateFundTransfer();
				break;
			case "44":
			case "75":
			case "11":
			case "37":
			case "116":
			case "36": PLATFORM_POINTER.validateBill();
				break;
			case "47": PLATFORM_POINTER.validateB2W();
				break;
			case "46": PLATFORM_POINTER.validateW2B();
				break;
			case "501": PLATFORM_POINTER.changePin();
				break;
			case "502": PLATFORM_POINTER.getTransHist();
				break;
			case "40": PLATFORM_POINTER.validateMercPay();
				break;
			case "18": NAVIGATION.setService("90");
				PLATFORM_POINTER.loadServicePage();
				break;
			case "108": PLATFORM_POINTER.validateAirTime();
				break;
		}
	});

	$bw_serviceDiv.on("click", "#bw_billConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "44":
			case "75":
			case "11":
			case "37":
			case "116":
			case "36": PLATFORM_POINTER.payPObill();
				break;
			case "108": PLATFORM_POINTER.payAirtime();
				break;
		}
	});

	$sc_serviceDiv.on("click", "#sc_billConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "23": // TODO: confirm with godi
			case "25":
			case "26": PLATFORM_POINTER.payPObill();
				break;
		}
	});
	$mm_serviceDiv.on("click", "#mm_billConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "44":
			case "75":
			case "11":
			case "37":
			case "116":
			case "36": PLATFORM_POINTER.payPObill();
				break;
			case "108": PLATFORM_POINTER.payAirtime();
				break;
		}
	});

	$et_serviceDiv.on("click", "#et_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "27": PLATFORM_POINTER.validateTopup();
				break;
			case "23": PLATFORM_POINTER.validateTransfer();
				break;
			case "303": PLATFORM_POINTER.validateBulk();
				break;
			case "501":	//alert("");
				PLATFORM_POINTER.changePin();
				break;
			case "502": PLATFORM_POINTER.getTransHist();
				break;
		}
	});

	$sc_serviceDiv.on("click", "#sc_serviceInit", function () {
		switch (NAVIGATION.getService()) { // TODO: confirm with godi
			case "22":	// Topup 
			case "116":
				PLATFORM_POINTER.validateTopup();
				break;
			case "23":	// postpaid rma
			case "24":
			case "25": // BB postpaid bill pay
			case "26": // Landline bill pay
				PLATFORM_POINTER.validateBill();
				break;
			case "5": PLATFORM_POINTER.validateVoucher();
				break;
			case "7": PLATFORM_POINTER.validateTransfer();
				break;
			case "11": PLATFORM_POINTER.validateBBVoucher();
				break;
			case "12": PLATFORM_POINTER.getTransHist();
				break;
			case "13": PLATFORM_POINTER.validateShare();
				break;
			case "501": PLATFORM_POINTER.changePin();
				break;

		}
	});

	$mm_serviceDiv.on("click", "#mm_RMAbankSel", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "40":
			case "11":
			case "36":
			case "75":
			case "44":
			case "108":
			case "116":
			case "47": PLATFORM_POINTER.validateRmaBankEnq();
				break;
		}
	});

	$bw_serviceDiv.on("click", "#bw_RMAbankSel", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "40":
			case "11":
			case "36":
			case "75":
			case "44":
			case "108":
			case "116":
			case "47": PLATFORM_POINTER.validateRmaBankEnq();
				break;
		}
	});

	$mm_serviceDiv.on("click", "#mm_rmaOtpVerfn", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "40":
			case "11":
			case "36":
			case "75":
			case "44":
			case "108":
			case "116":
			case "47": PLATFORM_POINTER.verifyRmaOtp();
				break;
		}
	});

	$bw_serviceDiv.on("click", "#bw_rmaOtpVerfn", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "40":
			case "11":
			case "36":
			case "75":
			case "44":
			case "108":
			case "116":
			case "75": PLATFORM_POINTER.verifyRmaOtp();
				break;
		}
	});


	$bw_serviceDiv.on("click", "#bw_serviceConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "31":
			case "44":
			case "75":
			case "11":
			case "37":
			case "108":
			case "116":
			case "36": PLATFORM_POINTER.afterConfirm();
				break;
		}
	});

	$et_homeDiv.on("click", "#et_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "501": PLATFORM_POINTER.changePin();
				break;
		}
	});

	$sc_homeDiv.on("click", "#sc_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "501": PLATFORM_POINTER.changePin();
				break;
			case "21": PLATFORM_POINTER.setPin();
				break;
		}
	});


	$bw_homeDiv.on("click", "#bw_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "501": PLATFORM_POINTER.changePin();
				break;

		}
	});

	$mm_homeDiv.on("click", "#mm_serviceInit", function () {
		switch (NAVIGATION.getService()) {
			case "501": PLATFORM_POINTER.changePin();
				break;
		}
	});

	$mm_serviceDiv.on("click", "#mm_serviceConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "12":
			case "35":
			case "44":
			case "75":
			case "11":
			case "46":
			case "47":
			case "40":
			case "37":
			case "108":
			case "116":
			case "36": PLATFORM_POINTER.afterConfirm();
				break;
		}
	});

	$et_serviceDiv.on("click", "#et_serviceConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "27":
			case "23":
			case "303": PLATFORM_POINTER.afterConfirm();
				break;
		}
	});


	$mm_serviceDiv.on("keyup", "#mm_input3", function () {
		console.log("global key handler");
		if ($("#mm_input1 option:selected").val() == 1 || $("#mm_input1 option:selected").val() == "1") {
			if (parseFloat($("#mm_input3").val()) > parseFloat(myMMONEY.WALLET_BAL_HASH["1"])) {
				console.log("Amount is grtr");
				myMMONEY.showSplitAmtOption($("#mm_input3").val());
			}
			else {
				$("#splitAmtInfo").html('');
			}
		}
	});

	$mm_serviceDiv.on("change", "#mm_input1", function () {
		if ($("#mm_input1 option:selected").val() == "501") {
			$("#mm_balance").parent().hide();
			$("#splitAmtInfo").html('');
			myMMONEY.GLOBAL_TRANS_DATA["SPLITUPFLAG"] = "0";
		}
		else {
			$("#mm_balance").parent().show();
			//myMMONEY.GLOBAL_TRANS_DATA["SPLITUPFLAG"] = "0";
		}

	});


	$mm_serviceDiv.on("click", "#bngulBalaceSwitch", function () {
		console.log("unchecked check box");

		if ($(this).prop("checked") == true) {
			console.log("Checkbox is checked.");
			var rmaBalance = myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"] === undefined ? (parseFloat($("#mm_input3").val()) - parseFloat(myMMONEY.WALLET_BAL_HASH["1"])).toFixed(2) : (parseFloat(myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"]) - parseFloat(myMMONEY.WALLET_BAL_HASH["1"])).toFixed(2);
			$("#rmaBalance").html(CONFIG_currency + " " + rmaBalance);
			myMMONEY.GLOBAL_TRANS_DATA["WALLETAMOUNT"] = myMMONEY.WALLET_BAL_HASH["1"];
			myMMONEY.GLOBAL_TRANS_DATA["RMAAMOUNT"] = rmaBalance;
			myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"] = $("#mm_input3").val() ? undefined : myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"];
		}
		else if ($(this).prop("checked") == false) {
			console.log("Checkbox is unchecked.");
			var rmaBalance = myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"] === undefined ? $("#mm_input3").val() : myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"];
			$("#rmaBalance").html(CONFIG_currency + " " + rmaBalance);
			myMMONEY.GLOBAL_TRANS_DATA["WALLETAMOUNT"] = "0";
			myMMONEY.GLOBAL_TRANS_DATA["RMAAMOUNT"] = rmaBalance;
			myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"] = $("#mm_input3").val() === undefined ? $("#mm_input3").val() : myMMONEY.GLOBAL_TRANS_DATA["AMOUNT"];
		}
	});


	$mm_serviceDiv.on("click", "#rmaBalanceSwitch", function (e) {
		console.log("unchecked check box");

		if ($(this).prop("checked") == true) {
			console.log("Checkbox is checked.");
			e.preventDefault();
			return false;

		}
		else if ($(this).prop("checked") == false) {
			console.log("Checkbox is unchecked.");
			e.preventDefault();
			return false;
		}
	});

	$bw_serviceDiv.on("click", "#bw_serviceCancel,#bw_anotherPay", function () {
		PLATFORM_POINTER.loadServicePage();
	});

	$mm_serviceDiv.on("click", "#mm_serviceCancel,#mm_anotherPay", function () {
		PLATFORM_POINTER.loadServicePage();
	});

	$et_serviceDiv.on("click", "#et_serviceCancel,#et_anotherPay", function () {
		PLATFORM_POINTER.loadServicePage();
	});


	$bw_serviceDiv.on("click", "#bw_gotoHome", function () {
		PLATFORM_POINTER.showHomePage();
	});

	$mm_serviceDiv.on("click", "#mm_gotoHome", function () {
		PLATFORM_POINTER.showHomePage();
	});

	$et_serviceDiv.on("click", "#et_gotoHome", function () {
		PLATFORM_POINTER.showHomePage();
	});

	$("#updateProfile").click(function () {
		mySELFCARE.updateProfile();
	});

	$srm_serviceDiv.on("click", "#uploadKYC", function () {
		var selectedDoc = $(this).attr("upload-type");
		mySRM.GLOBAL_TRANS_DATA["CURDOC"] = selectedDoc;
		mySRM.showKYCupload();
	});
	$sc_serviceDiv.on("click", "#uploadKYC", function () {
		var selectedDoc = $(this).attr("upload-type");
		mySELFCARE.GLOBAL_TRANS_DATA["CURDOC"] = selectedDoc;
		mySELFCARE.showKYCupload();
	});

	/*Handling clicks on sidenav drawer item*/



	$sidenav.on("click", ".tss-sidenavitem", function () {
		$sidenav.sidenav('close');

		var action = $(this).attr("data-action");
		if (action == "") {
			return;
		}
		console.log("Action : " + action);
		switch (action) {
			case "1": PLATFORM_POINTER.gotoManageAccount();
				break;
			case "2": PLATFORM_POINTER.goToChangePin();
				break;
			case "4": PLATFORM_POINTER.logout();
				break;
			case "5": goToSettings();
				break;
			case "10": goToManageServices();
				break;
			case "11": loadFAQ();
				break;
			case "12": showContactScreen();
				break;
			case "13": showAboutScreen();
				break;
			case "14":			
			postData("995", { "SOURCEPARTY": mySELFCARE.sourceParty })			    
				break;
			case "15": if (NAVIGATION.platform == "0") {
				NAVIGATION.setService("12");
				PLATFORM_POINTER.loadServicePage();
			}
			else {
				PLATFORM_POINTER.goToTransHist();
			}
				break;
			case "16": shareApp();
				break;
			case "17": loadInfo();
				break;
			case "18": NAVIGATION.setService("90");
				PLATFORM_POINTER.loadServicePage();
				break;
			case "19": PLATFORM_POINTER.checkEloadsStatus();
				break;
			case "20": NAVIGATION.setService("3", "");
				PLATFORM_POINTER.loadServicePage();
				break;
			case "21": // Manage self numbers
				NAVIGATION.setService("520");
				PLATFORM_POINTER.loadServicePage();
				break;
			case "22": // Bank account mapping
				PLATFORM_POINTER.getBanks();
				break;
			case "23": // Bank account mapping status
				PLATFORM_POINTER.getBankStatus();
				break;
			case "24": // Subscriber ekyc resubmission
				PLATFORM_POINTER.getKYCDetails();
				break;
			case "30": // b-tune
				var serviceId = $(this).attr("data-service");
				var bankId = $(this).attr("data-bank");
				if (serviceId != "") {
					NAVIGATION.setService(serviceId, bankId);
					PLATFORM_POINTER.loadServicePage();
				}
				break;
			case "31": // mca
				var serviceId = $(this).attr("data-service");
				var bankId = $(this).attr("data-bank");
				if (serviceId != "") {
					NAVIGATION.setService(serviceId, bankId);
					PLATFORM_POINTER.loadServicePage();
				}
				break;
				case "40": // unreg
				DIALOG_confirm(MSG_BT_UNREGISTERATION,unRegisterUser , CONFIG_notifyHead['alert'], ['Unregister', 'Cancel']);
				
				break;

		}
	});

	function unRegisterUser(buttonIndex){
					
		if (buttonIndex == 1) {
			postData("1025", { "SOURCEPARTY": mySELFCARE.sourceParty })
		}
		
		
		}


	$sc_serviceDiv.on("click", "#sc_billConfirm", function () {
		switch (NAVIGATION.getService()) {
			case "23":
			case "24":
			case "25":
			case "116":
			case "26": PLATFORM_POINTER.payPObill();
				break;
		}
	});

	$sc_serviceDiv.on("click", "#sc_serviceCancel,#sc_anotherPay", function () {
		if (NAVIGATION.getService() == "116") {
			mySELFCARE.rmaBTTV();
			return;
		}
		PLATFORM_POINTER.loadServicePage();
	});

	$sc_serviceDiv.on("click", "#sc_gotoHome", function () {
		PLATFORM_POINTER.showHomePage();
	});



	/*handling clicks on prefix images of form fields*/
	$(document).on("click", "img.prefix", function (e) {
		$(this).next().click().focus();
	});

	/* Handling click on back arrow */
	$headerDiv.on("click", "#headerBack", function () {
		NAVIGATION.back();
	});

	/*Handling click on footer items*/
	$footerDiv.on("click", ".footerItem:not(.active)", function () {
		var platform = $(this).attr("data-platform");
		if (platform == "") {
			return;
		}

		if (mySELFCARE.LINKDET[platform].PLATFORM_STATUS != 1) {
			DIALOG_alert(MSG_PLATFORM_BLOCKED, dummy, CONFIG_notifyHead["alert"], 'Ok');
			return;
		}
		if (mySELFCARE.LINKDET[platform].REG_STATUS != 1) {
			DIALOG_alert(MSG_PLATFORM_NOT_LINKED, dummy, CONFIG_notifyHead["alert"], 'Ok');
			return;
		}

		NAVIGATION.backupPlatform = { "platform": NAVIGATION.platform, "PLATFORM_POINTER": PLATFORM_POINTER }

		switch (platform) {
			case "0": NAVIGATION.goToSC();
				break;
			case "1": NAVIGATION.goToBW();
				break;
			case "2": NAVIGATION.goToET();
				break;
			case "3": NAVIGATION.goToMM();
				break;
			case "4": NAVIGATION.goToSRM();
				break;
			default: return false;
		}

		if (PLATFORM_POINTER.isLoggedIn && NAVIGATION.page[NAVIGATION.platform] < 4) {
			NAVIGATION.toHome();
		}
	});

	//To handle flash on/off in QR screen
	$("#flashToggle").click(function () {
		QRScanner.getStatus(function (status) {
			//console.log(status);
			if (status.canEnableLight) {
				if (!status.lightEnabled) {
					enableFlashLight();
				}
				else {
					disableFlashLight();
				}
			}
		});
	});

}); // end of document ready function
/****************  Registering click and other events (done) ***************************/

var PLATFORM_POINTER;

function closeApp() {
	navigator.app.exitApp();
}

function reqSMSPermission() {
	NAVIGATION.otpCount++;
	if (NAVIGATION.otpCount > CONFIG_otpMaxRetry + 1) {
		NAVIGATION.otpCount = 0;
		navigator.notification.alert(MSG_MAX_RETRY_KYC_CONFIRM, PLATFORM_POINTER.goToLogin, CONFIG_notifyHead["alert"], 'Ok');
		return false;
	}

	postData("524", { 'SERVICENO': PLATFORM_POINTER.sourceParty });
}

function requestOTP() {
	/*var permissions = cordova.plugins.permissions;
	permissions.hasPermission(permissions.RECEIVE_SMS, checkPermissionCallback, checkPermissionError);*/
	checkPermissionCallback();
}

function checkPermissionError(error) { }

function checkPermissionCallback() {
	//alert(status.hasPermission);
	PLATFORM_POINTER.$homeDiv.load("otp.html", function () {
		$("#otpNote").text(CONFIG_OTP_DISABLE_NOTE);
		var $input = $('#input1');
		$input.keyup(function (e) {
			onlyNumberHandler($input);
			if ($input.val().length == bw_destNumMaxLenHash.OTP) {
				//Keyboard.hide();
				verifyOtp();
			}
		});
		$input.on("paste", function (e) {
			var data = e.originalEvent.clipboardData.getData('Text');
			if (!validateOtpPaste(data)) {
				e.preventDefault();
			}
		});
		$("#action2").click(function () {
			reqSMSPermission();
		});
		$("#action1").click(function () {
			verifyOtp();
		});

		$input.focus();
		Keyboard.show();


	});
	NAVIGATION.setPage(2);
	NAVIGATION.fromHome("APPNAME");
}

function verifyOtp() {
	var otp = $('#input1').val();
	if (otp == "" || !validateOTP(otp)) {
		$("#input1Help").attr("data-error", MSG_INVALID_OTP);
		$("#input1").addClass("invalid").focus();
		return false;
	}
	if (NAVIGATION.platform == 0 && mySELFCARE.GLOBAL_TRANS_DATA["isREGISTER"]) {
		postData("110", { 'SERVICENO': PLATFORM_POINTER.sourceParty, 'OTPVAL': otp, "PLATCOS": NAVIGATION.platform });
	}
	else {
		postData("660", { 'SERVICENO': PLATFORM_POINTER.sourceParty, 'OTPVAL': otp, "PLATCOS": NAVIGATION.platform });
	}
}

function resendAddAcctOtp(isSent) {
	NAVIGATION.otpCount++;
	if (NAVIGATION.otpCount > CONFIG_otpMaxRetry + 1) {
		NAVIGATION.otpCount = 0;
		navigator.notification.alert(MSG_MAX_RETRY_KYC_CONFIRM, mySELFCARE.gotoManageAccount, CONFIG_notifyHead["alert"], 'Ok');
		return false;
	}

	if (!isSent) {
		postData("200", { "SOURCEPARTY": localStorage.getItem("SC_LOGGEDMSISDN"), "SERVICETYPE": mySELFCARE.activeService, "ACTION": "1", "RESENDOTP": "1" });
	}
	else {
		validateAddNumOTP()
	}
}

function validateAddNumOTP() {
	/*var permissions = cordova.plugins.permissions;
	permissions.hasPermission(permissions.RECEIVE_SMS, validateAcctOtpcallBack, checkPermissionError);*/
	validateAcctOtpcallBack();
}

function validateAcctOtpcallBack() {
	$sc_serviceDiv.load("otp.html", function () {
		$("#otpNote").text(CONFIG_OTP_DISABLE_NOTE);
		var $input = $('#input1');
		$input.keyup(function (e) {
			onlyNumberHandler($input);
			if ($input.val().length == bw_destNumMaxLenHash.OTP) {
				//Keyboard.hide();
				verifyAddNumOtp();
			}
		});
		$input.on("paste", function (e) {
			var data = e.originalEvent.clipboardData.getData('Text');
			if (!validateOtpPaste(data)) {
				e.preventDefault();
			}
		});
		$("#action2").click(function () {
			resendAddAcctOtp();
		});
		$("#action1").click(function () {
			verifyAddNumOtp();
		});
		//alert(status.hasPermission);

		$input.focus();
		Keyboard.show();

	});
	NAVIGATION.fromHome("HOME");
	NAVIGATION.setPage(12);
}

function verifyAddNumOtp() {
	var otp = $('#input1').val();
	if (otp == "" || !validateOTP(otp)) {
		$("#input1Help").attr("data-error", MSG_INVALID_OTP);
		$("#input1").addClass("invalid").focus();
		return false;
	}
	postData("200", { "ACTION": "2", SOURCEPARTY: localStorage.getItem("SC_LOGGEDMSISDN"), "OTP": otp, "RESENDOTP": "0", "SERVICETYPE": mySELFCARE.activeService });
}

function showForgotPINOTP(isSent) {
	NAVIGATION.otpCount++;
	if (NAVIGATION.otpCount > CONFIG_otpMaxRetry + 1) {
		NAVIGATION.otpCount = 0;
		navigator.notification.alert(MSG_MAX_RETRY_KYC_CONFIRM, mySELFCARE.showLogin(), CONFIG_notifyHead["alert"], 'Ok');
		return false;
	}
	if (!isSent) {
		postData("600", { "SERVICENO": mySELFCARE.sourceParty });
	}
	else {
		validateforgotPINNumOTP()
	}
}

function validateforgotPINNumOTP() {
	/*var permissions = cordova.plugins.permissions;
	permissions.hasPermission(permissions.RECEIVE_SMS, validateforgotPINOtpcallBack, checkPermissionError);*/

	validateforgotPINOtpcallBack();
}

function validateforgotPINOtpcallBack() {
	$sc_homeDiv.load("otp.html", function () {
		$("#otpNote").text(CONFIG_OTP_DISABLE_NOTE);
		var $input = $('#input1');
		$input.keyup(function (e) {
			onlyNumberHandler($input);
			if ($input.val().length == sc_destNumMaxLenHash.OTP) {
				//Keyboard.hide();
				verifyforgotPINNumOtp();
			}
		});
		$input.on("paste", function (e) {
			var data = e.originalEvent.clipboardData.getData('Text');
			if (!validateOtpPaste(data)) {
				e.preventDefault();
			}
		});
		$("#action2").click(function () {
			//resendforgotPINNumOtp();
			showForgotPINOTP();
		});
		$("#action1").click(function () {
			verifyforgotPINNumOtp();
		});
		//alert(status.hasPermission);

		$input.focus();
		Keyboard.show();

	});
	NAVIGATION.fromHome("APPNAME");
	NAVIGATION.setPage(2);
}

function verifyforgotPINNumOtp() {
	var otp = $('#input1').val();
	if (otp == "" || !validateOTP(otp)) {
		$("#input1Help").attr("data-error", MSG_INVALID_OTP);
		$("#input1").addClass("invalid").focus();
		return false;
	}
	postData("610", { "OTPVAL": otp, "SERVICENO": mySELFCARE.sourceParty });
}

function getReqTime() {
	var dateVar = new Date();
	var utc = dateVar.getTime() + (dateVar.getTimezoneOffset() * 60000);
	var dateVar = new Date(utc + (CONFIG_timeZone));

	var day = ("0" + dateVar.getDate()).slice(-2);
	var month = ("0" + (dateVar.getMonth() + 1)).slice(-2);
	var year = dateVar.getFullYear();
	var hh = ("0" + dateVar.getHours()).slice(-2);
	var mm = ("0" + dateVar.getMinutes()).slice(-2);
	var ss = ("0" + dateVar.getSeconds()).slice(-2);
	var reqtime = day + "" + month + "" + year + hh + mm + ss;
	//alert(reqtime+ " , " + reqtime.length);
	return reqtime;
}

function genrefId(imsi) {
	imsi = imsi.replace(/[^0-9]/g, "");
	var imsilast4 = ("0000" + imsi).slice(-2);
	var random_num = Math.floor(Math.random() * (999 - 111 + 1)) + 111;

	var today = new Date();
	var start = new Date(today.getFullYear(), 0, 0);

	var ddd = Math.floor(today - start / (1000 * 60 * 60 * 24));
	ddd = ("00" + ddd).slice(-3);
	var hh = ("0" + today.getHours()).slice(-2);
	var mm = ("0" + today.getMinutes()).slice(-2);
	var ss = ("0" + today.getSeconds()).slice(-2);
	var refId = ss + random_num + imsilast4 + mm + ddd + hh;
	return refId;
}

function dummy() { }

function loadFAQ() {
	cordova.InAppBrowser.open(STORE.faqLink[NAVIGATION.platform], '_system', 'location=yes');
}

function loadInfo() {
	cordova.InAppBrowser.open(STORE.infoLink[NAVIGATION.platform], '_system', 'location=yes');
}

function updateAppConf(buttonIndex)		//for non mandatory version update
{
	if (buttonIndex == 1) {
		cordova.InAppBrowser.open(STORE.updateLink, '_system', 'location=yes');
	}
}

function updateAppMand() {
	cordova.InAppBrowser.open(STORE.updateLink, '_system', 'location=yes');
	blockApp();
}

function blockApp() {
	navigator.app.exitApp();		// to exit from app
}

function afterAuthenticate() {
	LOADING.hide();
	delete AUTHENTICATE;
	//$("#splashDiv").fadeOut(150);
	//$("#splashVideo").off();
	//$("#splashDiv").remove();
	$headerDiv.show();
	navigator.splashscreen.hide();
	switch (NAVIGATION.defaultPlatfrom) {
		case "0": NAVIGATION.goToSC();
			break;
		case "1": NAVIGATION.goToBW();
			break;
		case "2": NAVIGATION.goToET();
			break;
	}
}

/* After script load */
function completedLoadingScript() {
	if (CONFIG_showOptionalUpdatePopup && AUTHENTICATE.isOptionalUpdate) {
		DIALOG_confirm(STORE.updateMsg, updateAppConf, CONFIG_notifyHead['alert'], ['Update now', 'Update later']);
	}
	//console.log("Script loaded");
	var defaultPlatfrom = window.localStorage.getItem("DEFAULT_PLATFORM"); // Pass a key name to get its value.
	switch (defaultPlatfrom) {
		case "0": PLATFORM_POINTER = mySELFCARE;
			break;
		case "1": PLATFORM_POINTER = myBWALLET;
			break;
		case "2": PLATFORM_POINTER = myELOAD;
			break;
		case "3": PLATFORM_POINTER = myMMONEY;
			break;
		default:	//first time app launch
			window.localStorage.setItem("DEFAULT_PLATFORM", "0");
			defaultPlatfrom = "0";
			PLATFORM_POINTER = mySELFCARE;
	}


	myBWALLET.loadLogin(false);
	myELOAD.loadLogin(false);
	mySELFCARE.loadLogin(false);
	myMMONEY.loadLogin(false);

	$sidenav.sidenav({ edge: 'left', onOpenEnd: function () { NAVIGATION.isSidenavOpen = true }, onCloseEnd: function () { NAVIGATION.isSidenavOpen = false; }, onOpenStart: function () { M.Toast.dismissAll(); Keyboard.hide(); } });
	NAVIGATION.defaultPlatfrom = defaultPlatfrom;

	/*if(AUTHENTICATE.isfirstLoadFlag)
	{
		afterAuthenticate();
		//console.log("Video has already ended");
	}
	else
	{
		AUTHENTICATE.isfirstLoadFlag = true;
		//console.log("CompleteLoadingScript : Waiting for video to end");
	}*/
	afterAuthenticate();
}

function splashEnd() {
	//clearInterval(AUTHENTICATE.videoCheckerInterval);
	clearTimeout(AUTHENTICATE.videoFallBackTimeout);
	if (AUTHENTICATE.isfirstLoadFlag) {
		//console.log("VIDEO : Script is already loaded");
		afterAuthenticate();
	}
	else {
		//console.log("VIDEO : Waiting for script to load");
		AUTHENTICATE.isfirstLoadFlag = true;
		LOADING.show("Loading...");
	}
}

function splashStart() {
	//console.log("inside splash start");
	AUTHENTICATE.videoFallBackTimeout = setTimeout(function () {
		$("#splashVideo")[0].muted = true;
		$("#splashVideo")[0].pause();
		splashEnd();
	}, 4000);
	//console.log("Timeout is set");
	$("#splashDiv").show();
	//console.log("Splash is shown");
	$("#splashVideo")[0].play();
	//console.log("Splash is playing");
	/*
	AUTHENTICATE.videoCheckerInterval = setInterval(function(){
		currentTime=$("#splashVideo")[0].currentTime
		if(AUTHENTICATE.videoLastTime == currentTime)
		{
			//$("#splashVideo")[0].currentTime = currentTime;
			//$("#splashVideo")[0].play()
			//$("#splashVideo")[0].muted = true;
			//console.log(currentTime);
		}
		AUTHENTICATE.videoLastTime = currentTime
		
		//console.log("play started");
		//$("#splashVideo")[0].currentTime = $("#splashVideo")[0].currentTime;
		//$("#splashVideo")[0].currentTime.play
		
	},200);
	*/
}

function showContactScreen() {
	PLATFORM_POINTER.$serviceDiv.load("contact.html", function () {
		PLATFORM_POINTER.$homeDiv.hide();

		$("#contactMail").attr("href", "mailto:" + STORE.contactDetails.MAIL)
		$("#contactMail").text(STORE.contactDetails.MAIL);

		$("#contactNumber").attr("href", "tel:" + STORE.contactDetails.NUMBER)
		$("#contactNumber").text(STORE.contactDetails.NUMBER);

		$("#twitterLink").attr("href", STORE.contactDetails.TWITTER)

		$("#facebookLink").attr("href", STORE.contactDetails.FACEBOOK)

		$("#youtubeLink").attr("href", STORE.contactDetails.YOUTUBE)

		PLATFORM_POINTER.$serviceDiv.fadeIn(150);
	});
	NAVIGATION.fromHome("CONTACT", 0);
	NAVIGATION.setPage(PLATFORM_POINTER.isLoggedIn ? 4 : 2);
}

function showAboutScreen() {
	PLATFORM_POINTER.$serviceDiv.load("about.html", function () {
		PLATFORM_POINTER.$homeDiv.hide();
		$("#appVersion").text(navigator.appInfo.version);
		PLATFORM_POINTER.$serviceDiv.fadeIn(150);
	});
	NAVIGATION.fromHome("ABOUT", 0);
	NAVIGATION.setPage(PLATFORM_POINTER.isLoggedIn ? 4 : 2);
}

function shareApp() {
	var options = {
		message: CONFIG_shareMsg, // not supported on some apps (Facebook, Instagram)
		//subject: '', // fi. for email
		//files: ['', ''], // an array of filenames either locally or remotely
		url: STORE.shareLink,
		chooserTitle: 'Choose an app to share' // Android only, you can override the default share sheet title
	}

	window.plugins.socialsharing.shareWithOptions(options, function () {
		//success
	},
		function () {
			DIALOG_alert(MSG_FATAL_ERROR, dummy, CONFIG_notifyHead["alert"], 'Ok');
		});
}

function ocrHandler(inputObj, side) {

	$srm_homeDiv.hide();
	mySRM.GLOBAL_TRANS_DATA["OCRINPUTOBJ"] = inputObj;
	mySRM.GLOBAL_TRANS_DATA["IDSIDE"] = side;
	var options = {
		"sourceType": 1,
		"crop": true,
		"edgeDetection": true,
		"targetHeight": 720,
		"targetWidth": 1080,
		"base64": true

	}
	cordova.plugins.DocumnetScannerPlugin.scanDoc(options, onSuccesOcr, onFailureOcr);
	
}

/*Changes are
	  called compressimage function to compress image size and assign it to document
	  */

function onSuccesOcr(dataUrl) {


	// calll compresssImage function to compress
			mySRM.GLOBAL_TRANS_DATA[mySRM.GLOBAL_TRANS_DATA["IDSIDE"]] = dataUrl;
	
	
	textocr.recText(4, /*3,*/ dataUrl, onSuccess, onFail); // removed returnType (here 3) from version 2.0.0 
	// for sourceType Use 0,1,2,3 or 4
	// for returnType Use 0,1,2 or 3 // 3 returns duplicates[see table]


	function onSuccess(recognizedText) {
		$("#srm_ocrdiv").show();
		console.log(recognizedText);
		if (mySRM.GLOBAL_TRANS_DATA["IDSIDE"] == "frontIdData") {
			$("#srm_input3").val("OCR scan completed.");
			$("#srm_ocrdiv").show();
		} else if (mySRM.GLOBAL_TRANS_DATA["IDSIDE"] == "backIdData") {
			$("#srm_input4").val("OCR scan completed.");
		}

		var blocks = recognizedText["blocks"]["blocktext"];
		for (i = 0; i < blocks.length; i++) {
			var extract = blocks[i];
			var myRegexp = /Citizenship ID No. ([0-9]+)/g;
			var match = myRegexp.exec(extract);
			if (match) {
				mySRM.GLOBAL_TRANS_DATA["IDNUM"] = match[1];
				$("#" + mySRM.GLOBAL_TRANS_DATA["OCRINPUTOBJ"]).val(match[1]);
			}
			/////////////////////////////////////////////////////////////////////////////
			myRegexp = /Name(:\s|:)([a-z A-z]+)/g;
			match = myRegexp.exec(extract);
			if (match) {
				mySRM.GLOBAL_TRANS_DATA["USERNAME"] = match[2];
			}
			///////////////////////////////////////////////////////////////////////
			myRegexp = /Date of Birth(:\s|:)(\d{1,4}([.\-/])\d{1,2}([.\-/])\d{1,4})/g;
			match = myRegexp.exec(extract);
			if (match) {
				mySRM.GLOBAL_TRANS_DATA["DOB"] = match[2];
			}
			///////////////////////////////////////////////////////////////////////
			myRegexp = /Date of Expiry(:\s|:)(\d{1,4}([.\-/])\d{1,2}([.\-/])\d{1,4})/g;
			match = myRegexp.exec(extract);
			if (match) {
				let dateArry = match[2].split("/");
				mySRM.GLOBAL_TRANS_DATA["EXPIRYDATE"] = dateArry[2] + "-" + dateArry[1] + "-" + dateArry[0];
			}
			///////////////////////////////////////////////////////////////////////
			myRegexp = /Date of Issue(:\s|:)(\d{1,4}([.\-/])\d{1,2}([.\-/])\d{1,4})/g;
			match = myRegexp.exec(extract);
			if (match) {
				let dateArry = match[2].split("/");
				mySRM.GLOBAL_TRANS_DATA["ISSUEDATE"] = dateArry[2] + "-" + dateArry[1] + "-" + dateArry[0];
			}
			myRegexp = /Date of lssue(:\s|:)(\d{1,4}([.\-/])\d{1,2}([.\-/])\d{1,4})/g;
			match = myRegexp.exec(extract);
			if (match) {
				let dateArry = match[2].split("/");
				mySRM.GLOBAL_TRANS_DATA["ISSUEDATE"] = dateArry[2] + "-" + dateArry[1] + "-" + dateArry[0];
			}
			myRegexp = /Date of 1ssue(:\s|:)(\d{1,4}([.\-/])\d{1,2}([.\-/])\d{1,4})/g;
			match = myRegexp.exec(extract);
			if (match) {
				let dateArry = match[2].split("/");
				mySRM.GLOBAL_TRANS_DATA["ISSUEDATE"] = dateArry[2] + "-" + dateArry[1] + "-" + dateArry[0];
			}
			///////////////////////////////////////////////////////////////////////
			myRegexp = /Household No.: ([0-9]+)/g;
			match = myRegexp.exec(extract);
			if (match) {
				mySRM.GLOBAL_TRANS_DATA["HOUSEHOLDNO"] = match[1];
			}
			///////////////////////////////////////////////////////////////////////
			myRegexp = /Sex(:\s|:)([a-z A-z]+)/g;
			match = myRegexp.exec(extract);
			if (match) {
				mySRM.GLOBAL_TRANS_DATA["GENDER"] = match[2];
			}

		}
		M.updateTextFields();
		M.toast({ html: MSG_OCR_INFO })
	}
	function onFail(message) {
		DIALOG_alert('Failed to process the image please retry.', dummy, CONFIG_notifyHead["alert"], 'Ok');
	}
}
function onFailureOcr(error) {
	//DIALOG_alert(MSG_CAMERA_FAILED, dummy, CONFIG_notifyHead["alert"], 'Ok');
}

function contactIconHandler(inputObj) {
	navigator.contacts.pickContact(function (contact, input = inputObj) {
		var numberArray = contact.phoneNumbers;
		if (numberArray == null) {
			DIALOG_alert(MSG_CONTACT_INVALID, dummy, CONFIG_notifyHead["alert"], 'Ok');
			$("#" + input).focus();
			return false;
		}
		var numArrLen = numberArray.length;
		if (numArrLen > 1) {
			displayNumbers(numberArray, input);
		}
		else if (numArrLen == 1) {
			var isValidContact = false;
			var serviceId = NAVIGATION.getService();
			var number = numberArray[0].value;
			number = number.replace(RE_services["CLEANCONTACT"], "").slice(-8);
			if (validateAcctNum(number, RE_services[serviceId])) {
				isValidContact = true;
				$("#" + input).val(number);
				M.updateTextFields();
				$("#" + input).keyup();
			}
			if (!isValidContact) {
				DIALOG_alert(MSG_CONTACT_INVALID, dummy, CONFIG_notifyHead["alert"], 'Ok');
				$("#" + input).focus();
			}
		}
	}, function (err) {
		if (err != 6 && err != 20) {
			DIALOG_alert(MSG_CONTACT_FAILED, dummy, CONFIG_notifyHead["alert"], 'Ok');
		}
	});
}

function displayNumbers(contactNumbers, $inputObj) {
	var validContactCnt = 0;
	var contactHtml = "<li class='collection-header tss-padding16side' style='padding:0px 16px'><p style='font-weight:bold'>Choose a number</p>	</li><div id='contactList'>";
	var contactObj = {};
	var contactMainHtml = '<li class="tss-padding16side collection-item contact" style="padding:16px 16px" data-number="__MSISDN__"><div><i class="material-icons mdi mdi-24px mdi-phone tss-color-prime">&nbsp;&nbsp;__MSISDN__<a href="#!" class="secondary-content"><span class="tss-contact-type">(__MSISDNTYPE__)</span></a></i></div></li>';
	var serviceId = NAVIGATION.getService();
	for (var i = 0; i < contactNumbers.length; i++) {
		var phoneNum = contactNumbers[i].value;
		phoneNum = phoneNum.replace(RE_services["CLEANCONTACT"], "").slice(-8);
		if (validateAcctNum(phoneNum, RE_services[serviceId])) {
			if (!(phoneNum in contactObj)) {
				contactObj[phoneNum] = contactNumbers[i].type;
			}
		}
	}
	Object.keys(contactObj).forEach(function (key) {
		//looping through contact Hash Object
		validContactCnt++;
		var contactHtmlTemp = contactMainHtml;
		contactHtmlTemp = contactHtmlTemp.replace(/__MSISDN__/g, key);
		contactHtmlTemp = contactHtmlTemp.replace(/__MSISDNTYPE__/g, contactObj[key]);
		contactHtml += contactHtmlTemp;
	});

	if (validContactCnt == 0) {
		DIALOG_alert(MSG_CONTACT_INVALID, dummy, CONFIG_notifyHead["alert"], 'Ok');
	}
	else if (validContactCnt == 1) {
		$("#" + $inputObj).val(contactNumbers[0].value);
		M.updateTextFields();
		$("#" + $inputObj).keyup();
	}
	else {
		contactHtml += "</div>";
		$("#contactInfo").html(contactHtml);
		$('#contact-modal').modal({
			onCloseEnd: function () {
				NAVIGATION.setPage(4);
				$('#contact-modal').modal('destroy');
				$("#contactList").remove();
			}
		});
		NAVIGATION.setPage(10);
		$('#contact-modal').modal('open');
		$("#contactList").on("click", "li", function () {
			$("#" + $inputObj).val($(this).attr("data-number"));
			M.updateTextFields();
			$("#" + $inputObj).keyup();
			$('#contact-modal').modal('close');
		});
	}
}

function eyeIconHandler($imageDiv) {
	var $inputId = $("#" + $imageDiv.attr("data-for"));
	$inputId.focus();
	if ($inputId.css("-webkit-text-security") == "disc") {
		$imageDiv.removeClass("mdi-eye-off");
		$imageDiv.addClass("mdi-eye");
		$inputId.css("-webkit-text-security", "none");
	}
	else {
		$imageDiv.removeClass("mdi-eye");
		$imageDiv.addClass("mdi-eye-off");
		$inputId.css("-webkit-text-security", "disc");
	}
}

function qrHandler($imageDiv, qrType) {
	QRScanner.prepare(function (err, status) {
		if (err) {
			DIALOG_alert(MSG_CAMERA_FAILED, dummy, CONFIG_notifyHead["alert"], 'Ok');
		}
		if (status.authorized) {
			PLATFORM_POINTER.$serviceDiv.hide();
			$("#cameraDiv").show();
			QRScanner.show(function (status) {
				NAVIGATION.setPage(13);
				QRScanner.scan(function (err, text) {
					if (err) {
						if (err.name != "SCAN_CANCELED") {
							//alert(JSON.stringify(err));
							DIALOG_alert(MSG_SCAN_FAILED, dummy, CONFIG_notifyHead["alert"], 'Ok');
						}
						return;
					}
					switch (qrType) {
						case "1":	// GSM Voucher QR
							$("#sc_input2").val(text);
							M.updateTextFields();
							mySELFCARE.GLOBAL_TRANS_DATA["VOUCHERREDTYPE"] = "2";
							mySELFCARE.validateVoucher();
							break;
						case "2":	// BB Voucher QR
							$("#sc_input2").val(text);
							M.updateTextFields();
							mySELFCARE.GLOBAL_TRANS_DATA["VOUCHERREDTYPE"] = "2";
							mySELFCARE.validateBBVoucher();
							break;
						case "3":	//Merchant payment QR
							try {
								var code = atob(text);
								var final = "";
								for (i = 0; i < code.length; i++) {
									final += String.fromCharCode(code.charCodeAt(i) - ((i + 1) % 10))
								}
								var jsonData = JSON.parse(final);
								//console.log(jsonData);
							}
							catch (e) {
								navigator.notification.alert(MSG_INVALID_QR, dummy, CONFIG_notifyHead["alert"], 'Ok');
								qrBack();
							}
							PLATFORM_POINTER.serviceWiseQR(jsonData, $imageDiv);
							break;
					}
					qrBack();
				});
			});
		}
		else if (status.denied) {
			// The video preview will remain black, and scanning is disabled. We can
			// try to ask the user to change their mind, but we'll have to send them
			// to their device settings with `QRScanner.openSettings()`.
		}
	});
}

function qrBack() {
	QRScanner.getStatus(function (status) {
		if (status.lightEnabled) {
			disableFlashLight();
		}
		QRScanner.cancelScan();
		QRScanner.hide(function () {
			$("html").css("background", "white");
		});
		QRScanner.destroy(function (status) {
			$("#cameraDiv").hide();
			PLATFORM_POINTER.$serviceDiv.show();
			NAVIGATION.setPage(4);
			$("#sc_input2").focus();
			$("html").css("background", "white");
		});
	});

}

function disableFlashLight() {
	QRScanner.disableLight(function (err, status) {
		if (!status.lightEnabled) {
			$("#flashIcon").removeClass("mdi-flash").addClass("mdi-flash-off")
		}
	});
}

function enableFlashLight() {
	QRScanner.enableLight(function (err, status) {
		if (status.lightEnabled) {
			$("#flashIcon").removeClass("mdi-flash-off").addClass("mdi-flash")
		}
	});
}

function keyboardShowHandler() {
	$footerDiv.hide();
}

function keyboardHideHandler() {
	if (NAVIGATION.isFooterVisible) {
		$footerDiv.show();
	}
}

function pushHandler(notification) {
	switch (notification.ACTION_TYPE) {
		case "1": DIALOG_alert(notification.DISP_MSG, dummy, notification.DISP_HEADER, notification.DISP_BTN);
			break;
		case "2":
			DIALOG_confirm(notification.DISP_MSG, function (buttonIndex, url = notification.REDIRECT_URL) {
				if (buttonIndex == 1) {
					//console.log(url);
					cordova.InAppBrowser.open(url, '_system', 'location=yes');
				}
			}, notification.DISP_HEADER, [notification.DISP_BTN, "Cancel"]);
			break;
	}
}

function goToManageServices() {
	postData("870", { "SOURCEPARTY": mySELFCARE.sourceParty });
}

function showCamera(id) {
	var options = {
		"sourceType": 1,
		"crop": true,
		"edgeDetection": true,
		"targetHeight": 720,
		"targetWidth": 1080,
		"base64": true

	}
	cordova.plugins.DocumnetScannerPlugin.scanDoc(options, onCameraSuccess, onCameraFail);
}

function showGallery() {
	var options = {
		"sourceType": 0,
		"targetHeight": 720,
		"targetWidth": 1080,
		"base64": true

	}
	cordova.plugins.DocumnetScannerPlugin.scanDoc(options, onCameraSuccess, onCameraFail);
}

/*Changes are
	  called compressimage function to compress image size and assign it to document
	  */
function onCameraSuccess(url) {

	compressImage(url).then(function (value) {

		if (PLATFORM_POINTER == myBWALLET) {
			var $currentDoc = myBWALLET.GLOBAL_TRANS_DATA["BANKUPDOCS"];
			$currentDoc.attr("image-data", value)
			$currentDoc.children("img").attr("src", "data:image/jpg;base64," + value)
			$("#imageID" + $currentDoc.attr("file-index") + "help").html(MSG_EKYC_DOCUMENT_SUCCESS);
		}
		else {
			$("#" + PLATFORM_POINTER.GLOBAL_TRANS_DATA["CURDOC"].split("|")[0]).attr('src', "data:image/jpg;base64," + value);
			$("#" + PLATFORM_POINTER.GLOBAL_TRANS_DATA["CURDOC"].split("|")[0]).attr('data-url', value);
			$("#" + PLATFORM_POINTER.GLOBAL_TRANS_DATA["CURDOC"].split("|")[0] + "help").html(MSG_EKYC_DOCUMENT_SUCCESS);
		}
	});


}

function onCameraFail(err) {
	console.error(err);
	//DIALOG_alert(MSG_CAMERA_FAILED, dummy, CONFIG_notifyHead["alert"], 'Ok');
}

function getFileContentAsBase64(path, successCallback, failureCallback) {
	window.resolveLocalFileSystemURL(path, gotFile, failureCallback);
	function gotFile(fileEntry) {
		fileEntry.file(function (file) {
			var reader = new FileReader();
			reader.onloadend = function (e) {
				var content = this.result;
				//console.log('content looks as it should:::', content);
				successCallback(content);
			};
			reader.readAsDataURL(file);
		});
	}
}




/*created function to compress image size */
async function compressImage(url) { //Tudo- need to move app
	var maxWidth = 1024;
	var maxHeight = 768;
	var img = new Image();
	var size = url.length / 1e+6;
	if (size > 1.2) {
		img.src = "data:image/jpg;base64," + url;

		await new Promise((resolve) => { img.onload = resolve; });
		// image is loaded and we have image width 

		var imgWidth = img.width,
			imgHeight = img.height;
		var ratio = 1, ratio1 = 1, ratio2 = 1;
		ratio1 = maxWidth / imgWidth;
		ratio2 = maxHeight / imgHeight;
		if (ratio1 < ratio2) {
			ratio = ratio1;
		}
		else {
			ratio = ratio2;
		}
		var canvasCopy = document.createElement("canvas");
		var copyContext = canvasCopy.getContext("2d");
		var canvasCopy2 = document.createElement("canvas");
		var copyContext2 = canvasCopy2.getContext("2d");
		canvasCopy.width = imgWidth;
		canvasCopy.height = imgHeight;
		copyContext.drawImage(img, 0, 0);

		// init
		canvasCopy2.width = imgWidth;
		canvasCopy2.height = imgHeight;
		copyContext2.drawImage(canvasCopy, 0, 0, canvasCopy.width, canvasCopy.height, 0, 0, canvasCopy2.width, canvasCopy2.height);


		var rounds = 2;
		var roundRatio = ratio * rounds;
		var i = 1
		while (size > 1.2) {

			canvasCopy.width = imgWidth * roundRatio / i;
			canvasCopy.height = imgHeight * roundRatio / i;

			copyContext.drawImage(canvasCopy2, 0, 0, canvasCopy2.width, canvasCopy2.height, 0, 0, canvasCopy.width, canvasCopy.height);

			// copy back
			canvasCopy2.width = imgWidth * roundRatio / i;
			canvasCopy2.height = imgHeight * roundRatio / i;
			copyContext2.drawImage(canvasCopy, 0, 0, canvasCopy.width, canvasCopy.height, 0, 0, canvasCopy2.width, canvasCopy2.height);



			url = canvasCopy2.toDataURL("image/jpg", canvasCopy)
			size = url.length / 1e+6;
			url = url.substring(url.indexOf(",") + 1);
			i++;

		}




		url = url.substring(url.indexOf(",") + 1);


	}

	return url;
}










/**
 * This function will handle the conversion from a file to base64 format
 *
 * @path string
 * @callback function receives as first parameter the content of the image
 */








function getBase64(path) {

	// Convert image
	getFileContentAsBase64(path, function (base64Image) {
		//window.open(base64Image);
		//console.log("base64 string============="+base64Image);

		setTimeout(function () {
			mySRM.GLOBAL_TRANS_DATA["BASE64DATA"] = base64Image.split(",")[1].toString();
		}, 1500);
		return base64Image.split(",")[1].toString();
	});
}


/*Encryption function */
function asd(data) {
	var final = "";
	var dataLen = data.length
	for (i = 0; i < dataLen; i++) {
		final += String.fromCharCode(data.charCodeAt(i) + ((i + 1) % 100))
	}
	var finalData = btoa(final);
	return finalData;
}

/* Decryption function */
function qwe(data) {
	//code = data.replace(/ /g,"\n");
	var code = atob(data);
	var final = "";
	for (i = 0; i < code.length; i++) {
		final += String.fromCharCode(code.charCodeAt(i) - ((i + 1) % 100))
	}
	//alert(final);
	var jsonData = JSON.parse(final);
	return jsonData;
}


AUTHENTICATE = {

	// When server sends invalid response during authenticate
	MSG_AUTH_FAIL: "Some error occurred.Please try again after sometime",

	// When authenticate response not received (HTTPS status != 200) 
	MSG_AUTH_NO_RESP: "Unable to connect to server. Please try again after sometime",

	//No Internet message
	MSG_AUTH_NO_INTERNET: "Unable to connect to server. Please check your Internet connection and try again",

	MSG_WEBVIEW_UPDATE: "We have detected that the 'Android System Webview' APP is not up-to-date. An updated version of the APP is required for My BT APP to run.Please update to continue",

	MSG_CHROME_UPDATE: "We have detected that the 'Chrome' APP is not up-to-date. An updated version of the APP is required for My BT APP to run.Please update to continue",

	MSG_FATAL_ERROR: "Some error ocurred . Please update android webview/chrome to continue..",

	isfirstLoadFlag: false,

	videoLastTime: "",
	videoCheckerInterval: "",

	videoFallBackTimeout: "",

	isOptionalUpdate: false,

	initiate: function () {
		var parentJSON = {};
		var childJSON = {};
		var headerJSON = {};
		var reqTime = getReqTime();
		headerJSON["H1"] = asd(device.platform);
		headerJSON["H2"] = asd("btapp");
		headerJSON["H3"] = asd("btapp");
		headerJSON["H4"] = asd(device.uuid); //deviceId
		headerJSON["H5"] = asd("10");

		childJSON["APPVERSION"] = navigator.appInfo.version;
		childJSON["REQTIME"] = reqTime;
		childJSON["REQTYPE"] = asd("10");
		childJSON["OPERATION"] = "AUTHORIZATION";
		childJSON["CUSTOMERTYPE"] = "5";
		childJSON["REFID"] = genrefId(device.uuid);

		parentJSON["BT"] = asd(JSON.stringify(childJSON));

		$.ajax({
			type: "POST",
			/////////////////////////// Live URL//////////////////////////////
				url: "http://mybtapp.bt/fcgi-bin/authCustomer",
			////////////////////////// TQA Lab URL ///////////////////////////
			//url			: "http://182.74.23.92:8032/fcgi-bin/authCustomer",
			///////////////////////// Development URL ////////////////////////
			    // url: "http://182.74.23.92:8090/fcgi-bin/authCustomer",
		//	    url: "http://10.0.1.121:8090/fcgi-bin/authCustomer",
			////////////////////// Testbed URL//////////////////////////////
			// url				: "http://202.144.156.136/fcgi-bin/authCustomer",
			/////////////////////////////////////////////////////////////////////////
			//url			: "http://10.0.1.123:8090/fcgi-bin/authCustomer",	// Testing server
			//url			: "http://182.74.23.92:8032/fcgi-bin/authCustomer",	// Testing server (Public IP)
			//url			: "http://182.74.23.92:8037/fcgi-bin/authCustomer",	// (132 server)
			//url			: "http://10.0.1.132:8090/fcgi-bin/authCustomer",

			data: JSON.stringify(parentJSON),
			timeout: 20000,
			headers: headerJSON,
			contentType: "application/json ; charset=utf-8",
			crossDomain: true,
			dataType: 'json',
			success: function (response) {
				console.log(response)
				var simpleResp = qwe(response.BT);
				switch (simpleResp.RESPONSE.RESPCODE) {
					case "0000": // Success,Latest version
						AUTHENTICATE.authenticateSuccessCallback(simpleResp);
						break;
					case "1003": // Optional update available
						STORE.updateLink = simpleResp.PLAYSTORE;
						AUTHENTICATE.isOptionalUpdate = true;
						AUTHENTICATE.authenticateSuccessCallback(simpleResp);
						break;
					case "1002": // Mandatory update
						STORE.updateLink = simpleResp.PLAYSTORE;
						DIALOG_alert(simpleResp.RESPONSE.RESPDESC, updateAppMand, CONFIG_notifyHead['update'], 'Update');
						break;
					case "1004": // server Downtime / App block
						NAVIGATION.setPage(-1);
						DIALOG_alert(simpleResp.RESPONSE.RESPDESC, blockApp, CONFIG_notifyHead["alert"], 'Ok');
						break;
					default: // Unknown response code
						NAVIGATION.setPage(-1);
						DIALOG_alert(AUTHENTICATE.MSG_AUTH_FAIL, blockApp, CONFIG_notifyHead["alert"], 'Ok');
				}
			},
			error: function (error, statusText) {
				//alert(JSON.stringify(error) + "||" + statusText);
				NAVIGATION.setPage(-1);
				//$("#splashVideo")[0].pause();
				if (error.status == 0 && error.statusText == "error") {
					DIALOG_alert(AUTHENTICATE.MSG_AUTH_NO_INTERNET, blockApp, CONFIG_notifyHead["alert"], 'Ok');
				}
				else if (error.status == 0 && error.statusText == "timeout") {
					DIALOG_alert(AUTHENTICATE.MSG_AUTH_NO_RESP, blockApp, CONFIG_notifyHead["alert"], 'Ok');
				}
				else {
					DIALOG_alert(AUTHENTICATE.MSG_AUTH_FAIL, blockApp, CONFIG_notifyHead["alert"], 'Ok');
				}
			}
		});
	},

	authenticateSuccessCallback: function (response) {
		if (response.APPURL == null || response.APPURL == "" || response.APPUSERNAME == null || response.APPUSERNAME == "" || response.APPPASSWD == null || response.APPPASSWD == "" || response.PASSKEY == null || response.PASSKEY == "" || response.APIURL == null || response.APIURL == "") {
			DIALOG_alert(AUTHENTICATE.MSG_AUTH_FAIL, blockApp, CONFIG_notifyHead["alert"], 'Ok');
		}
		else {
			var scriptUrl = response.APPURL;			// loading script from server
			console.log(scriptUrl);
			STORE.appUsername = response.APPUSERNAME;
			STORE.appPassword = response.APPPASSWD;
			STORE.passKey = response.PASSKEY;
			STORE.apiCallUrl = response.APIURL;
			console.log(response.APIURL);
			STORE.senderId = response.SENDERID;
			STORE.faqLink = response.FAQ;
			STORE.termConditionLink = response['T&C'];
			STORE.shareLink = response.SHARELINK;
			STORE.adImage = response.ADIMAGE;
			STORE.infoLink = response.INFOLINK;
			STORE.contactDetails = response.CONTACTDET;
			STORE.regLinks = response.REG_LINK;
			STORE.updateMsg = response.RESPONSE.RESPDESC;

			if (device.isVirtual == true)	// to block virtual devices(to be moved to POSTDATA.js)
			{
				DIALOG_alert("App is blocked. Cannot proceed further", blockApp, CONFIG_notifyHead["alert"], 'Ok');
			}
			else {

				$.ajax({
					type: "POST",
					url: scriptUrl,
					crossDomain: true,
					timeout: 15000,
					success: function (response) {
						var ScriptObj = document.createElement("script");
						ScriptObj.text = response;
						document.head.appendChild(ScriptObj);
					},
					error: function (error, statusText) {
						DIALOG_alert(AUTHENTICATE.MSG_AUTH_FAIL, blockApp, CONFIG_notifyHead["alert"], 'Ok');
					}
				});
			}
		}
	},

	qweS: function (data) {
		var code = atob(data);
		var final = "";
		for (i = 0; i < code.length; i++) {
			final += String.fromCharCode(code.charCodeAt(i) - ((i + 1) % 100))
		}
		return final;
	}
}
