#!/usr/bin/ruby

require 'json'

EXPECTED_ARG_COUNT = 6
OUTPUT_FILE = "output.skeleton"

def usage
  puts "Usage:"
  puts "  ./pack.rb <front-mesh.atlas> <back-mesh.atlas> <front-mesh.json> <back-mesh.json> <slot-positions.json> <front-ghost.vec>"
  puts
  puts "  This script takes the .atlas, .json and .vec files that define Highrise skeletons"
  puts "  and combines them into a single json representation saved as #{OUTPUT_FILE}"
  puts "  The used format is json with each of the combined files stored under a separate key"
  puts "  The keys are as follows:"
  puts "    front-atlas"
  puts "    back-atlas"
  puts "    front-mesh"
  puts "    back-mesh"
  puts "    slot-positions"
  puts "    front-ghost"
  puts
end

def combine(config)
  front_atlas = File.open(config[:front_atlas_path]).read
  back_atlas = File.open(config[:back_atlas_path]).read
  front_mesh = File.open(config[:front_mesh_path]).read
  back_mesh = File.open(config[:back_mesh_path]).read
  slot_positions = File.open(config[:slot_positions_path]).read
  front_ghost = File.open(config[:front_ghost_path]).read
  
  combined = {
    "front-atlas": front_atlas,
    "back-atlas": back_atlas,
    "front-mesh": front_mesh,
    "back-mesh": back_mesh,
    "slot-positions": slot_positions,
    "front-ghost": front_ghost,
  }
  
  combined_encoded = JSON.generate(combined, quirks_mode: true)
  
  File.open(config[:output], "w") do |file| 
    file.write(combined_encoded)
  end
end

def main(args)
  if args.length < EXPECTED_ARG_COUNT
    puts "Not enough arguments"
    usage
    return
  elsif args.length > EXPECTED_ARG_COUNT
    puts "Too many arguments"
    usage
    return
  end
  
  parsed = {front_atlas_path: args[0], back_atlas_path: args[1], front_mesh_path: args[2], back_mesh_path: args[3], slot_positions_path: args[4], front_ghost_path: args[5], output: OUTPUT_FILE}
  parsed.each do |key, value|
    puts "#{key}: #{value}"
  end
    
  combine parsed
end

main ARGV