(function (win) {
  win.JWeb = win.JWeb || {
    Plugins: {},
  };
  var jWeb = win.JWeb;
  jWeb.Plugins = jWeb.Plugins || {};
  jWeb.Plugins.EventService = jWeb.Plugins.EventService || {
    createSubscriber: () => {},
    getSubscriber: () => {},
    createPublisher: () => {},
    getPublisher: () => {},
  };

  let publisherCookieKey = "publishers";
  let subscriberCookieKey = "subscribers";

  let plugin = jWeb.Plugins.EventService;

  plugin.createSubscriber = async function (subscriberOptions) {
    console.log("JarvisEventServicePlugin::event_service::createSubscriber");
    if (subscriberOptions) {
        return await plugin.getSubscriber(
            subscriberOptions.subscriberId,
            subscriberOptions.isPersistent,
        );
    } else {
        return await plugin.getSubscriber();
    }
  };

  plugin.getSubscriber = async function (subscriberId, isPersistent) {
    console.log(
      "JarvisEventServicePlugin::event_service::getSubscriber: %o",
      subscriberId,
      isPersistent
    );

    var result;

    if (subscriberId) {
      let existingRegistrationId = getEntityFromCookie(
        subscriberId,
        subscriberCookieKey,
      );

      if (existingRegistrationId) {
        console.log(
          "JarvisEventServicePlugin::event_service::getSubscriber: Found in cookie: %o",
          { registrationId: existingRegistrationId },
        );
        result = await plugin.getRegisteredSubscriber({
          registrationId: existingRegistrationId,
        });

        if (!result.registrationId) {
          console.warn(
            "JarvisEventServicePlugin::event_service::getSubscriber: Subscriber with given Registration ID no longer available.",
            { registrationId: existingRegistrationId },
          );

          result = await plugin.registerSubscriber({ subscriberId, isPersistent });
        }
      } else {
        console.log(
          "JarvisEventServicePlugin::event_service::getSubscriber: Not found in cookie",
        );
        result = await plugin.registerSubscriber({ subscriberId, isPersistent });
      }
    } else {
      result = await plugin.registerSubscriber({ isPersistent });
    }

    const { registrationId, subscriberId: newSubscriberId } = result;

    if (!registrationId) return sendError(result);

    console.log(
      "JarvisEventServicePlugin::event_service::getSubscriber: Saving to cookie: %o",
      { newSubscriberId, registrationId },
    );

    saveEntity(newSubscriberId, registrationId, subscriberCookieKey);

    let subscriber = {
      subscribe: async function ({ eventName, publisherId }, callback) {
        let sRes = await plugin.createSubscription({
          registrationId,
          eventName,
          publisherId,
        });
        const { subscriptionId, isActive } = sRes;

        if (!subscriptionId) return sendError(sRes);

        console.log(
          "JarvisEventServicePlugin::event_service::createSubscriber::subscribe: %o",
          { eventName, publisherId, subscriptionId },
        );
        plugin.addListener(subscriptionId, (data) => {
          console.log(
            "JarvisEventServicePlugin::event_service::createSubscriber::addListener:callback: %o",
            data,
          );
          callback({
            subscriber,
            publisherId: data.publisherId,
            eventName: data.eventName,
            eventData: data.eventData,
          });
        });

        const subscription = {
          isActive,
          unsubscribe: async function () {
            await plugin.unsubscribe({ subscriptionId });
          },
        };

        if (eventName) subscription.eventName = eventName;
        if (publisherId) subscription.publisherId = publisherId;

        return subscription;
      },
      unsubscribe: async function (eventName = null, publisherId = null) {
        console.log(
          "JarvisEventServicePlugin::event_service::createSubscriber:unsubscribe: %o",
          { registrationId, eventName, publisherId },
        );
        const uRes = await plugin.unsubscribe({
          registrationId,
          eventName,
          publisherId,
        });
        if (!isEmpty(uRes)) return sendError(uRes);
      },
      pauseEvents: async function () {
        console.log(
         "JarvisEventServicePlugin::event_service::pauseEvents: %o",
          { registrationId},
        );
        const uRes = await plugin.pauseEvents({ registrationId});
        if (!isEmpty(uRes)) return sendError(uRes);
      },
      resumeEvents: async function () {
        console.log(
         "JarvisEventServicePlugin::event_service::resumeEvents: %o",
         { registrationId },
        );
        const uRes = await plugin.resumeEvents({ registrationId});
        if (!isEmpty(uRes)) return sendError(uRes);
      },
      subscriberId: newSubscriberId
    };
    return subscriber;
  };

  plugin.createPublisher = async function (publisherId) {
    console.log(
      "JarvisEventServicePlugin::event_service::createPublisher: %o",
      publisherId,
    );
    let publisher = await plugin.getPublisher(publisherId);

    return publisher;
  };

  plugin.getPublisher = async function (publisherId) {
    console.log(
      "JarvisEventServicePlugin::event_service::getPublisher: %o",
      publisherId,
    );
    let existingRegistrationId = getEntityFromCookie(
      publisherId,
      publisherCookieKey,
    );

    var result;
    if (existingRegistrationId) {
      console.log(
        "JarvisEventServicePlugin::event_service::getPublisher: Found in cookie: %o",
        { registrationId: existingRegistrationId },
      );
      result = await plugin.getRegisteredPublisher({
        registrationId: existingRegistrationId,
      });

      if (!result.registrationId) {
        console.warn(
          "JarvisEventServicePlugin::event_service::getPublisher: Registration ID no longer valid",
          { registrationId: existingRegistrationId },
        );

        result = await plugin.registerPublisher({ publisherId });
      }
    } else {
      console.log(
        "JarvisEventServicePlugin::event_service::getPublisher: Not found in cookie",
      );
      result = await plugin.registerPublisher({ publisherId });
    }

    const { registrationId } = result;

    if (!registrationId) return sendError(result);

    console.log(
      "JarvisEventServicePlugin::event_service::getPublisher: Saving to cookie: %o",
      { publisherId, registrationId },
    );

    saveEntity(publisherId, registrationId, publisherCookieKey);

    return {
      handle: registrationId,
      publish: async function (eventName, eventData) {
        const pRes = await plugin.publish({
          registrationId,
          eventName,
          eventData,
        });
        if (!isEmpty(pRes)) return sendError(pRes);
      },
      destroy: async function () {
        const dRes = await plugin.unregisterPublisher({ registrationId });
        if (!isEmpty(dRes)) return sendError(dRes);
      },
    };
  };

  function saveEntity(entityId, registrationId, cookieKey) {
    var jsonEntity = getEntityJSON(cookieKey);
    jsonEntity[entityId] = registrationId;
    setCookie(cookieKey, JSON.stringify(jsonEntity));
  }

  function getEntityJSON(cookieKey) {
    var cookieValue = getCookie(cookieKey) || "{}";
    return JSON.parse(cookieValue);
  }

  function getEntityFromCookie(entityId, cookieKey) {
    let jsonEntity = getEntityJSON(cookieKey);
    return jsonEntity[entityId];
  }

  function setCookie(key, value) {
    document.cookie = key + "=" + value;
  }

  function getCookie(key) {
    let name = key + "=";
    let ca = document.cookie.split(";");
    for (let i = 0; i < ca.length; i++) {
      let c = ca[i];
      while (c.charAt(0) == " ") {
        c = c.substring(1);
      }
      if (c.indexOf(name) == 0) {
        return c.substring(name.length, c.length);
      }
    }
    return "";
  }

  function sendError(result) {
    result && console.error(result);
    return result;
  }

  function isEmpty(obj) {
    return Object.keys(obj).length === 0 && obj.constructor === Object;
  }
})(window);