#version 300 es

// We need to conditionally check for the availablity of GL_OES_EGL_image_external_essl3. Some devices require it,
// some devices have merely deprecated GL_OES_EGL_image_external, and some devices don't know GL_OES_EGL_image_external_essl3 exists.

#if __VERSION__ >= 300 && defined(GL_OES_EGL_image_external_essl3)
#extension GL_OES_EGL_image_external_essl3 : require
#else
#extension GL_OES_EGL_image_external : require
#endif
precision mediump float;
precision highp int;

layout(std140) uniform FragBlock
{
    vec4 fillColor;
    float opacity;
} fragUniforms;

layout(std140) uniform YCbCrMatrixConstants
{
    float kB;
    float kR;
    float kG;
    float kCb;
    float kCr;
    float kCbG;
    float kCrG;
} yCbCrMatrixConstants;

layout(std140) uniform PlaneBlock
{
    int plane;
} plane;

uniform highp samplerExternalOES texture0;

in vec2 textureCoord;
layout(location = 0) out vec2 FragColor;

void main()
{
    float t = ((step(0.0, textureCoord.x) * step(0.0, textureCoord.y)) * (1.0 - step(1.0, textureCoord.x))) * (1.0 - step(1.0, textureCoord.y));
    float YColor = ((fragUniforms.fillColor.x * yCbCrMatrixConstants.kR) + (fragUniforms.fillColor.y * yCbCrMatrixConstants.kG)) + (fragUniforms.fillColor.z * yCbCrMatrixConstants.kB);
    vec2 fillColor;
    vec2 planeColors;
    if (plane.plane == 0)
    {
        fillColor = vec2(YColor, 0.0);
        planeColors = vec2(texture(texture0, textureCoord).x, 0.0);
    }
    else
    {
        float CbColor = (fragUniforms.fillColor.z - YColor) / yCbCrMatrixConstants.kCb;
        float CrColor = (fragUniforms.fillColor.x - YColor) / yCbCrMatrixConstants.kCr;
        fillColor = vec2(CbColor, CrColor) + vec2(0.5);
        planeColors = texture(texture0, textureCoord).xy;
    }
    FragColor = mix(fillColor, planeColors, vec2(t));
}

