#version 300 es

// We need to conditionally check for the availablity of GL_OES_EGL_image_external_essl3. Some devices require it,
// some devices have merely deprecated GL_OES_EGL_image_external, and some devices don't know GL_OES_EGL_image_external_essl3 exists.

#if __VERSION__ >= 300 && defined(GL_OES_EGL_image_external_essl3)
#extension GL_OES_EGL_image_external_essl3 : require
#else
#extension GL_OES_EGL_image_external : require
#endif
precision mediump float;
precision highp int;

layout(std140) uniform FragBlock
{
    vec4 fillColor;
    float opacity;
} fragUniforms;

layout(std140) uniform YCbCrMatrixConstants
{
    float kB;
    float kR;
    float kG;
    float kCb;
    float kCr;
    float kCbG;
    float kCrG;
} yCbCrMatrixConstants;

uniform highp samplerExternalOES texture0;
uniform highp sampler2D texture1;

in vec2 textureCoord;
layout(location = 0) out vec4 FragColor;

void main()
{
    float t = ((step(0.0, textureCoord.x) * step(0.0, textureCoord.y)) * (1.0 - step(1.0, textureCoord.x))) * (1.0 - step(1.0, textureCoord.y));
    float Y = texture(texture0, textureCoord).x;
    vec2 CbCr = texture(texture1, textureCoord).xy - vec2(0.5);
    float r = clamp(Y + (yCbCrMatrixConstants.kCr * CbCr.y), 0.0, 1.0);
    float g = clamp((Y - (yCbCrMatrixConstants.kCrG * CbCr.y)) - (yCbCrMatrixConstants.kCbG * CbCr.x), 0.0, 1.0);
    float b = clamp(Y + (yCbCrMatrixConstants.kCb * CbCr.x), 0.0, 1.0);
    FragColor = mix(fragUniforms.fillColor, vec4(r, g, b, 1.0), vec4(t)) * vec4(1.0, 1.0, 1.0, fragUniforms.opacity);
}

