#version 300 es

// We need to conditionally check for the availablity of GL_OES_EGL_image_external_essl3. Some devices require it,
// some devices have merely deprecated GL_OES_EGL_image_external, and some devices don't know GL_OES_EGL_image_external_essl3 exists.

#if __VERSION__ >= 300 && defined(GL_OES_EGL_image_external_essl3)
#extension GL_OES_EGL_image_external_essl3 : require
#else
#extension GL_OES_EGL_image_external : require
#endif
precision mediump float;
precision highp int;

layout(std140) uniform FragBlock
{
    vec4 fillColor;
    float opacity;
} fragUniforms;

uniform highp samplerExternalOES texture0;

in vec2 textureCoord;
layout(location = 0) out vec4 FragColor;

void main()
{
    float t = ((step(0.0, textureCoord.x) * step(0.0, textureCoord.y)) * (1.0 - step(1.0, textureCoord.x))) * (1.0 - step(1.0, textureCoord.y));
    FragColor = mix(fragUniforms.fillColor, texture(texture0, textureCoord), vec4(t)) * vec4(1.0, 1.0, 1.0, fragUniforms.opacity);
}

