#version 100

// We need to conditionally check for the availablity of GL_OES_EGL_image_external_essl3. Some devices require it,
// some devices have merely deprecated GL_OES_EGL_image_external, and some devices don't know GL_OES_EGL_image_external_essl3 exists.

#if __VERSION__ >= 300 && defined(GL_OES_EGL_image_external_essl3)
#extension GL_OES_EGL_image_external_essl3 : require
#else
#extension GL_OES_EGL_image_external : require
#endif
precision mediump float;
precision highp int;

struct FragBlock
{
    vec4 fillColor;
    float opacity;
};

uniform FragBlock fragUniforms;

struct YCbCrMatrixConstants
{
    float kB;
    float kR;
    float kG;
    float kCb;
    float kCr;
    float kCbG;
    float kCrG;
};

uniform YCbCrMatrixConstants yCbCrMatrixConstants;

struct PlaneBlock
{
    int plane;
};

uniform PlaneBlock plane;

uniform highp samplerExternalOES texture0;

varying vec2 textureCoord;

void main()
{
    float t = ((step(0.0, textureCoord.x) * step(0.0, textureCoord.y)) * (1.0 - step(1.0, textureCoord.x))) * (1.0 - step(1.0, textureCoord.y));
    vec4 rgba = texture2D(texture0, textureCoord);
    float fragYColor = ((rgba.x * yCbCrMatrixConstants.kR) + (rgba.y * yCbCrMatrixConstants.kG)) + (rgba.z * yCbCrMatrixConstants.kB);
    float fillYColor = ((fragUniforms.fillColor.x * yCbCrMatrixConstants.kR) + (fragUniforms.fillColor.y * yCbCrMatrixConstants.kG)) + (fragUniforms.fillColor.z * yCbCrMatrixConstants.kB);
    vec2 fragColor;
    vec2 fillColor;
    if (plane.plane == 0)
    {
        fragColor = vec2(fragYColor, 0.0);
        fillColor = vec2(fillYColor, 0.0);
    }
    else
    {
        float CbColor = (rgba.z - fragYColor) / yCbCrMatrixConstants.kCb;
        float CrColor = (rgba.x - fragYColor) / yCbCrMatrixConstants.kCr;
        fragColor = vec2(CbColor, CrColor) + vec2(0.5);
        float FillCbColor = (fragUniforms.fillColor.z - fillYColor) / yCbCrMatrixConstants.kCb;
        float FillCrColor = (fragUniforms.fillColor.x - fillYColor) / yCbCrMatrixConstants.kCr;
        fillColor = vec2(FillCbColor, FillCrColor) + vec2(0.5);
    }
    gl_FragData[0] = mix(fillColor, fragColor, vec2(t));
}

