#version 100

// We need to conditionally check for the availablity of GL_OES_EGL_image_external_essl3. Some devices require it,
// some devices have merely deprecated GL_OES_EGL_image_external, and some devices don't know GL_OES_EGL_image_external_essl3 exists.

#if __VERSION__ >= 300 && defined(GL_OES_EGL_image_external_essl3)
#extension GL_OES_EGL_image_external_essl3 : require
#else
#extension GL_OES_EGL_image_external : require
#endif

struct VertexBlock
{
    mat4 transformMatrix;
    mat4 textureMatrix;
};

uniform VertexBlock vertUniforms;

attribute vec2 vertex;
varying vec2 textureCoord;

void main()
{
    gl_Position = vertUniforms.transformMatrix * vec4(vertex, 0.0, 1.0);
    textureCoord = ((vertUniforms.textureMatrix * vec4(vertex, 0.0, 1.0)).xy * 0.5) + vec2(0.5);
}

