/**
 * Country names object using 2-letter country codes to reference country name
 * Derived from the Intl.DisplayNames implementation
 * @source https://stackoverflow.com/a/70517921/1948947
 */
const COUNTRY_CODES_TO_NAMES = {
    AC: 'Ascension Island',
    AD: 'Andorra',
    AE: 'United Arab Emirates',
    AF: 'Afghanistan',
    AG: 'Antigua & Barbuda',
    AI: 'Anguilla',
    AL: 'Albania',
    AM: 'Armenia',
    AN: 'Curaçao',
    AO: 'Angola',
    AQ: 'Antarctica',
    AR: 'Argentina',
    AS: 'American Samoa',
    AT: 'Austria',
    AU: 'Australia',
    AW: 'Aruba',
    AX: 'Åland Islands',
    AZ: 'Azerbaijan',
    BA: 'Bosnia & Herzegovina',
    BB: 'Barbados',
    BD: 'Bangladesh',
    BE: 'Belgium',
    BF: 'Burkina Faso',
    BG: 'Bulgaria',
    BH: 'Bahrain',
    BI: 'Burundi',
    BJ: 'Benin',
    BL: 'St. Barthélemy',
    BM: 'Bermuda',
    BN: 'Brunei',
    BO: 'Bolivia',
    BQ: 'Caribbean Netherlands',
    BR: 'Brazil',
    BS: 'Bahamas',
    BT: 'Bhutan',
    BU: 'Myanmar (Burma)',
    BV: 'Bouvet Island',
    BW: 'Botswana',
    BY: 'Belarus',
    BZ: 'Belize',
    CA: 'Canada',
    CC: 'Cocos (Keeling) Islands',
    CD: 'Congo - Kinshasa',
    CF: 'Central African Republic',
    CG: 'Congo - Brazzaville',
    CH: 'Switzerland',
    CI: 'Côte d’Ivoire',
    CK: 'Cook Islands',
    CL: 'Chile',
    CM: 'Cameroon',
    CN: 'China mainland',
    CO: 'Colombia',
    CP: 'Clipperton Island',
    CR: 'Costa Rica',
    CS: 'Serbia',
    CU: 'Cuba',
    CV: 'Cape Verde',
    CW: 'Curaçao',
    CX: 'Christmas Island',
    CY: 'Cyprus',
    CZ: 'Czechia',
    DD: 'Germany',
    DE: 'Germany',
    DG: 'Diego Garcia',
    DJ: 'Djibouti',
    DK: 'Denmark',
    DM: 'Dominica',
    DO: 'Dominican Republic',
    DY: 'Benin',
    DZ: 'Algeria',
    EA: 'Ceuta & Melilla',
    EC: 'Ecuador',
    EE: 'Estonia',
    EG: 'Egypt',
    EH: 'Western Sahara',
    ER: 'Eritrea',
    ES: 'Spain',
    ET: 'Ethiopia',
    EU: 'European Union',
    EZ: 'Eurozone',
    FI: 'Finland',
    FJ: 'Fiji',
    FK: 'Falkland Islands',
    FM: 'Micronesia',
    FO: 'Faroe Islands',
    FR: 'France',
    FX: 'France',
    GA: 'Gabon',
    GB: 'United Kingdom',
    GD: 'Grenada',
    GE: 'Georgia',
    GF: 'French Guiana',
    GG: 'Guernsey',
    GH: 'Ghana',
    GI: 'Gibraltar',
    GL: 'Greenland',
    GM: 'Gambia',
    GN: 'Guinea',
    GP: 'Guadeloupe',
    GQ: 'Equatorial Guinea',
    GR: 'Greece',
    GS: 'So. Georgia & So. Sandwich Isl.',
    GT: 'Guatemala',
    GU: 'Guam',
    GW: 'Guinea-Bissau',
    GY: 'Guyana',
    HK: 'Hong Kong',
    HM: 'Heard & McDonald Islands',
    HN: 'Honduras',
    HR: 'Croatia',
    HT: 'Haiti',
    HU: 'Hungary',
    HV: 'Burkina Faso',
    IC: 'Canary Islands',
    ID: 'Indonesia',
    IE: 'Ireland',
    IL: 'Israel',
    IM: 'Isle of Man',
    IN: 'India',
    IO: 'Chagos Archipelago',
    IQ: 'Iraq',
    IR: 'Iran',
    IS: 'Iceland',
    IT: 'Italy',
    JE: 'Jersey',
    JM: 'Jamaica',
    JO: 'Jordan',
    JP: 'Japan',
    KE: 'Kenya',
    KG: 'Kyrgyzstan',
    KH: 'Cambodia',
    KI: 'Kiribati',
    KM: 'Comoros',
    KN: 'St. Kitts & Nevis',
    KP: 'North Korea',
    KR: 'South Korea',
    KW: 'Kuwait',
    KY: 'Cayman Islands',
    KZ: 'Kazakhstan',
    LA: 'Laos',
    LB: 'Lebanon',
    LC: 'St. Lucia',
    LI: 'Liechtenstein',
    LK: 'Sri Lanka',
    LR: 'Liberia',
    LS: 'Lesotho',
    LT: 'Lithuania',
    LU: 'Luxembourg',
    LV: 'Latvia',
    LY: 'Libya',
    MA: 'Morocco',
    MC: 'Monaco',
    MD: 'Moldova',
    ME: 'Montenegro',
    MF: 'St. Martin',
    MG: 'Madagascar',
    MH: 'Marshall Islands',
    MK: 'North Macedonia',
    ML: 'Mali',
    MM: 'Myanmar (Burma)',
    MN: 'Mongolia',
    MO: 'Macao',
    MP: 'Northern Mariana Islands',
    MQ: 'Martinique',
    MR: 'Mauritania',
    MS: 'Montserrat',
    MT: 'Malta',
    MU: 'Mauritius',
    MV: 'Maldives',
    MW: 'Malawi',
    MX: 'Mexico',
    MY: 'Malaysia',
    MZ: 'Mozambique',
    NA: 'Namibia',
    NC: 'New Caledonia',
    NE: 'Niger',
    NF: 'Norfolk Island',
    NG: 'Nigeria',
    NH: 'Vanuatu',
    NI: 'Nicaragua',
    NL: 'Netherlands',
    NO: 'Norway',
    NP: 'Nepal',
    NR: 'Nauru',
    NU: 'Niue',
    NZ: 'New Zealand',
    OM: 'Oman',
    PA: 'Panama',
    PE: 'Peru',
    PF: 'French Polynesia',
    PG: 'Papua New Guinea',
    PH: 'Philippines',
    PK: 'Pakistan',
    PL: 'Poland',
    PM: 'St. Pierre & Miquelon',
    PN: 'Pitcairn Islands',
    PR: 'Puerto Rico',
    PS: 'Palestinian Territories',
    PT: 'Portugal',
    PW: 'Palau',
    PY: 'Paraguay',
    QA: 'Qatar',
    QO: 'Outlying Oceania',
    RE: 'Réunion',
    RH: 'Zimbabwe',
    RO: 'Romania',
    RS: 'Serbia',
    RU: 'Russia',
    RW: 'Rwanda',
    SA: 'Saudi Arabia',
    SB: 'Solomon Islands',
    SC: 'Seychelles',
    SD: 'Sudan',
    SE: 'Sweden',
    SG: 'Singapore',
    SH: 'St. Helena',
    SI: 'Slovenia',
    SJ: 'Svalbard & Jan Mayen',
    SK: 'Slovakia',
    SL: 'Sierra Leone',
    SM: 'San Marino',
    SN: 'Senegal',
    SO: 'Somalia',
    SR: 'Suriname',
    SS: 'South Sudan',
    ST: 'São Tomé & Príncipe',
    SU: 'Russia',
    SV: 'El Salvador',
    SX: 'Sint Maarten',
    SY: 'Syria',
    SZ: 'Eswatini',
    TA: 'Tristan da Cunha',
    TC: 'Turks & Caicos Islands',
    TD: 'Chad',
    TF: 'French Southern Territories',
    TG: 'Togo',
    TH: 'Thailand',
    TJ: 'Tajikistan',
    TK: 'Tokelau',
    TL: 'Timor-Leste',
    TM: 'Turkmenistan',
    TN: 'Tunisia',
    TO: 'Tonga',
    TP: 'Timor-Leste',
    TR: 'Turkey',
    TT: 'Trinidad & Tobago',
    TV: 'Tuvalu',
    TW: 'Taiwan',
    TZ: 'Tanzania',
    UA: 'Ukraine',
    UG: 'Uganda',
    UK: 'United Kingdom',
    UM: 'U.S. Outlying Islands',
    UN: 'United Nations',
    US: 'United States',
    UY: 'Uruguay',
    UZ: 'Uzbekistan',
    VA: 'Vatican City',
    VC: 'St. Vincent & Grenadines',
    VD: 'Vietnam',
    VE: 'Venezuela',
    VG: 'British Virgin Islands',
    VI: 'U.S. Virgin Islands',
    VN: 'Vietnam',
    VU: 'Vanuatu',
    WF: 'Wallis & Futuna',
    WS: 'Samoa',
    XA: 'Pseudo-Accents',
    XB: 'Pseudo-Bidi',
    XK: 'Kosovo',
    YD: 'Yemen',
    YE: 'Yemen',
    YT: 'Mayotte',
    YU: 'Serbia',
    ZA: 'South Africa',
    ZM: 'Zambia',
    ZR: 'Congo - Kinshasa',
    ZW: 'Zimbabwe',
    ZZ: 'Unknown Region'
}

/**
 * Country names object using country name to reference 2-letter country codes
 * Derived from the solution above with
 * Object.fromEntries(Object.entries(COUNTRY_CODES_TO_NAMES).map(entry => [entry[1], entry[0]]))
 */
const COUNTRY_NAMES_TO_CODES = {
    'Ascension Island': 'AC',
    Andorra: 'AD',
    'United Arab Emirates': 'AE',
    Afghanistan: 'AF',
    'Antigua & Barbuda': 'AG',
    Anguilla: 'AI',
    Albania: 'AL',
    Armenia: 'AM',
    'Curaçao': 'CW',
    Angola: 'AO',
    Antarctica: 'AQ',
    Argentina: 'AR',
    'American Samoa': 'AS',
    Austria: 'AT',
    Australia: 'AU',
    Aruba: 'AW',
    'Åland Islands': 'AX',
    Azerbaijan: 'AZ',
    'Bosnia & Herzegovina': 'BA',
    Barbados: 'BB',
    Bangladesh: 'BD',
    Belgium: 'BE',
    'Burkina Faso': 'HV',
    Bulgaria: 'BG',
    Bahrain: 'BH',
    Burundi: 'BI',
    Benin: 'DY',
    'St. Barthélemy': 'BL',
    Bermuda: 'BM',
    Brunei: 'BN',
    Bolivia: 'BO',
    'Caribbean Netherlands': 'BQ',
    Brazil: 'BR',
    Bahamas: 'BS',
    Bhutan: 'BT',
    'Myanmar (Burma)': 'MM',
    'Bouvet Island': 'BV',
    Botswana: 'BW',
    Belarus: 'BY',
    Belize: 'BZ',
    Canada: 'CA',
    'Cocos (Keeling) Islands': 'CC',
    'Congo - Kinshasa': 'ZR',
    'Central African Republic': 'CF',
    'Congo - Brazzaville': 'CG',
    Switzerland: 'CH',
    'Côte d’Ivoire': 'CI',
    'Cook Islands': 'CK',
    Chile: 'CL',
    Cameroon: 'CM',
    'China mainland': 'CN',
    Colombia: 'CO',
    'Clipperton Island': 'CP',
    'Costa Rica': 'CR',
    Serbia: 'YU',
    Cuba: 'CU',
    'Cape Verde': 'CV',
    'Christmas Island': 'CX',
    Cyprus: 'CY',
    Czechia: 'CZ',
    Germany: 'DE',
    'Diego Garcia': 'DG',
    Djibouti: 'DJ',
    Denmark: 'DK',
    Dominica: 'DM',
    'Dominican Republic': 'DO',
    Algeria: 'DZ',
    'Ceuta & Melilla': 'EA',
    Ecuador: 'EC',
    Estonia: 'EE',
    Egypt: 'EG',
    'Western Sahara': 'EH',
    Eritrea: 'ER',
    Spain: 'ES',
    Ethiopia: 'ET',
    'European Union': 'EU',
    Eurozone: 'EZ',
    Finland: 'FI',
    Fiji: 'FJ',
    'Falkland Islands': 'FK',
    Micronesia: 'FM',
    'Faroe Islands': 'FO',
    France: 'FX',
    Gabon: 'GA',
    'United Kingdom': 'UK',
    Grenada: 'GD',
    Georgia: 'GE',
    'French Guiana': 'GF',
    Guernsey: 'GG',
    Ghana: 'GH',
    Gibraltar: 'GI',
    Greenland: 'GL',
    Gambia: 'GM',
    Guinea: 'GN',
    Guadeloupe: 'GP',
    'Equatorial Guinea': 'GQ',
    Greece: 'GR',
    'So. Georgia & So. Sandwich Isl.': 'GS',
    Guatemala: 'GT',
    Guam: 'GU',
    'Guinea-Bissau': 'GW',
    Guyana: 'GY',
    'Hong Kong': 'HK',
    'Heard & McDonald Islands': 'HM',
    Honduras: 'HN',
    Croatia: 'HR',
    Haiti: 'HT',
    Hungary: 'HU',
    'Canary Islands': 'IC',
    Indonesia: 'ID',
    Ireland: 'IE',
    Israel: 'IL',
    'Isle of Man': 'IM',
    India: 'IN',
    'Chagos Archipelago': 'IO',
    Iraq: 'IQ',
    Iran: 'IR',
    Iceland: 'IS',
    Italy: 'IT',
    Jersey: 'JE',
    Jamaica: 'JM',
    Jordan: 'JO',
    Japan: 'JP',
    Kenya: 'KE',
    Kyrgyzstan: 'KG',
    Cambodia: 'KH',
    Kiribati: 'KI',
    Comoros: 'KM',
    'St. Kitts & Nevis': 'KN',
    'North Korea': 'KP',
    'South Korea': 'KR',
    Kuwait: 'KW',
    'Cayman Islands': 'KY',
    Kazakhstan: 'KZ',
    Laos: 'LA',
    Lebanon: 'LB',
    'St. Lucia': 'LC',
    Liechtenstein: 'LI',
    'Sri Lanka': 'LK',
    Liberia: 'LR',
    Lesotho: 'LS',
    Lithuania: 'LT',
    Luxembourg: 'LU',
    Latvia: 'LV',
    Libya: 'LY',
    Morocco: 'MA',
    Monaco: 'MC',
    Moldova: 'MD',
    Montenegro: 'ME',
    'St. Martin': 'MF',
    Madagascar: 'MG',
    'Marshall Islands': 'MH',
    'North Macedonia': 'MK',
    Mali: 'ML',
    Mongolia: 'MN',
    Macao: 'MO',
    'Northern Mariana Islands': 'MP',
    Martinique: 'MQ',
    Mauritania: 'MR',
    Montserrat: 'MS',
    Malta: 'MT',
    Mauritius: 'MU',
    Maldives: 'MV',
    Malawi: 'MW',
    Mexico: 'MX',
    Malaysia: 'MY',
    Mozambique: 'MZ',
    Namibia: 'NA',
    'New Caledonia': 'NC',
    Niger: 'NE',
    'Norfolk Island': 'NF',
    Nigeria: 'NG',
    Vanuatu: 'VU',
    Nicaragua: 'NI',
    Netherlands: 'NL',
    Norway: 'NO',
    Nepal: 'NP',
    Nauru: 'NR',
    Niue: 'NU',
    'New Zealand': 'NZ',
    Oman: 'OM',
    Panama: 'PA',
    Peru: 'PE',
    'French Polynesia': 'PF',
    'Papua New Guinea': 'PG',
    Philippines: 'PH',
    Pakistan: 'PK',
    Poland: 'PL',
    'St. Pierre & Miquelon': 'PM',
    'Pitcairn Islands': 'PN',
    'Puerto Rico': 'PR',
    'Palestinian Territories': 'PS',
    Portugal: 'PT',
    Palau: 'PW',
    Paraguay: 'PY',
    Qatar: 'QA',
    'Outlying Oceania': 'QO',
    'Réunion': 'RE',
    Zimbabwe: 'ZW',
    Romania: 'RO',
    Russia: 'SU',
    Rwanda: 'RW',
    'Saudi Arabia': 'SA',
    'Solomon Islands': 'SB',
    Seychelles: 'SC',
    Sudan: 'SD',
    Sweden: 'SE',
    Singapore: 'SG',
    'St. Helena': 'SH',
    Slovenia: 'SI',
    'Svalbard & Jan Mayen': 'SJ',
    Slovakia: 'SK',
    'Sierra Leone': 'SL',
    'San Marino': 'SM',
    Senegal: 'SN',
    Somalia: 'SO',
    Suriname: 'SR',
    'South Sudan': 'SS',
    'São Tomé & Príncipe': 'ST',
    'El Salvador': 'SV',
    'Sint Maarten': 'SX',
    Syria: 'SY',
    Eswatini: 'SZ',
    'Tristan da Cunha': 'TA',
    'Turks & Caicos Islands': 'TC',
    Chad: 'TD',
    'French Southern Territories': 'TF',
    Togo: 'TG',
    Thailand: 'TH',
    Tajikistan: 'TJ',
    Tokelau: 'TK',
    'Timor-Leste': 'TP',
    Turkmenistan: 'TM',
    Tunisia: 'TN',
    Tonga: 'TO',
    Turkey: 'TR',
    'Trinidad & Tobago': 'TT',
    Tuvalu: 'TV',
    Taiwan: 'TW',
    Tanzania: 'TZ',
    Ukraine: 'UA',
    Uganda: 'UG',
    'U.S. Outlying Islands': 'UM',
    'United Nations': 'UN',
    'United States': 'US',
    Uruguay: 'UY',
    Uzbekistan: 'UZ',
    'Vatican City': 'VA',
    'St. Vincent & Grenadines': 'VC',
    Vietnam: 'VN',
    Venezuela: 'VE',
    'British Virgin Islands': 'VG',
    'U.S. Virgin Islands': 'VI',
    'Wallis & Futuna': 'WF',
    Samoa: 'WS',
    'Pseudo-Accents': 'XA',
    'Pseudo-Bidi': 'XB',
    Kosovo: 'XK',
    Yemen: 'YE',
    Mayotte: 'YT',
    'South Africa': 'ZA',
    Zambia: 'ZM',
    'Unknown Region': 'ZZ'
}

export {
    COUNTRY_CODES_TO_NAMES,
    COUNTRY_NAMES_TO_CODES
}
