/*
 * Decompiled with CFR 0.152.
 */
package decaf;

import decaf.NegatablePlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Platform implements NegatablePlatform
{
    JMX(new NegatablePlatform[0]),
    ANNOTATION(new NegatablePlatform[0]),
    OVERRIDE_FOR_INTERFACE(new NegatablePlatform[0]),
    JDK11(new NegatablePlatform[0]),
    JDK12(JDK11),
    JDK15(JDK12, JMX, ANNOTATION),
    JDK16(JDK15, OVERRIDE_FOR_INTERFACE),
    ANDROID(JDK15, JMX.not()),
    SHARPEN(JDK15),
    ALL(new NegatablePlatform[0]);

    private final NegatablePlatform[] parents;
    private boolean[] compatibility = null;

    private Platform(NegatablePlatform ... parent) {
        this.parents = parent;
    }

    public boolean compatibleWith(Platform other) {
        return this.compatibility()[other.ordinal()];
    }

    public boolean[] compatibility() {
        if (this.compatibility != null) {
            return this.compatibility;
        }
        this.compatibility = new boolean[Platform.values().length];
        this.fillCompatibility(this.compatibility, true);
        return this.compatibility;
    }

    @Override
    public void fillCompatibility(boolean[] compatibility, boolean compatible) {
        compatibility[this.ordinal()] = compatible;
        NegatablePlatform[] negatablePlatformArray = this.parents;
        int n = this.parents.length;
        int n2 = 0;
        while (n2 < n) {
            NegatablePlatform parent = negatablePlatformArray[n2];
            parent.fillCompatibility(compatibility, compatible);
            ++n2;
        }
    }

    NegatablePlatform not() {
        return new Negate(this);
    }

    public static class Negate
    implements NegatablePlatform {
        private final Platform platform;

        Negate(Platform platform) {
            this.platform = platform;
        }

        public void fillCompatibility(boolean[] compatibility, boolean value) {
            this.platform.fillCompatibility(compatibility, false);
        }
    }
}

