/*
 * Decompiled with CFR 0.152.
 */
package androidx.swiperefreshlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.SwipeProgressBar;

public class SwipeRefreshLayout
extends ViewGroup {
    private static final String LOG_TAG = SwipeRefreshLayout.class.getSimpleName();
    private static final long RETURN_TO_ORIGINAL_POSITION_TIMEOUT = 300L;
    private static final float ACCELERATE_INTERPOLATION_FACTOR = 1.5f;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final float PROGRESS_BAR_HEIGHT = 4.0f;
    private static final float MAX_SWIPE_DISTANCE_FACTOR = 0.6f;
    private static final int REFRESH_TRIGGER_DISTANCE = 120;
    private static final int INVALID_POINTER = -1;
    private SwipeProgressBar mProgressBar;
    private View mTarget;
    private int mOriginalOffsetTop;
    private OnRefreshListener mListener;
    private int mFrom;
    private boolean mRefreshing = false;
    private int mTouchSlop;
    private float mDistanceToTriggerSync = -1.0f;
    private int mMediumAnimationDuration;
    private float mFromPercentage = 0.0f;
    private float mCurrPercentage = 0.0f;
    private int mProgressBarHeight;
    private int mCurrentTargetOffsetTop;
    private float mInitialMotionY;
    private float mLastMotionY;
    private boolean mIsBeingDragged;
    private int mActivePointerId = -1;
    private boolean mReturningToStart;
    private final DecelerateInterpolator mDecelerateInterpolator;
    private final AccelerateInterpolator mAccelerateInterpolator;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int currentTop;
            int offset;
            int targetTop = 0;
            if (SwipeRefreshLayout.this.mFrom != SwipeRefreshLayout.this.mOriginalOffsetTop) {
                targetTop = SwipeRefreshLayout.this.mFrom + (int)((float)(SwipeRefreshLayout.this.mOriginalOffsetTop - SwipeRefreshLayout.this.mFrom) * interpolatedTime);
            }
            if ((offset = targetTop - SwipeRefreshLayout.this.mTarget.getTop()) + (currentTop = SwipeRefreshLayout.this.mTarget.getTop()) < 0) {
                offset = 0 - currentTop;
            }
            SwipeRefreshLayout.this.setTargetOffsetTopAndBottom(offset);
        }
    };
    private Animation mShrinkTrigger = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            float percent = SwipeRefreshLayout.this.mFromPercentage + (0.0f - SwipeRefreshLayout.this.mFromPercentage) * interpolatedTime;
            SwipeRefreshLayout.this.mProgressBar.setTriggerPercentage(percent);
        }
    };
    private final Animation.AnimationListener mReturnToStartPositionListener = new BaseAnimationListener(){

        public void onAnimationEnd(Animation animation) {
            SwipeRefreshLayout.this.mCurrentTargetOffsetTop = 0;
        }
    };
    private final Animation.AnimationListener mShrinkAnimationListener = new BaseAnimationListener(){

        public void onAnimationEnd(Animation animation) {
            SwipeRefreshLayout.this.mCurrPercentage = 0.0f;
        }
    };
    private final Runnable mReturnToStartPosition = new Runnable(){

        public void run() {
            SwipeRefreshLayout.this.mReturningToStart = true;
            SwipeRefreshLayout.this.animateOffsetToStartPosition(SwipeRefreshLayout.this.mCurrentTargetOffsetTop + SwipeRefreshLayout.this.getPaddingTop(), SwipeRefreshLayout.this.mReturnToStartPositionListener);
        }
    };
    private final Runnable mCancel = new Runnable(){

        public void run() {
            SwipeRefreshLayout.this.mReturningToStart = true;
            if (SwipeRefreshLayout.this.mProgressBar != null) {
                SwipeRefreshLayout.this.mFromPercentage = SwipeRefreshLayout.this.mCurrPercentage;
                SwipeRefreshLayout.this.mShrinkTrigger.setDuration((long)SwipeRefreshLayout.this.mMediumAnimationDuration);
                SwipeRefreshLayout.this.mShrinkTrigger.setAnimationListener(SwipeRefreshLayout.this.mShrinkAnimationListener);
                SwipeRefreshLayout.this.mShrinkTrigger.reset();
                SwipeRefreshLayout.this.mShrinkTrigger.setInterpolator((Interpolator)SwipeRefreshLayout.this.mDecelerateInterpolator);
                SwipeRefreshLayout.this.startAnimation(SwipeRefreshLayout.this.mShrinkTrigger);
            }
            SwipeRefreshLayout.this.animateOffsetToStartPosition(SwipeRefreshLayout.this.mCurrentTargetOffsetTop + SwipeRefreshLayout.this.getPaddingTop(), SwipeRefreshLayout.this.mReturnToStartPositionListener);
        }
    };

    public SwipeRefreshLayout(Context context) {
        this(context, null);
    }

    public SwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        this.setWillNotDraw(false);
        this.mProgressBar = new SwipeProgressBar((View)this);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mProgressBarHeight = (int)(metrics.density * 4.0f);
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mAccelerateInterpolator = new AccelerateInterpolator(1.5f);
        TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
        this.setEnabled(a.getBoolean(0, true));
        a.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.removeCallbacks(this.mCancel);
        this.removeCallbacks(this.mReturnToStartPosition);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mReturnToStartPosition);
        this.removeCallbacks(this.mCancel);
    }

    private void animateOffsetToStartPosition(int from, Animation.AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration((long)this.mMediumAnimationDuration);
        this.mAnimateToStartPosition.setAnimationListener(listener);
        this.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        this.mTarget.startAnimation(this.mAnimateToStartPosition);
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mListener = listener;
    }

    private void setTriggerPercentage(float percent) {
        if (percent == 0.0f) {
            this.mCurrPercentage = 0.0f;
            return;
        }
        this.mCurrPercentage = percent;
        this.mProgressBar.setTriggerPercentage(percent);
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mRefreshing != refreshing) {
            this.ensureTarget();
            this.mCurrPercentage = 0.0f;
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.mProgressBar.start();
            } else {
                this.mProgressBar.stop();
            }
        }
    }

    @Deprecated
    public void setColorScheme(int colorRes1, int colorRes2, int colorRes3, int colorRes4) {
        this.setColorSchemeResources(colorRes1, colorRes2, colorRes3, colorRes4);
    }

    public void setColorSchemeResources(int colorRes1, int colorRes2, int colorRes3, int colorRes4) {
        Resources res = this.getResources();
        this.setColorSchemeColors(res.getColor(colorRes1), res.getColor(colorRes2), res.getColor(colorRes3), res.getColor(colorRes4));
    }

    public void setColorSchemeColors(int color1, int color2, int color3, int color4) {
        this.ensureTarget();
        this.mProgressBar.setColorScheme(color1, color2, color3, color4);
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            if (this.getChildCount() > 1 && !this.isInEditMode()) {
                throw new IllegalStateException("SwipeRefreshLayout can host only one direct child");
            }
            this.mTarget = this.getChildAt(0);
            this.mOriginalOffsetTop = this.mTarget.getTop() + this.getPaddingTop();
        }
        if (this.mDistanceToTriggerSync == -1.0f && this.getParent() != null && ((View)this.getParent()).getHeight() > 0) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mDistanceToTriggerSync = (int)Math.min((float)((View)this.getParent()).getHeight() * 0.6f, 120.0f * metrics.density);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mProgressBar.draw(canvas);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        this.mProgressBar.setBounds(0, 0, width, this.mProgressBarHeight);
        if (this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(0);
        int childLeft = this.getPaddingLeft();
        int childTop = this.mCurrentTargetOffsetTop + this.getPaddingTop();
        int childWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() > 1 && !this.isInEditMode()) {
            throw new IllegalStateException("SwipeRefreshLayout can host only one direct child");
        }
        if (this.getChildCount() > 0) {
            this.getChildAt(0).measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
        }
    }

    public boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically(this.mTarget, -1);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        int action = MotionEventCompat.getActionMasked(ev);
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp()) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, 0);
                this.mIsBeingDragged = false;
                this.mCurrPercentage = 0.0f;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but don't have an active pointer id.");
                    return false;
                }
                int pointerIndex = MotionEventCompat.findPointerIndex(ev, this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but have an invalid active pointer id.");
                    return false;
                }
                float y = MotionEventCompat.getY(ev, pointerIndex);
                float yDiff = y - this.mInitialMotionY;
                if (!(yDiff > (float)this.mTouchSlop)) break;
                this.mLastMotionY = y;
                this.mIsBeingDragged = true;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mCurrPercentage = 0.0f;
                this.mActivePointerId = -1;
            }
        }
        return this.mIsBeingDragged;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked(ev);
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp()) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, 0);
                this.mIsBeingDragged = false;
                this.mCurrPercentage = 0.0f;
                break;
            }
            case 2: {
                int pointerIndex = MotionEventCompat.findPointerIndex(ev, this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but have an invalid active pointer id.");
                    return false;
                }
                float y = MotionEventCompat.getY(ev, pointerIndex);
                float yDiff = y - this.mInitialMotionY;
                if (!this.mIsBeingDragged && yDiff > (float)this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                }
                if (!this.mIsBeingDragged) break;
                if (yDiff > this.mDistanceToTriggerSync) {
                    this.startRefresh();
                } else {
                    this.setTriggerPercentage(this.mAccelerateInterpolator.getInterpolation(yDiff / this.mDistanceToTriggerSync));
                    this.updateContentOffsetTop((int)yDiff);
                    if (this.mLastMotionY > y && this.mTarget.getTop() == this.getPaddingTop()) {
                        this.removeCallbacks(this.mCancel);
                    } else {
                        this.updatePositionTimeout();
                    }
                }
                this.mLastMotionY = y;
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex(ev);
                this.mLastMotionY = MotionEventCompat.getY(ev, index);
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mCurrPercentage = 0.0f;
                this.mActivePointerId = -1;
                return false;
            }
        }
        return true;
    }

    private void startRefresh() {
        this.removeCallbacks(this.mCancel);
        this.mReturnToStartPosition.run();
        this.setRefreshing(true);
        this.mListener.onRefresh();
    }

    private void updateContentOffsetTop(int targetTop) {
        int currentTop = this.mTarget.getTop();
        if ((float)targetTop > this.mDistanceToTriggerSync) {
            targetTop = (int)this.mDistanceToTriggerSync;
        } else if (targetTop < 0) {
            targetTop = 0;
        }
        this.setTargetOffsetTopAndBottom(targetTop - currentTop);
    }

    private void setTargetOffsetTopAndBottom(int offset) {
        this.mTarget.offsetTopAndBottom(offset);
        this.mCurrentTargetOffsetTop = this.mTarget.getTop();
    }

    private void updatePositionTimeout() {
        this.removeCallbacks(this.mCancel);
        this.postDelayed(this.mCancel, 300L);
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex(ev);
        int pointerId = MotionEventCompat.getPointerId(ev, pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = MotionEventCompat.getY(ev, newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId(ev, newPointerIndex);
        }
    }

    private class BaseAnimationListener
    implements Animation.AnimationListener {
        private BaseAnimationListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

