/*
 * Decompiled with CFR 0.152.
 */
package androidx.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintManager;
import android.print.pdf.PrintedPdfDocument;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PrintHelperKitkat {
    private static final String LOG_TAG = "PrintHelperKitkat";
    private static final int MAX_PRINT_SIZE = 3500;
    final Context mContext;
    BitmapFactory.Options mDecodeOptions = null;
    private final Object mLock = new Object();
    public static final int SCALE_MODE_FIT = 1;
    public static final int SCALE_MODE_FILL = 2;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final int COLOR_MODE_COLOR = 2;
    int mScaleMode = 2;
    int mColorMode = 2;
    int mOrientation = 1;

    PrintHelperKitkat(Context context) {
        this.mContext = context;
    }

    public void setScaleMode(int scaleMode) {
        this.mScaleMode = scaleMode;
    }

    public int getScaleMode() {
        return this.mScaleMode;
    }

    public void setColorMode(int colorMode) {
        this.mColorMode = colorMode;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public void printBitmap(final String jobName, final Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        final int fittingMode = this.mScaleMode;
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        PrintAttributes.MediaSize mediaSize = PrintAttributes.MediaSize.UNKNOWN_PORTRAIT;
        if (bitmap.getWidth() > bitmap.getHeight()) {
            mediaSize = PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE;
        }
        PrintAttributes attr = new PrintAttributes.Builder().setMediaSize(mediaSize).setColorMode(this.mColorMode).build();
        printManager.print(jobName, new PrintDocumentAdapter(){
            private PrintAttributes mAttributes;

            public void onLayout(PrintAttributes oldPrintAttributes, PrintAttributes newPrintAttributes, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                this.mAttributes = newPrintAttributes;
                PrintDocumentInfo info = new PrintDocumentInfo.Builder(jobName).setContentType(1).setPageCount(1).build();
                boolean changed = !newPrintAttributes.equals((Object)oldPrintAttributes);
                layoutResultCallback.onLayoutFinished(info, changed);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onWrite(PageRange[] pageRanges, ParcelFileDescriptor fileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                PrintedPdfDocument pdfDocument = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                try {
                    PdfDocument.Page page = pdfDocument.startPage(1);
                    RectF content = new RectF(page.getInfo().getContentRect());
                    Matrix matrix = PrintHelperKitkat.this.getMatrix(bitmap.getWidth(), bitmap.getHeight(), content, fittingMode);
                    page.getCanvas().drawBitmap(bitmap, matrix, null);
                    pdfDocument.finishPage(page);
                    try {
                        pdfDocument.writeTo((OutputStream)new FileOutputStream(fileDescriptor.getFileDescriptor()));
                        writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                    }
                    catch (IOException ioe) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)ioe);
                        writeResultCallback.onWriteFailed(null);
                    }
                }
                finally {
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                    if (fileDescriptor != null) {
                        try {
                            fileDescriptor.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }, attr);
    }

    private Matrix getMatrix(int imageWidth, int imageHeight, RectF content, int fittingMode) {
        Matrix matrix = new Matrix();
        float scale = content.width() / (float)imageWidth;
        scale = fittingMode == 2 ? Math.max(scale, content.height() / (float)imageHeight) : Math.min(scale, content.height() / (float)imageHeight);
        matrix.postScale(scale, scale);
        float translateX = (content.width() - (float)imageWidth * scale) / 2.0f;
        float translateY = (content.height() - (float)imageHeight * scale) / 2.0f;
        matrix.postTranslate(translateX, translateY);
        return matrix;
    }

    public void printBitmap(final String jobName, final Uri imageFile) throws FileNotFoundException {
        final int fittingMode = this.mScaleMode;
        PrintDocumentAdapter printDocumentAdapter = new PrintDocumentAdapter(){
            private PrintAttributes mAttributes;
            AsyncTask<Uri, Boolean, Bitmap> loadBitmap;
            Bitmap mBitmap = null;

            public void onLayout(final PrintAttributes oldPrintAttributes, final PrintAttributes newPrintAttributes, final CancellationSignal cancellationSignal, final PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                if (cancellationSignal.isCanceled()) {
                    layoutResultCallback.onLayoutCancelled();
                    this.mAttributes = newPrintAttributes;
                    return;
                }
                if (this.mBitmap != null) {
                    PrintDocumentInfo info = new PrintDocumentInfo.Builder(jobName).setContentType(1).setPageCount(1).build();
                    boolean changed = !newPrintAttributes.equals((Object)oldPrintAttributes);
                    layoutResultCallback.onLayoutFinished(info, changed);
                    return;
                }
                this.loadBitmap = new AsyncTask<Uri, Boolean, Bitmap>(){

                    protected void onPreExecute() {
                        cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                            public void onCancel() {
                                this.cancelLoad();
                                this.cancel(false);
                            }
                        });
                    }

                    protected Bitmap doInBackground(Uri ... uris) {
                        try {
                            return PrintHelperKitkat.this.loadConstrainedBitmap(imageFile, 3500);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        super.onPostExecute((Object)bitmap);
                        mBitmap = bitmap;
                        if (bitmap != null) {
                            PrintDocumentInfo info = new PrintDocumentInfo.Builder(jobName).setContentType(1).setPageCount(1).build();
                            boolean changed = !newPrintAttributes.equals((Object)oldPrintAttributes);
                            layoutResultCallback.onLayoutFinished(info, changed);
                        } else {
                            layoutResultCallback.onLayoutFailed(null);
                        }
                    }

                    protected void onCancelled(Bitmap result) {
                        layoutResultCallback.onLayoutCancelled();
                    }
                };
                this.loadBitmap.execute((Object[])new Uri[0]);
                this.mAttributes = newPrintAttributes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void cancelLoad() {
                Object object = PrintHelperKitkat.this.mLock;
                synchronized (object) {
                    if (PrintHelperKitkat.this.mDecodeOptions != null) {
                        PrintHelperKitkat.this.mDecodeOptions.requestCancelDecode();
                        PrintHelperKitkat.this.mDecodeOptions = null;
                    }
                }
            }

            public void onFinish() {
                super.onFinish();
                this.cancelLoad();
                this.loadBitmap.cancel(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onWrite(PageRange[] pageRanges, ParcelFileDescriptor fileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                PrintedPdfDocument pdfDocument = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                try {
                    PdfDocument.Page page = pdfDocument.startPage(1);
                    RectF content = new RectF(page.getInfo().getContentRect());
                    Matrix matrix = PrintHelperKitkat.this.getMatrix(this.mBitmap.getWidth(), this.mBitmap.getHeight(), content, fittingMode);
                    page.getCanvas().drawBitmap(this.mBitmap, matrix, null);
                    pdfDocument.finishPage(page);
                    try {
                        pdfDocument.writeTo((OutputStream)new FileOutputStream(fileDescriptor.getFileDescriptor()));
                        writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                    }
                    catch (IOException ioe) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)ioe);
                        writeResultCallback.onWriteFailed(null);
                    }
                }
                finally {
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                    if (fileDescriptor != null) {
                        try {
                            fileDescriptor.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        };
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        PrintAttributes.Builder builder = new PrintAttributes.Builder();
        builder.setColorMode(this.mColorMode);
        if (this.mOrientation == 1) {
            builder.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE);
        } else if (this.mOrientation == 2) {
            builder.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_PORTRAIT);
        }
        PrintAttributes attr = builder.build();
        printManager.print(jobName, printDocumentAdapter, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap loadConstrainedBitmap(Uri uri, int maxSideLength) throws FileNotFoundException {
        if (maxSideLength <= 0 || uri == null || this.mContext == null) {
            throw new IllegalArgumentException("bad argument to getScaledBitmap");
        }
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inJustDecodeBounds = true;
        this.loadBitmap(uri, opt);
        int w = opt.outWidth;
        int h = opt.outHeight;
        if (w <= 0 || h <= 0) {
            return null;
        }
        int imageSide = Math.max(w, h);
        int sampleSize = 1;
        while (imageSide > maxSideLength) {
            imageSide >>>= 1;
            sampleSize <<= 1;
        }
        if (sampleSize <= 0 || 0 >= Math.min(w, h) / sampleSize) {
            return null;
        }
        BitmapFactory.Options decodeOptions = null;
        Object object = this.mLock;
        synchronized (object) {
            this.mDecodeOptions = new BitmapFactory.Options();
            this.mDecodeOptions.inMutable = true;
            this.mDecodeOptions.inSampleSize = sampleSize;
            decodeOptions = this.mDecodeOptions;
        }
        try {
            object = this.loadBitmap(uri, decodeOptions);
            return object;
        }
        finally {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mDecodeOptions = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap loadBitmap(Uri uri, BitmapFactory.Options o) throws FileNotFoundException {
        if (uri == null || this.mContext == null) {
            throw new IllegalArgumentException("bad argument to loadBitmap");
        }
        InputStream is = null;
        try {
            is = this.mContext.getContentResolver().openInputStream(uri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)o);
            return bitmap;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException t) {
                    Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)t);
                }
            }
        }
    }
}

