/*
 * Decompiled with CFR 0.152.
 */
package androidx.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import androidx.print.PrintHelperKitkat;
import java.io.FileNotFoundException;

public final class PrintHelper {
    public static final int SCALE_MODE_FIT = 1;
    public static final int SCALE_MODE_FILL = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final int COLOR_MODE_COLOR = 2;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    PrintHelperVersionImpl mImpl;

    public static boolean systemSupportsPrint() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public PrintHelper(Context context) {
        this.mImpl = PrintHelper.systemSupportsPrint() ? new PrintHelperKitkatImpl(context) : new PrintHelperStubImpl();
    }

    public void setScaleMode(int scaleMode) {
        this.mImpl.setScaleMode(scaleMode);
    }

    public int getScaleMode() {
        return this.mImpl.getScaleMode();
    }

    public void setColorMode(int colorMode) {
        this.mImpl.setColorMode(colorMode);
    }

    public int getColorMode() {
        return this.mImpl.getColorMode();
    }

    public void setOrientation(int orientation) {
        this.mImpl.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.mImpl.getOrientation();
    }

    public void printBitmap(String jobName, Bitmap bitmap) {
        this.mImpl.printBitmap(jobName, bitmap);
    }

    public void printBitmap(String jobName, Uri imageFile) throws FileNotFoundException {
        this.mImpl.printBitmap(jobName, imageFile);
    }

    private static final class PrintHelperKitkatImpl
    implements PrintHelperVersionImpl {
        private final PrintHelperKitkat mPrintHelper;

        PrintHelperKitkatImpl(Context context) {
            this.mPrintHelper = new PrintHelperKitkat(context);
        }

        public void setScaleMode(int scaleMode) {
            this.mPrintHelper.setScaleMode(scaleMode);
        }

        public int getScaleMode() {
            return this.mPrintHelper.getScaleMode();
        }

        public void setColorMode(int colorMode) {
            this.mPrintHelper.setColorMode(colorMode);
        }

        public int getColorMode() {
            return this.mPrintHelper.getColorMode();
        }

        public void setOrientation(int orientation) {
            this.mPrintHelper.setOrientation(orientation);
        }

        public int getOrientation() {
            return this.mPrintHelper.getOrientation();
        }

        public void printBitmap(String jobName, Bitmap bitmap) {
            this.mPrintHelper.printBitmap(jobName, bitmap);
        }

        public void printBitmap(String jobName, Uri imageFile) throws FileNotFoundException {
            this.mPrintHelper.printBitmap(jobName, imageFile);
        }
    }

    private static final class PrintHelperStubImpl
    implements PrintHelperVersionImpl {
        int mScaleMode = 2;
        int mColorMode = 2;
        int mOrientation = 1;

        private PrintHelperStubImpl() {
        }

        public void setScaleMode(int scaleMode) {
            this.mScaleMode = scaleMode;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        public void setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        public void setOrientation(int orientation) {
            this.mOrientation = orientation;
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        public int getScaleMode() {
            return this.mScaleMode;
        }

        public void printBitmap(String jobName, Bitmap bitmap) {
        }

        public void printBitmap(String jobName, Uri imageFile) {
        }
    }

    static interface PrintHelperVersionImpl {
        public void setScaleMode(int var1);

        public int getScaleMode();

        public void setColorMode(int var1);

        public int getColorMode();

        public void setOrientation(int var1);

        public int getOrientation();

        public void printBitmap(String var1, Bitmap var2);

        public void printBitmap(String var1, Uri var2) throws FileNotFoundException;
    }
}

