/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.view.View;
import android.widget.ListView;
import androidx.core.widget.AutoScrollHelper;

public class ListViewAutoScrollHelper
extends AutoScrollHelper {
    private final ListView mTarget;

    public ListViewAutoScrollHelper(ListView target) {
        super((View)target);
        this.mTarget = target;
    }

    public void scrollTargetBy(int deltaX, int deltaY) {
        ListView target = this.mTarget;
        int firstPosition = target.getFirstVisiblePosition();
        if (firstPosition == -1) {
            return;
        }
        View firstView = target.getChildAt(0);
        if (firstView == null) {
            return;
        }
        int newTop = firstView.getTop() - deltaY;
        target.setSelectionFromTop(firstPosition, newTop);
    }

    public boolean canTargetScrollHorizontally(int direction) {
        return false;
    }

    public boolean canTargetScrollVertically(int direction) {
        ListView target = this.mTarget;
        int itemCount = target.getCount();
        if (itemCount == 0) {
            return false;
        }
        int childCount = target.getChildCount();
        int firstPosition = target.getFirstVisiblePosition();
        int lastPosition = firstPosition + childCount;
        if (direction > 0) {
            View lastView;
            if (lastPosition >= itemCount && (lastView = target.getChildAt(childCount - 1)).getBottom() <= target.getHeight()) {
                return false;
            }
        } else if (direction < 0) {
            View firstView;
            if (firstPosition <= 0 && (firstView = target.getChildAt(0)).getTop() >= 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

