/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.view.ViewGroup;
import androidx.core.view.MarginLayoutParamsCompatJellybeanMr1;

public class MarginLayoutParamsCompat {
    static final MarginLayoutParamsCompatImpl IMPL;

    public static int getMarginStart(ViewGroup.MarginLayoutParams lp) {
        return IMPL.getMarginStart(lp);
    }

    public static int getMarginEnd(ViewGroup.MarginLayoutParams lp) {
        return IMPL.getMarginEnd(lp);
    }

    public static void setMarginStart(ViewGroup.MarginLayoutParams lp, int marginStart) {
        IMPL.setMarginStart(lp, marginStart);
    }

    public static void setMarginEnd(ViewGroup.MarginLayoutParams lp, int marginEnd) {
        IMPL.setMarginEnd(lp, marginEnd);
    }

    public static boolean isMarginRelative(ViewGroup.MarginLayoutParams lp) {
        return IMPL.isMarginRelative(lp);
    }

    public static int getLayoutDirection(ViewGroup.MarginLayoutParams lp) {
        return IMPL.getLayoutDirection(lp);
    }

    public static void setLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
        IMPL.setLayoutDirection(lp, layoutDirection);
    }

    public static void resolveLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
        IMPL.resolveLayoutDirection(lp, layoutDirection);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 17 ? new MarginLayoutParamsCompatImplJbMr1() : new MarginLayoutParamsCompatImplBase();
    }

    static class MarginLayoutParamsCompatImplJbMr1
    implements MarginLayoutParamsCompatImpl {
        MarginLayoutParamsCompatImplJbMr1() {
        }

        public int getMarginStart(ViewGroup.MarginLayoutParams lp) {
            return MarginLayoutParamsCompatJellybeanMr1.getMarginStart(lp);
        }

        public int getMarginEnd(ViewGroup.MarginLayoutParams lp) {
            return MarginLayoutParamsCompatJellybeanMr1.getMarginEnd(lp);
        }

        public void setMarginStart(ViewGroup.MarginLayoutParams lp, int marginStart) {
            MarginLayoutParamsCompatJellybeanMr1.setMarginStart(lp, marginStart);
        }

        public void setMarginEnd(ViewGroup.MarginLayoutParams lp, int marginEnd) {
            MarginLayoutParamsCompatJellybeanMr1.setMarginEnd(lp, marginEnd);
        }

        public boolean isMarginRelative(ViewGroup.MarginLayoutParams lp) {
            return MarginLayoutParamsCompatJellybeanMr1.isMarginRelative(lp);
        }

        public int getLayoutDirection(ViewGroup.MarginLayoutParams lp) {
            return MarginLayoutParamsCompatJellybeanMr1.getLayoutDirection(lp);
        }

        public void setLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
            MarginLayoutParamsCompatJellybeanMr1.setLayoutDirection(lp, layoutDirection);
        }

        public void resolveLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
            MarginLayoutParamsCompatJellybeanMr1.resolveLayoutDirection(lp, layoutDirection);
        }
    }

    static class MarginLayoutParamsCompatImplBase
    implements MarginLayoutParamsCompatImpl {
        MarginLayoutParamsCompatImplBase() {
        }

        public int getMarginStart(ViewGroup.MarginLayoutParams lp) {
            return lp.leftMargin;
        }

        public int getMarginEnd(ViewGroup.MarginLayoutParams lp) {
            return lp.rightMargin;
        }

        public void setMarginStart(ViewGroup.MarginLayoutParams lp, int marginStart) {
            lp.leftMargin = marginStart;
        }

        public void setMarginEnd(ViewGroup.MarginLayoutParams lp, int marginEnd) {
            lp.rightMargin = marginEnd;
        }

        public boolean isMarginRelative(ViewGroup.MarginLayoutParams lp) {
            return false;
        }

        public int getLayoutDirection(ViewGroup.MarginLayoutParams lp) {
            return 0;
        }

        public void setLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
        }

        public void resolveLayoutDirection(ViewGroup.MarginLayoutParams lp, int layoutDirection) {
        }
    }

    static interface MarginLayoutParamsCompatImpl {
        public int getMarginStart(ViewGroup.MarginLayoutParams var1);

        public int getMarginEnd(ViewGroup.MarginLayoutParams var1);

        public void setMarginStart(ViewGroup.MarginLayoutParams var1, int var2);

        public void setMarginEnd(ViewGroup.MarginLayoutParams var1, int var2);

        public boolean isMarginRelative(ViewGroup.MarginLayoutParams var1);

        public int getLayoutDirection(ViewGroup.MarginLayoutParams var1);

        public void setLayoutDirection(ViewGroup.MarginLayoutParams var1, int var2);

        public void resolveLayoutDirection(ViewGroup.MarginLayoutParams var1, int var2);
    }
}

